if not LuaDate then LuaDate = require "LuaDate" end

function EPOCHTODATE(epoch)
  if not epoch then return nil end
  local epotb = LuaDate(epoch/1000):tolocal()
  return {
  year = epotb:getyear(),
  month = epotb:getmonth(),
  day = epotb:getday(),
  }
end

function EPOCHTOTIME(epoch)
  if not epoch then return nil end
  local epotb = LuaDate(epoch/1000):tolocal()
  return {
  hour = epotb:gethours(),
  min = epotb:getminutes(),
  sec = epotb:getseconds(),
  msec = math.floor(epotb:getticks()/1000)
  } 
end

function EPOCHTOTIMESTAMP(epoch)
  if not epoch then return nil end
  local epotb = LuaDate(epoch/1000):tolocal()
  return {
  year = epotb:getyear(),
  month = epotb:getmonth(),
  day = epotb:getday(),
  hour = epotb:gethours(),
  min = epotb:getminutes(),
  sec = epotb:getseconds(),
  msec = math.floor(epotb:getticks()/1000)
  }
end

function BAND(a, b)
  if not a or not b then return nil end
  return (a & b)
end

function BXOR(a,b)
  if not a or not b then return nil end
  return (a ~ b)
end

function BOR(a,b)
  if not a or not b then return nil end
  return (a | b)
end

function BNOT(n)
  if not n then return nil end
  return (~n)
end

function BLSHIFT(a,b)
  if not a or not b then return nil end
  return (a << b)
end

function BRSHIFT(a,b)
  if not a or not b then return nil end
  return (a >> b)
end
