/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia.borders;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import net.sourceforge.mlf.metouia.MetouiaLookAndFeel;

public class MetouiaMenuItemBorder
extends AbstractBorder
implements UIResource {
    protected static Insets insets = new Insets(1, 1, 1, 1);

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        ButtonModel model = ((JMenuItem)c).getModel();
        g.translate(x, y);
        if (c.getParent() instanceof JMenuBar) {
            if (model.isArmed() || model.isSelected()) {
                g.setColor(MetouiaLookAndFeel.getControlDarkShadow());
                g.drawLine(0, 0, w - 2, 0);
                g.drawLine(0, 0, 0, h - 1);
                g.setColor(MetouiaLookAndFeel.getPrimaryControlHighlight());
                g.drawLine(w - 1, 1, w - 1, h - 1);
            }
        } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
            g.setColor(MetouiaLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 1, 0);
            g.setColor(MetouiaLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(0, h - 1, w - 1, h - 1);
        } else {
            g.setColor(MetouiaLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(0, 0, 0, h - 1);
        }
        g.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return insets;
    }
}

