/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia.borders;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sourceforge.mlf.metouia.MetouiaLookAndFeel;

class MetouiaDotsBuffer {
    private static Frame frame;
    private static Component component;
    private transient Image image;
    private static final int IMAGE_SIZE = 125;
    private static Dimension imageSize;
    private Color background;
    private Color highlight;
    private Color shadow;
    private Color darkshadow;
    private Color matteshadow;

    public MetouiaDotsBuffer() {
        if (frame == null) {
            frame = new Frame("bufferCreator");
        }
        if (component == null) {
            component = new Canvas();
            frame.add(component, "Center");
        }
        frame.addNotify();
        this.image = component.createImage(125, 125);
        this.background = MetalLookAndFeel.getControl();
        this.matteshadow = MetouiaLookAndFeel.getPrimaryControl();
        this.shadow = MetouiaLookAndFeel.getControlShadow();
        this.darkshadow = MetouiaLookAndFeel.getControlDarkShadow();
        this.highlight = MetouiaLookAndFeel.getPrimaryControlHighlight();
        this.fillBumpBuffer();
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = component.createImage(125, 125);
            this.fillBumpBuffer();
        }
        return this.image;
    }

    public Dimension getImageSize() {
        return imageSize;
    }

    protected void fillBumpBuffer() {
        int y;
        int x;
        Graphics g = this.image.getGraphics();
        g.setColor(this.background);
        g.fillRect(0, 0, 125, 125);
        g.setColor(this.matteshadow);
        for (x = 0; x < 125; x += 5) {
            for (y = 0; y < 125; y += 5) {
                g.drawLine(x, y, x, y);
            }
        }
        g.setColor(this.shadow);
        for (x = 1; x < 125; x += 5) {
            for (y = 0; y < 125; y += 5) {
                g.drawLine(x, y, x, y);
                g.drawLine(x - 1, y + 1, x - 1, y + 1);
            }
        }
        g.setColor(this.darkshadow);
        for (x = 1; x < 125; x += 5) {
            for (y = 1; y < 125; y += 5) {
                g.drawLine(x, y, x, y);
            }
        }
        g.setColor(this.highlight);
        for (x = 2; x < 125; x += 5) {
            for (y = 1; y < 125; y += 5) {
                g.drawLine(x, y, x, y + 1);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
            }
        }
        g.dispose();
    }

    static {
        imageSize = new Dimension(125, 125);
    }
}

