/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia.borders;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import net.sourceforge.mlf.metouia.borders.MetouiaBorderUtilities;

public class MetouiaButtonBorder
extends AbstractBorder
implements UIResource {
    protected static final Insets insets = new Insets(2, 2, 2, 2);

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        JButton button = (JButton)c;
        ButtonModel model = ((JButton)c).getModel();
        if (model.isEnabled()) {
            if (model.isPressed() && model.isArmed()) {
                MetouiaBorderUtilities.drawPressed3DBorder(g, x, y, w, h);
            } else if (button.isDefaultButton()) {
                MetouiaBorderUtilities.drawDefaultButtonBorder(g, x, y, w, h);
            } else if (button.isRolloverEnabled()) {
                if (model.isRollover()) {
                    MetouiaBorderUtilities.drawSimple3DBorder(g, x, y, w, h);
                }
            } else {
                MetouiaBorderUtilities.drawSimple3DBorder(g, x, y, w, h);
            }
        } else if (!button.isRolloverEnabled()) {
            MetouiaBorderUtilities.drawDisabledBorder(g, x, y, w - 1, h - 1);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return insets;
    }
}

