/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolBarUI;
import net.sourceforge.mlf.metouia.MetouiaGradients;

public class MetouiaToolBarUI
extends MetalToolBarUI {
    private static final MetouiaToolBarUI toolBarUI = new MetouiaToolBarUI();
    private Insets insets = new Insets(2, 2, 2, 2);

    public static ComponentUI createUI(JComponent c) {
        return toolBarUI;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        int orientation = 0;
        if (c instanceof JToolBar) {
            orientation = ((JToolBar)c).getOrientation();
        }
        if (orientation == 0) {
            MetouiaGradients.drawHorizontalHighlight(g, c);
            MetouiaGradients.drawHorizontalShadow(g, c);
        } else {
            MetouiaGradients.drawVerticalHighlight(g, c);
            MetouiaGradients.drawVerticalShadow(g, c);
        }
    }

    @Override
    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)c;
            if (!button.isRolloverEnabled()) {
                button.setRolloverEnabled(true);
            }
            if (button.isContentAreaFilled()) {
                button.setContentAreaFilled(false);
            }
            if (button.isFocusPainted()) {
                button.setFocusPainted(false);
            }
            button.setMargin(this.insets);
        }
    }
}

