/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.sourceforge.mlf.metouia.MetouiaDefaultTheme;
import net.sourceforge.mlf.metouia.borders.MetouiaBorderUtilities;
import net.sourceforge.mlf.metouia.borders.MetouiaInternalFrameBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaMenuBarBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaMenuItemBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaOptionDialogBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaPaletteBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaPopupMenuBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaScrollPaneBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaTableHeaderBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaToolBarBorder;

public class MetouiaLookAndFeel
extends MetalLookAndFeel {
    protected static MetouiaDefaultTheme metouiaTheme;
    private static boolean isInstalled;
    private static boolean themeHasBeenSet;

    public MetouiaLookAndFeel() {
        if (!isInstalled) {
            isInstalled = true;
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("Metouia", "net.sourceforge.mlf.metouia.MetouiaLookAndFeel"));
        }
    }

    @Override
    public String getID() {
        return "Metouia";
    }

    @Override
    public String getName() {
        return "Metouia";
    }

    @Override
    public String getDescription() {
        return "Metouia Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        table.putDefaults(new Object[]{"ButtonUI", "net.sourceforge.mlf.metouia.MetouiaButtonUI", "CheckBoxUI", "net.sourceforge.mlf.metouia.MetouiaCheckBoxUI", "TextFieldUI", "net.sourceforge.mlf.metouia.MetouiaTextFieldUI", "ListUI", "net.sourceforge.mlf.metouia.MetouiaListUI", "TreeUI", "net.sourceforge.mlf.metouia.MetouiaTreeUI", "ToolBarUI", "net.sourceforge.mlf.metouia.MetouiaToolBarUI", "MenuBarUI", "net.sourceforge.mlf.metouia.MetouiaMenuBarUI", "MenuUI", "net.sourceforge.mlf.metouia.MetouiaMenuUI", "ScrollBarUI", "net.sourceforge.mlf.metouia.MetouiaScrollBarUI", "TabbedPaneUI", "net.sourceforge.mlf.metouia.MetouiaTabbedPaneUI", "ToggleButtonUI", "net.sourceforge.mlf.metouia.MetouiaToggleButtonUI", "PasswordFieldUI", "net.sourceforge.mlf.metouia.MetouiaPasswordFieldUI", "ScrollPaneUI", "net.sourceforge.mlf.metouia.MetouiaScrollPaneUI", "ProgressBarUI", "net.sourceforge.mlf.metouia.MetouiaProgressBarUI", "TableHeaderUI", "net.sourceforge.mlf.metouia.MetouiaTableHeaderUI", "InternalFrameUI", "net.sourceforge.mlf.metouia.MetouiaInternalFrameUI"});
    }

    @Override
    protected void createDefaultTheme() {
        if (!themeHasBeenSet) {
            metouiaTheme = new MetouiaDefaultTheme();
            MetouiaLookAndFeel.setCurrentTheme(metouiaTheme);
        }
    }

    public static void setCurrentTheme(MetalTheme theme) {
        MetalLookAndFeel.setCurrentTheme(theme);
        themeHasBeenSet = true;
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("textHighlight", MetouiaLookAndFeel.getTextHighlightColor());
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        table.put("Button.border", MetouiaBorderUtilities.getButtonBorder());
        table.put("ToggleButton.border", MetouiaBorderUtilities.getToggleButtonBorder());
        table.put("TextField.border", MetouiaBorderUtilities.getTextFieldBorder());
        table.put("ToolBar.border", new MetouiaToolBarBorder());
        table.put("MenuBar.border", new MetouiaMenuBarBorder());
        table.put("ScrollPane.border", new MetouiaScrollPaneBorder());
        table.put("InternalFrame.border", new MetouiaInternalFrameBorder());
        table.put("InternalFrame.paletteBorder", new MetouiaPaletteBorder());
        table.put("InternalFrame.optionDialogBorder", new MetouiaOptionDialogBorder());
        MetouiaMenuItemBorder border = new MetouiaMenuItemBorder();
        table.put("Menu.border", border);
        table.put("MenuItem.border", border);
        table.put("CheckBoxMenuItem.border", border);
        table.put("RadioButtonMenuItem.border", border);
        table.put("PopupMenu.border", new MetouiaPopupMenuBorder());
        table.put("TableHeader.cellBorder", new MetouiaTableHeaderBorder());
        table.put("SplitPane.dividerSize", new Integer(6));
        table.put("InternalFrame.paletteTitleHeight", new Integer(13));
        table.put("InternalFrame.frameTitleHeight", new Integer(21));
        table.put("TabbedPane.contentBorderInsets", new Insets(4, 4, 3, 3));
        table.put("Button.select", metouiaTheme.getPressedBackground());
        table.put("RadioButton.select", metouiaTheme.getPressedBackground());
        table.put("ToggleButton.select", metouiaTheme.getPressedBackground());
        table.put("Checkbox.select", metouiaTheme.getPressedBackground());
        table.put("TabbedPane.unselected", metouiaTheme.getPressedBackground());
        table.put("InternalFrame.icon", MetouiaLookAndFeel.loadIcon("default.gif", this));
        table.put("InternalFrame.paletteCloseIcon", MetouiaLookAndFeel.loadIcon("pclose.gif", this));
        table.put("InternalFrame.closeIcon", MetouiaLookAndFeel.loadIcon("close.gif", this));
        table.put("InternalFrame.maximizeIcon", MetouiaLookAndFeel.loadIcon("maximize.gif", this));
        table.put("InternalFrame.iconifyIcon", MetouiaLookAndFeel.loadIcon("minimize.gif", this));
        table.put("InternalFrame.minimizeIcon", MetouiaLookAndFeel.loadIcon("restore.gif", this));
    }

    static ImageIcon loadIcon(String file, Object invoker) {
        file = "/net/sourceforge/mlf/metouia/icons/" + file;
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(MetouiaLookAndFeel.readStream(invoker.getClass().getResourceAsStream(file))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error getting resource " + file);
            return null;
        }
    }

    static final byte[] readStream(InputStream input) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        try {
            int read;
            while ((read = input.read(buffer, 0, 256)) != -1) {
                bytes.write(buffer, 0, read);
            }
        }
        catch (IOException exception) {
            throw (IOException)exception.fillInStackTrace();
        }
        return bytes.toByteArray();
    }

    public static Color getGradientReflection() {
        return metouiaTheme.getGradientReflection();
    }

    public static Color getGradientShadow() {
        return metouiaTheme.getGradientShadow();
    }

    public static Color getGradientTranslucentReflection() {
        return metouiaTheme.getGradientTranslucentReflection();
    }

    public static Color getGradientTranslucentShadow() {
        return metouiaTheme.getGradientTranslucentShadow();
    }

    static {
        isInstalled = false;
        themeHasBeenSet = false;
    }
}

