/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.jdbc;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.DbaButton;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.ut.textField.FilePathField;
import com.syscom.xml.xtm.gui.XTMFrame;
import com.syscom.xml.xtm.jdbc.JdbcDriverDetail;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JdbcDriverDetailDlg
extends JDialog {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.jdbc.resource.Res", LocaleManager.getLocale());
    private DbaButton okButton = new DbaButton(this.res.getString("Ok"), 'O', new ReflectionAction(this, "okButton_actionPerformed"));
    private DbaButton cancelButton = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancelButton_actionPerformed"));
    private DbaButton helpButton = new DbaButton(this.res.getString("Help"), 'H');
    private JdbcDriverDetail detail = null;
    private JTextField classnameField = new JTextField();
    private JTextField prefixField = new JTextField();
    private FilePathField classpathField = new FilePathField(this, this.res.getString("select"), null);

    public static JdbcDriverDetailDlg createJdbcDriverDetailDlg(JDialog parent, JdbcDriverDetail detail) {
        JdbcDriverDetailDlg dlg = null;
        dlg = GuiUt.isWindows() ? new JdbcDriverDetailDlg((Dialog)parent, detail) : new JdbcDriverDetailDlg((Dialog)parent, true, detail);
        return dlg;
    }

    private JdbcDriverDetailDlg(Dialog parent, boolean modal, JdbcDriverDetail detail) {
        super(parent, "", modal);
        this.detail = detail;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JdbcDriverDetailDlg(Dialog parent, JdbcDriverDetail detail) {
        super(parent);
        this.setModal(true);
        this.detail = detail;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setResizable(false);
        this.okButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/ok.gif"));
        this.cancelButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/cancel.gif"));
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/help.gif"));
        this.setTitle(this.res.getString("JDBC_driver_detail"));
        TextFieldChangedListener listener = new TextFieldChangedListener();
        this.classpathField.addPropertyChangeListener(listener);
        this.classnameField.addPropertyChangeListener(listener);
        this.classpathField.addActionListener(listener);
        JPanel panel1 = new JPanel(new BorderLayout(5, 5));
        JPanel panel2 = new JPanel(new FlowLayout());
        panel2.add(this.okButton);
        panel2.add(this.cancelButton);
        panel2.add(this.helpButton);
        XTMFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "jdbcdriverdetaildlg");
        this.classpathField.setBorder(BorderFactory.createEtchedBorder());
        this.classpathField.setFileSelectionMode(2);
        JPanel panel3 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel3.add(this.getPanel(new JLabel(this.res.getString("Class_name_")), this.classnameField));
        panel3.add(this.getPanel(new JLabel(this.res.getString("Prefix_for_data")), this.prefixField));
        panel3.add(this.getPanel(new JLabel(this.res.getString("Class_path_")), this.classpathField));
        panel1.add((Component)panel3, "Center");
        panel1.add((Component)panel2, "South");
        if (this.detail != null) {
            this.classnameField.setText(this.detail.getClassname());
            this.prefixField.setText(this.detail.getPrefix());
            this.classpathField.setText(this.detail.getClasspath());
        }
        this.getContentPane().add(panel1);
        this.setButtonStatus();
    }

    private JPanel getPanel(JLabel label, JComponent comp) {
        JPanel panel = new JPanel(new BorderLayout());
        label.setPreferredSize(new Dimension(160, 22));
        comp.setPreferredSize(new Dimension(240, 22));
        panel.add((Component)label, "West");
        panel.add((Component)comp, "Center");
        return panel;
    }

    public void okButton_actionPerformed(ActionEvent e) {
        String classname = this.classnameField.getText();
        String prefix = this.prefixField.getText();
        String classpath = this.classpathField.getText();
        if (this.detail == null) {
            this.detail = new JdbcDriverDetail(classname, prefix, classpath);
        } else {
            this.detail.setClassname(classname);
            this.detail.setPrefix(prefix);
            this.detail.setClasspath(classpath);
        }
        this.setVisible(false);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.detail = null;
        this.setVisible(false);
    }

    public JdbcDriverDetail getJdbcDriverDetail() {
        return this.detail;
    }

    private void setButtonStatus() {
        String classname = this.classnameField.getText();
        String classpath = this.classpathField.getText();
        if (classname.trim().length() == 0 || classpath.trim().length() == 0) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    private class TextFieldChangedListener
    implements PropertyChangeListener,
    ActionListener {
        private TextFieldChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JdbcDriverDetailDlg.this.setButtonStatus();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JdbcDriverDetailDlg.this.setButtonStatus();
        }
    }
}

