/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.gui;

import com.syscom.tree.AbstractDmMutableTreeNode;
import com.syscom.tree.DmTree;
import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleChangeListener;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.ut.resource.HelpResourceBundle;
import com.syscom.xml.treeBuilder.SchemaTreeBuilder;
import com.syscom.xml.treeBuilder.XtmTreeBuilder;
import com.syscom.xml.xtm.Preferences;
import com.syscom.xml.xtm.XtmInfo;
import com.syscom.xml.xtm.gui.XTMMenubar;
import com.syscom.xml.xtm.gui.XTMToolBar;
import com.syscom.xml.xtm.node.XslTemplateNode;
import com.syscom.xml.xtm.node.XtmConnectNode;
import com.syscom.xml.xtm.treetable.XpathTableCellRenderer;
import com.syscom.xml.xtm.treetable.XtmTreeTable;
import com.syscom.xml.xtm.treetable.XtmTreeTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableColumn;
import javax.swing.undo.UndoableEdit;

public class XTMFrame
extends JFrame
implements LocaleChangeListener {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
    public static XTMFrame frame = null;
    private XtmInfo info = null;
    private Preferences pref = Preferences.getPreferences();
    private XTMMenubar menubar = null;
    private XTMToolBar toolbar = null;
    private JSplitPane vertical = new JSplitPane(1);
    private JSplitPane horizontal = new JSplitPane(0);
    private JPanel xtmTPanel = new JPanel(new BorderLayout());
    private JPanel xmlTPanel = new JPanel(new BorderLayout());
    private JPanel dbTPanel = new JPanel(new BorderLayout());
    private JLabel statusBar = new JLabel(" ");
    private JLabel xtmFilenameLabel = new JLabel(" ");
    private JLabel xmlSchemaLabel = new JLabel(" ");
    private JLabel dbSchemaLabel = new JLabel(" ");
    private HelpSet mainHS = null;
    private DefaultHelpBroker mainHB = null;
    private HelpResourceBundle helpres = null;
    private ActionListener cshListener_menuitem = null;

    public XTMFrame() {
        frame = this;
        this.setIconImage(DBAImageResource.getResource(this.getClass(), "/images/tree/xtm/xtm.gif").getImage());
        this.setSize(this.pref.getFrameWidth(), this.pref.getFrameHeight());
        this.setLocation(this.pref.getLocation());
        this.menubar = new XTMMenubar();
        this.toolbar = new XTMToolBar(this.menubar);
        this.setTitle(this.res.getString("XML_Transfer_Mapping"));
        this.setJMenuBar(this.menubar);
        this.horizontal.add((Component)this.xmlTPanel, "top");
        this.horizontal.add((Component)this.dbTPanel, "bottom");
        this.vertical.add((Component)this.xtmTPanel, "left");
        this.vertical.add((Component)this.horizontal, "right");
        this.vertical.setDividerLocation(this.pref.getVerticalDividerLocation());
        this.horizontal.setDividerLocation(this.pref.getHorizontalDividerLocation());
        this.initHelpSet();
        this.menubar.setActionStatus();
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.vertical, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    private static String getHelpSetName() {
        String s = "JXML.hs";
        switch (LocaleManager.getHelpFileLanguage()) {
            default: 
        }
        s = "JXML.hs";
        return s;
    }

    private void initHelpSet() {
        String helpsetName = XTMFrame.getHelpSetName();
        JMenuItem helpMenuItem = this.menubar.getHelpButton();
        try {
            this.mainHS = null;
            this.mainHB = null;
            this.helpres = new HelpResourceBundle("com.syscom.xml.xtm.gui.resource.help");
            String helpid = this.helpres.getString("home");
            ClassLoader cl = XTMFrame.class.getClassLoader();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)helpsetName);
            this.mainHS = new HelpSet(cl, url);
            this.mainHB = (DefaultHelpBroker)this.mainHS.createHelpBroker();
            this.mainHB.enableHelpKey((Component)this.getRootPane(), helpid, null);
            this.cshListener_menuitem = new CSH.DisplayHelpFromSource((HelpBroker)this.mainHB);
            helpMenuItem.addActionListener(this.cshListener_menuitem);
            helpMenuItem.setEnabled(true);
            CSH.setHelpIDString((Component)this, (String)helpid);
            this.mainHB.enableHelpKey((Component)helpMenuItem, helpid, null);
        }
        catch (Exception ex) {
            System.out.println("Help Set " + helpsetName + " not found");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            helpMenuItem.setEnabled(false);
        }
    }

    public void enableDialogHelp(Component comp, JButton button, String id) {
        if (this.mainHB == null) {
            button.setEnabled(false);
            return;
        }
        String helpid = this.helpres.getString(id);
        if (comp != null) {
            this.mainHB.enableHelpKey(comp, helpid, this.mainHS);
        }
        if (button != null) {
            this.mainHB.enableHelpOnButton((Component)button, helpid, this.mainHS);
        }
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
        this.setTitle(this.res.getString("XML_Transfer_Mapping"));
        if (this.info != null) {
            if (this.info.schemafile != null) {
                this.xmlSchemaLabel.setText(this.res.getString("XML_schema_") + this.info.schemafile);
            }
            if (this.info.datasource != null) {
                this.dbSchemaLabel.setText(this.res.getString("Data_source_") + this.info.datasource);
            }
            this.setXtmFilename();
        }
    }

    public int getVerticalDividerLocation() {
        return this.vertical.getDividerLocation();
    }

    public int getHorizontalDividerLocation() {
        return this.horizontal.getDividerLocation();
    }

    public XTMMenubar getXTMMenuBar() {
        return this.menubar;
    }

    public Preferences getPreferences() {
        return this.pref;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        int state;
        if (e.getID() == 201 && (state = this.menubar.closeMenuitem_actionPerformed(null)) != 2 && state != 2) {
            this.exitOnClose(e);
        }
    }

    protected void exitOnClose(WindowEvent e) {
        if (e.getID() == 201) {
            try {
                this.pref.save();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (this.info != null) {
                this.info.close();
            }
        }
        System.exit(0);
    }

    private static void expandTree(JTree tree, int max, int cur) {
        if (cur >= max) {
            return;
        }
        int count = tree.getRowCount();
        for (int i = 0; i < count; ++i) {
            tree.expandRow(i);
        }
        if (tree.getRowCount() != count) {
            XTMFrame.expandTree(tree, max, cur + 1);
        }
    }

    public XtmInfo getXtmInfo() {
        return this.info;
    }

    public void clear() {
        if (this.info != null) {
            this.info.clear();
            this.info = null;
        }
        this.xmlTPanel.removeAll();
        this.xtmTPanel.removeAll();
        this.dbTPanel.removeAll();
        this.xmlTPanel.revalidate();
        this.xtmTPanel.revalidate();
        this.dbTPanel.revalidate();
        this.xmlTPanel.repaint();
        this.xtmTPanel.repaint();
        this.dbTPanel.repaint();
        this.menubar.setActionStatus();
        this.menubar.removeAllEdits();
    }

    public void setXtmFilename() {
        if (this.info == null) {
            return;
        }
        if (this.info.getDirty()) {
            this.xtmFilenameLabel.setText(this.res.getString("XTM_file_") + this.info.xtmfile + "*");
        } else {
            this.xtmFilenameLabel.setText(this.res.getString("XTM_file_") + this.info.xtmfile);
        }
    }

    public void setXtmInfo(XtmInfo info) {
        boolean dirty = info.getDirty();
        this.info = info;
        this.loadDataSource();
        this.loadXml();
        if (info.xtmfile == null) {
            info.xtmfile = info.getNextNewEditingFileName();
            this.newXtm();
        } else {
            this.loadXtm();
        }
        if (!info.xtmfile.startsWith("untitle")) {
            Preferences pref = frame.getPreferences();
            pref.addProject(info);
            this.menubar.initPreviousFiles(pref.getProjects());
        }
        info.setDirty(dirty);
        this.repaint();
    }

    private void loadXml() {
        DmTree tree = new DmTree(this.info.xmlRoot, true);
        XTMFrame.expandTree(tree, Integer.MAX_VALUE, 1);
        tree.getSelectionModel().setSelectionMode(1);
        JScrollPane panel = new JScrollPane();
        panel.getViewport().add(tree);
        this.info.xmltree = tree;
        this.xmlTPanel.removeAll();
        this.xmlTPanel.add((Component)panel, "Center");
        this.xmlSchemaLabel = new JLabel(this.res.getString("XML_schema_") + this.info.schemafile);
        this.xmlTPanel.add((Component)this.xmlSchemaLabel, "North");
        this.xmlTPanel.revalidate();
    }

    private void newXtm() {
        XslTemplateNode node1 = new XslTemplateNode();
        XtmConnectNode node2 = new XtmConnectNode(this.info);
        node1.add(node2);
        this.info.xtmRoot = node1;
        this.loadXtm();
    }

    private void loadXtm() {
        XtmTreeBuilder.initXtmColumn(this.info.xtmRoot, this.info.conn);
        XtmTreeBuilder.initXtmSetParameter(this.info.xtmRoot, this.info.conn);
        XtmTreeTable treeTable = new XtmTreeTable(new XtmTreeTableModel(this.info.xtmRoot));
        TableColumn col = treeTable.getColumnModel().getColumn(0);
        col.setWidth(300);
        col = treeTable.getColumnModel().getColumn(1);
        col.setWidth(100);
        col.setCellRenderer(new XpathTableCellRenderer());
        treeTable.getTree().setRootVisible(false);
        XTMFrame.expandTree(treeTable.getTree(), Integer.MAX_VALUE, 1);
        treeTable.setRowSelectionInterval(0, 0);
        this.info.xtmTree = treeTable;
        if (this.info.xmltree != null) {
            this.info.xmltree.addTransferableUpdateListener(treeTable);
        }
        if (this.info.dbtree != null) {
            this.info.dbtree.addTransferableUpdateListener(treeTable);
        }
        treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    XTMFrame.this.menubar.setActionStatus();
                }
            }
        });
        this.xtmTPanel.removeAll();
        JScrollPane panel = new JScrollPane();
        panel.getViewport().add(treeTable);
        this.setXtmFilename();
        this.xtmTPanel.add((Component)this.xtmFilenameLabel, "North");
        this.xtmTPanel.add((Component)panel, "Center");
        this.xtmTPanel.revalidate();
    }

    public void setActionStatus() {
        this.menubar.setActionStatus();
    }

    public void loadDataSource() {
        AbstractDmMutableTreeNode sNode = null;
        if (this.info == null || this.info.conn == null) {
            return;
        }
        sNode = SchemaTreeBuilder.getSchema(this.info.conn, this.info.driver, this.info.datasource, this.info.user, this.info.password);
        if (sNode != null) {
            DmTree tree = new DmTree(sNode, true);
            this.info.dbNode = sNode;
            this.dbTPanel.removeAll();
            JScrollPane panel = new JScrollPane();
            panel.getViewport().add(tree);
            this.info.dbtree = tree;
            this.dbTPanel.add((Component)panel, "Center");
            this.dbSchemaLabel = new JLabel(this.res.getString("Data_source_") + this.info.datasource);
            this.dbTPanel.add((Component)this.dbSchemaLabel, "North");
            this.dbTPanel.revalidate();
            this.dbTPanel.repaint();
        }
    }

    public void setWarning(String text) {
        this.statusBar.setText(text);
        this.getToolkit().beep();
    }

    public void postEdit(UndoableEdit edit) {
        this.menubar.postEdit(edit);
    }

    public UndoableEditListener getUndoableEditListener() {
        return this.menubar.getUndoableEditListener();
    }

    public void startDocumentEdit() {
        this.menubar.startDocumentEdit();
    }

    public void endDocumentEdit() {
        this.menubar.endDocumentEdit();
    }
}

