/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.gui;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.tree.DmTree;
import com.syscom.ut.GuiUt;
import com.syscom.ut.JdmConfig;
import com.syscom.ut.comp.DbaButton;
import com.syscom.ut.comp.DbaFileFilter;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.ut.textField.FilePathField;
import com.syscom.xml.node.AbstractXmlMutableTreeNode;
import com.syscom.xml.treeBuilder.DTDHandler;
import com.syscom.xml.treeBuilder.XSDParser;
import com.syscom.xml.treeBuilder.XmlTreeBuilder;
import com.syscom.xml.xtm.XtmInfo;
import com.syscom.xml.xtm.gui.SchemaChooseRootDlg;
import com.syscom.xml.xtm.gui.XTMFrame;
import com.syscom.xml.xtm.jdbc.JdbcDriverDetail;
import dbmaker.xml.XMLTransferMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class WorkspaceDlg
extends JDialog {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
    private FilePathField xmlField = new FilePathField(XTMFrame.frame, null, new FileFilter[]{new DbaFileFilter("xml", this.res.getString("XML_Document_Type")), new DbaFileFilter("dtd", this.res.getString("DTD_Document_dtd_")), new DbaFileFilter("xsd", this.res.getString("XSD_Document_xsd_"))});
    private JTextField rootField = new JTextField();
    private JButton browseButton = new JButton("...");
    private JComboBox driverComboBox = new JComboBox(XTMFrame.frame.getPreferences().getJdbcDrivers());
    private JComboBox dsComboBox = new JComboBox();
    private JTextField userTextField = new JTextField();
    private JPasswordField psTextField = new JPasswordField();
    private DbaButton okButton = new DbaButton(this.res.getString("Ok"), 'O', new WsReflectionAction(this, "okButton_actionPerformed"));
    private DbaButton cancelButton = new DbaButton(this.res.getString("Cancel"), 'C', new WsReflectionAction(this, "cancelButton_actionPerformed"));
    private DbaButton helpButton = new DbaButton(this.res.getString("Help"), 'H');
    private XtmInfo info = null;

    private WorkspaceDlg(Frame frame, boolean modal, XtmInfo info) {
        super(frame, "", modal);
        this.info = info;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private WorkspaceDlg(XtmInfo info) {
        super(XTMFrame.frame);
        this.setModal(true);
        this.info = info;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static WorkspaceDlg createWorkspaceDlg(XtmInfo info) {
        WorkspaceDlg dlg = null;
        dlg = GuiUt.isWindows() ? new WorkspaceDlg(info) : new WorkspaceDlg((Frame)XTMFrame.frame, true, info);
        return dlg;
    }

    void jbInit() throws Exception {
        this.setResizable(false);
        if (this.info == null) {
            this.info = new XtmInfo();
        }
        this.okButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/ok.gif"));
        this.cancelButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/cancel.gif"));
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/help.gif"));
        if (this.info.xtmfile != null && this.info.xtmfile.length() > 0) {
            this.setTitle(this.info.xtmfile);
        } else {
            this.setTitle(this.res.getString("New_XTM_file"));
        }
        XTMFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "workspacedlg");
        this.xmlField.setBorder(BorderFactory.createEtchedBorder());
        JPanel panel3 = new JPanel((LayoutManager)new VerticalFlowLayout(true, false));
        JPanel panel31 = new JPanel(new BorderLayout());
        panel31.add((Component)this.rootField, "Center");
        panel31.add((Component)this.browseButton, "East");
        this.rootField.setBorder(null);
        panel31.setBorder(BorderFactory.createEtchedBorder());
        this.browseButton.setMargin(new Insets(2, 2, 2, 2));
        this.browseButton.setPreferredSize(new Dimension(20, 20));
        this.xmlField.addActionListener(new WsReflectionAction(this, "xmlField_actionPerformed"));
        this.browseButton.addActionListener(new WsReflectionAction(this, "browseButton_actionPerformed"));
        this.rootField.setEditable(false);
        panel3.add(this.getPanel(new JLabel(this.res.getString("File_path_")), this.xmlField));
        panel3.add(this.getPanel(new JLabel(this.res.getString("Root_element_")), panel31));
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(true, false));
        this.driverComboBox.addActionListener(new WsReflectionAction(this, "driverComboBox_actionPerformed"));
        this.dsComboBox.setEditable(true);
        this.dsComboBox.addActionListener(new WsReflectionAction(this, "dsComboBox_actionPerformed"));
        panel2.add(this.getPanel(new JLabel(this.res.getString("JDBC_driver_")), this.driverComboBox));
        panel2.add(this.getPanel(new JLabel(this.res.getString("Data_source_")), this.dsComboBox));
        panel2.add(this.getPanel(new JLabel(this.res.getString("User_name_")), this.userTextField));
        panel2.add(this.getPanel(new JLabel(this.res.getString("Password_")), this.psTextField));
        JPanel panel4 = new JPanel(new FlowLayout(1));
        panel4.add(this.okButton);
        panel4.add(this.cancelButton);
        panel4.add(this.helpButton);
        panel3.setBorder(BorderFactory.createTitledBorder(this.res.getString("Source_schema")));
        panel2.setBorder(BorderFactory.createTitledBorder(this.res.getString("Database")));
        JPanel panel1 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel1.add(panel3);
        panel1.add(panel2);
        panel1.add(panel4);
        panel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(panel1);
        this.browseButton.setEnabled(false);
        if (this.info.schemafile != null) {
            this.xmlField.setText(this.info.schemafile);
            this.initXmlSource(this.info.schemafile);
        }
        if (this.info.xmlRootName != null && this.info.xmlRootName.length() > 0 && this.info.dummy != null && this.info.dummy.getChildCount() > 0) {
            for (AbstractXmlMutableTreeNode node = (AbstractXmlMutableTreeNode)this.info.dummy.getFirstChild(); node != null; node = (AbstractXmlMutableTreeNode)node.getNextSibling()) {
                if (node.getText().compareTo(this.info.xmlRootName) != 0) continue;
                this.info.xmlRoot = node;
                this.rootField.setText(this.info.xmlRoot.getText());
                this.browseButton.setEnabled(true);
                break;
            }
        }
        this.driverComboBox.setEditable(true);
        int index = this.getDriverIndex(this.info.driver);
        if (index < 0) {
            this.driverComboBox.setSelectedItem(this.info.driver);
        } else {
            this.driverComboBox.setSelectedIndex(index);
        }
        if (this.info.datasource != null) {
            this.dsComboBox.setSelectedItem(this.info.datasource);
        } else if (this.dsComboBox.getModel().getSize() > 0) {
            this.dsComboBox.setSelectedIndex(0);
        }
        if (this.info.user != null) {
            if (this.info.user.trim().length() > 0) {
                this.userTextField.setText(this.info.user);
            } else {
                String driver = this.driverComboBox.getSelectedItem().toString();
                String datasource = this.dsComboBox.getSelectedItem().toString();
                if (driver.compareTo(JdbcDriverDetail.DBMAKER_JDBC_DRIVER) == 0 && datasource.startsWith(JdbcDriverDetail.DBMAKER_PREFIX)) {
                    String dbname = datasource.substring(JdbcDriverDetail.DBMAKER_PREFIX.length());
                    JdmConfig config = new JdmConfig();
                    String user = JdmConfig.getDefaultUser(dbname);
                    this.userTextField.setText(user);
                }
            }
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WorkspaceDlg.this.cancelButton_actionPerformed(null);
            }
        });
    }

    private int getDriverIndex(String driver) {
        if (driver == null) {
            return 0;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.driverComboBox.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            if (model.getElementAt(i).toString().compareTo(driver) != 0) continue;
            return i;
        }
        return -1;
    }

    private JPanel getPanel(JLabel label, JComponent comp) {
        JPanel panel = new JPanel(new BorderLayout());
        label.setPreferredSize(new Dimension(100, 22));
        comp.setPreferredSize(new Dimension(300, 22));
        panel.add((Component)label, "West");
        panel.add((Component)comp, "Center");
        return panel;
    }

    public XtmInfo getXtmInfo() {
        return this.info;
    }

    public void setXtmInfo(XtmInfo info) {
        this.info = info;
    }

    private void setOkButtonStatus() {
        String ds = (String)this.dsComboBox.getSelectedItem();
        if (this.info == null || this.info.schemafile == null || this.info.schemafile.length() == 0 || this.info.xmlRoot == null || ds == null || ds.length() == 0) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    private Connection initConnection(JdbcDriverDetail detail, String datasource, String user, String password) throws Exception {
        String driver = detail.getClassname();
        Connection conn = null;
        if (driver != null && datasource != null) {
            XMLTransferMap.loadDriver((String)driver);
            conn = DriverManager.getConnection(datasource, user, password);
            this.info.driver = driver;
            this.info.datasource = datasource;
            this.info.user = user;
            this.info.password = password;
        }
        return conn;
    }

    public void okButton_actionPerformed(ActionEvent e) {
        Object item = this.driverComboBox.getSelectedItem();
        JdbcDriverDetail driver = null;
        driver = item instanceof JdbcDriverDetail ? (JdbcDriverDetail)item : new JdbcDriverDetail(item.toString(), null, null);
        String datasource = this.dsComboBox.getSelectedItem().toString();
        String user = this.userTextField.getText();
        String password = new String(this.psTextField.getPassword());
        this.info.close();
        if (this.info.driver != null && this.info.driver.compareTo(driver.getClassname()) != 0 || this.info.datasource != null && this.info.datasource.compareTo(datasource) != 0 || this.info.user != null && this.info.user.compareTo(user) != 0 || this.info.user != null && this.info.password.compareTo(password) != 0) {
            this.info.setDirty(true);
        }
        try {
            this.info.conn = this.initConnection(driver, datasource, user, password);
            if (this.info.conn == null) {
                GuiUt.showErrorDlg(this, this.res.getString("Connection_fail_"));
                return;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            GuiUt.showErrorDlg(this, e1.getClass().getName() + ": " + e1.getMessage());
            this.info.conn = null;
            return;
        }
        if (this.info.type != XtmInfo.SOURCE_XML) {
            this.info.dummy.remove(this.info.xmlRoot);
        }
        this.setVisible(false);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.info = null;
        this.setVisible(false);
    }

    public void dsComboBox_actionPerformed(ActionEvent e) {
        if (this.driverComboBox.getSelectedItem() == null || this.dsComboBox.getSelectedItem() == null) {
            return;
        }
        String driver = this.driverComboBox.getSelectedItem().toString();
        String datasource = this.dsComboBox.getSelectedItem().toString();
        if (driver.compareTo(JdbcDriverDetail.DBMAKER_JDBC_DRIVER) == 0 && datasource.startsWith(JdbcDriverDetail.DBMAKER_PREFIX)) {
            String dbname = datasource.substring(JdbcDriverDetail.DBMAKER_PREFIX.length());
            JdmConfig config = new JdmConfig();
            String user = JdmConfig.getDefaultUser(dbname);
            this.userTextField.setText(user);
        }
    }

    public void driverComboBox_actionPerformed(ActionEvent e) {
        this.userTextField.setText("");
        this.psTextField.setText("");
        Object item = this.driverComboBox.getSelectedItem();
        if (item instanceof JdbcDriverDetail) {
            JdbcDriverDetail driver = (JdbcDriverDetail)item;
            String driverName = driver.getClassname();
            if (driverName.compareTo(JdbcDriverDetail.DBMAKER_JDBC_DRIVER) == 0) {
                JdmConfig config = new JdmConfig();
                Vector v = JdmConfig.getDatabaseNames("dmconfig.ini", false, false);
                Vector<String> v2 = new Vector<String>(v.size());
                Enumeration enum1 = v.elements();
                while (enum1.hasMoreElements()) {
                    v2.add(JdbcDriverDetail.DBMAKER_PREFIX + enum1.nextElement());
                }
                this.dsComboBox.setModel(new DefaultComboBoxModel(v2));
                this.dsComboBox.setSelectedIndex(0);
            } else {
                this.dsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{driver.getPrefix()}));
            }
        }
    }

    private void cleanXmlInfo() {
        this.browseButton.setEnabled(false);
        this.rootField.setText("");
        this.info.xmlRoot = null;
        this.info.dummy = null;
        this.info.type = XtmInfo.SOURCE_XML;
    }

    public void browseButton_actionPerformed(ActionEvent e) {
        DmTree tree = new DmTree(this.info.dummy);
        tree.setRootVisible(false);
        SchemaChooseRootDlg dlg = SchemaChooseRootDlg.createWorkspaceDlg(this, tree, this.info.xmlRoot);
        GuiUt.setCenterLocation(this, dlg);
        dlg.show();
        AbstractXmlMutableTreeNode result = dlg.getSelection();
        if (result != null) {
            this.info.xmlRoot = result;
            if (this.info.xmlRoot != null) {
                this.rootField.setText(this.info.xmlRoot.getText());
            }
        }
    }

    private void initXmlSource(String filename) {
        this.cleanXmlInfo();
        this.info.schemafile = filename;
        String temp = filename.toLowerCase();
        try {
            if (temp.endsWith("dtd")) {
                this.info.type = XtmInfo.SOURCE_DTD;
                this.info.dummy = DTDHandler.getTree(filename);
            } else if (temp.endsWith("xsd")) {
                this.info.type = XtmInfo.SOURCE_XSD;
                this.info.dummy = XSDParser.getTree(filename);
            }
        }
        catch (Exception e1) {
            System.out.println(e1.getMessage());
            e1.printStackTrace();
            return;
        }
        if (this.info.dummy != null) {
            this.info.xmlRoot = (AbstractXmlMutableTreeNode)this.info.dummy.getFirstChild();
            if (this.info.xmlRoot != null) {
                this.rootField.setText(this.info.xmlRoot.getText());
            }
            this.browseButton.setEnabled(true);
            return;
        }
        if (this.info.type != XtmInfo.SOURCE_XML) {
            return;
        }
        try {
            this.info.type = XtmInfo.SOURCE_XML;
            this.info.dummy = XmlTreeBuilder.getTree(filename);
            this.info.xmlfile = this.info.schemafile;
        }
        catch (Exception e1) {
            System.out.println(e1.getMessage());
            e1.printStackTrace();
            return;
        }
        if (this.info.dummy != null) {
            this.info.xmlRoot = this.info.dummy;
            if (this.info.xmlRoot != null) {
                this.rootField.setText(this.info.xmlRoot.getText());
            }
            return;
        }
    }

    public void xmlField_actionPerformed(ActionEvent e) {
        String filename = this.xmlField.getText();
        if (filename == null || filename.length() == 0) {
            this.cleanXmlInfo();
            return;
        }
        if (this.info.schemafile != null && filename.compareTo(this.info.schemafile) == 0) {
            return;
        }
        this.initXmlSource(filename);
    }

    class WsReflectionAction
    extends ReflectionAction {
        public WsReflectionAction(Object target, String methodname) {
            super(target, methodname);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            WorkspaceDlg.this.setOkButtonStatus();
        }
    }
}

