/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.gui;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.DbaButton;
import com.syscom.ut.comp.DbaFileFilter;
import com.syscom.ut.comp.DmRadioButton;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.ut.text.DmPlainTextArea;
import com.syscom.ut.textField.FilePathField;
import com.syscom.xml.xtm.XtmInfo;
import com.syscom.xml.xtm.gui.XTMFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ExecuteXtmDlg
extends JDialog {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
    public static int CANCEL = -1;
    public static int AS_XTM = 0;
    public static int AS_SCRIPT = 1;
    private DmRadioButton xtmRadioButton = new DmRadioButton(this.res.getString("Save_as_XTM_and_run"));
    private DmRadioButton scriptRadioButton = new DmRadioButton(this.res.getString("Save_as_SQL_script"));
    private FilePathField xtmField = new FilePathField(XTMFrame.frame, null, new FileFilter[]{new DbaFileFilter("xsl", this.res.getString("XSL_Document_Type")), new DbaFileFilter("xml", this.res.getString("XML_Document_Type"))});
    private FilePathField scriptField = new FilePathField(XTMFrame.frame, null, new FileFilter[]{new DbaFileFilter("sql", this.res.getString("SQL_script_sql_"))});
    private FilePathField xmlField = new FilePathField(XTMFrame.frame, null, new FileFilter[]{new DbaFileFilter("xml", this.res.getString("XML_Document_Type"))});
    private DbaButton okButton = new DbaButton(this.res.getString("Ok"), 'O', new MyReflectionAction(this, "okButton_actionPerformed"));
    private DbaButton cancelButton = new DbaButton(this.res.getString("Cancel"), 'C', new MyReflectionAction(this, "cancelButton_actionPerformed"));
    private DbaButton helpButton = new DbaButton(this.res.getString("Help"), 'H');
    private int choice = CANCEL;

    private ExecuteXtmDlg(Frame frame, boolean modal) {
        super(frame, "", modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ExecuteXtmDlg() {
        super(XTMFrame.frame);
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ExecuteXtmDlg createExecuteXtmDlg() {
        ExecuteXtmDlg dlg = null;
        dlg = GuiUt.isWindows() ? new ExecuteXtmDlg() : new ExecuteXtmDlg((Frame)XTMFrame.frame, true);
        return dlg;
    }

    void jbInit() throws Exception {
        this.okButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/ok.gif"));
        this.cancelButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/cancel.gif"));
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/help.gif"));
        this.setTitle(this.res.getString("Execute_XTM"));
        this.setResizable(false);
        XTMFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "executextmdlg");
        JPanel panel1 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel panel2 = new JPanel(new FlowLayout(1));
        panel2.add(this.okButton);
        panel2.add(this.cancelButton);
        panel2.add(this.helpButton);
        this.xtmField.setBorder(BorderFactory.createEtchedBorder());
        this.scriptField.setBorder(BorderFactory.createEtchedBorder());
        this.xmlField.setBorder(BorderFactory.createEtchedBorder());
        this.scriptField.addActionListener(new MyReflectionAction(this, "textField_actionPerformed"));
        this.xmlField.addActionListener(new MyReflectionAction(this, "textField_actionPerformed"));
        this.xtmField.addActionListener(new MyReflectionAction(this, "textField_actionPerformed"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.xtmRadioButton);
        bg.add(this.scriptRadioButton);
        JPanel panel3 = this.getPanel(this.xtmRadioButton, this.xtmField);
        JPanel panel4 = this.getPanel(this.scriptRadioButton, this.scriptField);
        JPanel panel5 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        panel5.add(panel3);
        panel5.add(panel4);
        JPanel panel6 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel6.add(this.getPanel(new JLabel(this.res.getString("Source_XML")), this.xmlField));
        panel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        DmPlainTextArea text = new DmPlainTextArea(this.res.getString("You_can_either_save_in_XTM"));
        text.setPreferredSize(new Dimension(420, 60));
        panel1.add(text);
        panel1.add(panel5);
        panel1.add(panel6);
        panel1.add(panel2);
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        if (!info.xtmfile.startsWith("untitle")) {
            this.xtmField.setText(info.xtmfile);
        }
        if (info.xmlfile != null && info.xmlfile.length() > 0) {
            this.xmlField.setText(info.xmlfile);
        }
        this.xtmRadioButton.addActionListener(new MyReflectionAction(this, "radioButton_actionPerformed"));
        this.scriptRadioButton.addActionListener(new MyReflectionAction(this, "radioButton_actionPerformed"));
        this.scriptField.addPropertyChangeListener(new TextFieldChangedListener());
        this.xtmField.addPropertyChangeListener(new TextFieldChangedListener());
        this.xmlField.addPropertyChangeListener(new TextFieldChangedListener());
        this.xtmRadioButton.setSelected(true);
        this.getContentPane().add(panel1);
        this.helpButton.setNextFocusableComponent(this.xtmRadioButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                ExecuteXtmDlg.this.getFocusFor(ExecuteXtmDlg.this.xtmField);
            }
        });
    }

    private void getFocusFor(final JComponent comp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                comp.setRequestFocusEnabled(true);
                comp.requestFocus();
            }
        });
    }

    private JPanel getPanel(JComponent left, JComponent right) {
        JPanel panel = new JPanel(new BorderLayout());
        left.setPreferredSize(new Dimension(170, 22));
        panel.add((Component)left, "West");
        if (right != null) {
            right.setPreferredSize(new Dimension(240, 22));
            panel.add((Component)right, "Center");
        }
        return panel;
    }

    public void setStatus() {
        if (this.xtmRadioButton.isSelected()) {
            this.scriptField.setEnabled(false);
            this.xtmField.setEnabled(true);
            if (this.xtmField.getText().length() > 0 && this.xmlField.getText().length() > 0) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        } else {
            this.scriptField.setEnabled(true);
            this.xtmField.setEnabled(false);
            if (this.scriptField.getText().length() > 0 && this.xmlField.getText().length() > 0) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }

    public void textField_actionPerformed(ActionEvent e) {
        this.setStatus();
    }

    public void radioButton_actionPerformed(ActionEvent e) {
        this.setStatus();
    }

    public void okButton_actionPerformed(ActionEvent e) {
        this.choice = this.xtmRadioButton.isSelected() ? AS_XTM : AS_SCRIPT;
        String filename = null;
        filename = this.choice == AS_XTM ? this.getXtmFilename() : this.getScriptFilename();
        File f = new File(filename);
        if (f.exists()) {
            XtmInfo info = XTMFrame.frame.getXtmInfo();
            if (this.choice != AS_XTM || filename.compareTo(info.xtmfile) != 0) {
                String s2 = GuiUt.mapStringForProperty(this.res.getString("Do_you_want_to"), f.getAbsolutePath());
                int reply = GuiUt.showOptionDlg(this, this.res.getString("Question"), s2);
                if (reply != 0) {
                    return;
                }
            }
        }
        this.setVisible(false);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.choice = CANCEL;
        this.setVisible(false);
    }

    public int getChoice() {
        return this.choice;
    }

    public String getXtmFilename() {
        if (this.xtmRadioButton.isSelected()) {
            return this.xtmField.getText();
        }
        return null;
    }

    public String getScriptFilename() {
        if (this.scriptRadioButton.isSelected()) {
            return this.scriptField.getText();
        }
        return null;
    }

    public String getXmlFilename() {
        return this.xmlField.getText();
    }

    private class MyReflectionAction
    extends ReflectionAction {
        public MyReflectionAction(Object target, String methodname) {
            super(target, methodname);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ExecuteXtmDlg.this.setStatus();
        }
    }

    private class TextFieldChangedListener
    implements PropertyChangeListener {
        private TextFieldChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            ExecuteXtmDlg.this.setStatus();
        }
    }
}

