/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.treeBuilder;

import com.syscom.tree.AbstractDmMutableTreeNode;
import com.syscom.xml.node.AbstractXmlMutableTreeNode;
import com.syscom.xml.node.AttributeNode;
import com.syscom.xml.node.ElementNode;
import com.syscom.xml.treeBuilder.dtdparser.AttListDecl;
import com.syscom.xml.treeBuilder.dtdparser.DTDParser;
import com.syscom.xml.treeBuilder.dtdparser.ParseException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class DTDHandler {
    Vector elements = new Vector();
    Vector attrlists = new Vector();
    AbstractXmlMutableTreeNode dummy = null;

    public void attListDecl(AttListDecl list) {
        this.attrlists.add(list);
    }

    public void elementDecl(ElementNode e) {
        this.elements.add(e);
    }

    public static AbstractXmlMutableTreeNode getTree(String filename) throws IOException, ParseException {
        DTDHandler handler = new DTDHandler();
        FileInputStream in = new FileInputStream(filename);
        byte[] ba = new byte[in.available()];
        in.read(ba);
        DTDParser parser = new DTDParser(new ByteArrayInputStream(ba));
        parser.setHandle(handler);
        parser.parse();
        parser = null;
        in.close();
        handler.organize();
        return handler.getDummyRoot();
    }

    public AbstractXmlMutableTreeNode getDummyRoot() {
        return this.dummy;
    }

    private AttListDecl searchAttListDecl(String str) {
        if (this.attrlists == null || this.attrlists.size() == 0) {
            return null;
        }
        AttListDecl node = null;
        int size = this.attrlists.size();
        for (int i = 0; i < size; ++i) {
            node = (AttListDecl)this.attrlists.elementAt(i);
            if (!node.isEqual(str)) continue;
            return node;
        }
        return null;
    }

    private void organize() {
        Enumeration enum1 = null;
        ElementNode e = null;
        AttListDecl a = null;
        int size = this.elements.size();
        for (int j = 0; j < size; ++j) {
            e = (ElementNode)this.elements.elementAt(j);
            a = this.searchAttListDecl(e.getText());
            if (a == null) continue;
            int index = e.getLastAttrPosition();
            enum1 = a.getAttributes();
            while (enum1.hasMoreElements()) {
                e.insert((DefaultMutableTreeNode)enum1.nextElement(), index++);
            }
        }
        this.dummy = new ElementNode("dummy");
        ElementNode elm = null;
        size = this.elements.size();
        for (int i = 0; i < size; ++i) {
            elm = (ElementNode)this.elements.elementAt(i);
            this.dummy.add(this.getTreeNode(new ElementNode(elm.getText()), new Stack()));
        }
    }

    private ElementNode searchElement(String str) {
        if (this.elements == null || this.elements.size() == 0) {
            return null;
        }
        ElementNode node = null;
        int size = this.elements.size();
        for (int i = 0; i < size; ++i) {
            node = (ElementNode)this.elements.elementAt(i);
            if (node.getText().compareTo(str) != 0) continue;
            return node;
        }
        return null;
    }

    private ElementNode getTreeNode(ElementNode current, Stack stack) {
        stack.push(current.getText());
        AbstractDmMutableTreeNode node = null;
        Object nNode = null;
        ElementNode tNode = this.searchElement(current.getText());
        if (tNode != null && tNode.getChildCount() > 0) {
            for (node = (AbstractDmMutableTreeNode)tNode.getFirstChild(); node != null; node = (AbstractDmMutableTreeNode)node.getNextSibling()) {
                if (node instanceof AttributeNode) {
                    current.add(new AttributeNode(node.getText()));
                    continue;
                }
                if (!(node instanceof ElementNode) || stack.indexOf(node.getText()) >= 0) continue;
                current.add(this.getTreeNode(new ElementNode(node.getText()), stack));
            }
        }
        stack.pop();
        return current;
    }
}

