/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut;

import com.syscom.ut.TextUt;
import com.syscom.ut.WebBrowser;
import com.syscom.ut.dialog.ShowInformationDlg;
import com.syscom.ut.dialog.ShowOptionsDlg;
import com.syscom.ut.dialog.ShowRetryOptionsDlg;
import com.syscom.ut.dialog.ShowSimpleErrorDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class GuiUt {
    private static ShowSimpleErrorDlg dlg = null;
    private static String javaversion = null;
    public static String JDK13 = "1.3";

    public static void initOutOfMemoryErrorDlg(Component comp, String msg, String moreinfo) {
        dlg = GuiUt.isWindows() ? (comp == null || comp instanceof Frame ? new ShowSimpleErrorDlg((Frame)comp, msg) : (comp instanceof Dialog ? new ShowSimpleErrorDlg((Dialog)comp, msg) : new ShowSimpleErrorDlg((Frame)null, msg))) : (comp == null || comp instanceof Frame ? new ShowSimpleErrorDlg((Frame)comp, "", true, msg) : (comp instanceof Dialog ? new ShowSimpleErrorDlg((Dialog)comp, "", true, msg) : new ShowSimpleErrorDlg((Frame)null, "", true, msg)));
    }

    public static void showOutOfMemoryErrorDlg(OutOfMemoryError e) {
        if (e != null) {
            e.printStackTrace();
        }
        if (dlg == null) {
            System.out.println("no out of memory error dialog has been created");
            return;
        }
        GuiUt.setCenterLocation(dlg.getParent(), dlg);
        dlg.show();
    }

    public static void showInformationDlg(Component comp, String msg) {
        ShowInformationDlg dlg = null;
        if (GuiUt.isWindows()) {
            if (comp == null || comp instanceof Frame) {
                dlg = new ShowInformationDlg((Frame)comp, msg);
            } else if (comp instanceof JDialog) {
                dlg = new ShowInformationDlg((JDialog)comp, msg);
            }
        } else if (comp == null || comp instanceof Frame) {
            dlg = new ShowInformationDlg((Frame)comp, "", true, msg);
        } else if (comp instanceof JDialog) {
            dlg = new ShowInformationDlg((JDialog)comp, "", true, msg);
        }
        if (dlg == null) {
            return;
        }
        GuiUt.setCenterLocation(comp, dlg);
        dlg.show();
    }

    public static void showErrorDlg(Component comp, String msg) {
        ShowSimpleErrorDlg dlg = null;
        if (GuiUt.isWindows()) {
            if (comp == null || comp instanceof Frame) {
                dlg = new ShowSimpleErrorDlg((Frame)comp, msg);
            } else if (comp instanceof JDialog) {
                dlg = new ShowSimpleErrorDlg((Dialog)((JDialog)comp), msg);
            }
        } else if (comp == null || comp instanceof Frame) {
            dlg = new ShowSimpleErrorDlg((Frame)comp, "", true, msg);
        } else if (comp instanceof JDialog) {
            dlg = new ShowSimpleErrorDlg((Dialog)((JDialog)comp), "", true, msg);
        }
        if (dlg == null) {
            return;
        }
        GuiUt.setCenterLocation(comp, dlg);
        dlg.show();
    }

    public static int showOptionDlg(Component comp, String title, String msg) {
        ShowOptionsDlg dlg = null;
        if (GuiUt.isWindows()) {
            if (comp == null || comp instanceof Frame) {
                dlg = new ShowOptionsDlg((Frame)comp, msg, 0);
            } else if (comp instanceof JDialog) {
                dlg = new ShowOptionsDlg((JDialog)comp, msg, 0);
            }
            if (dlg != null && title != null) {
                dlg.setTitle(title);
            }
        } else if (comp == null || comp instanceof Frame) {
            dlg = new ShowOptionsDlg((Frame)comp, title, true, msg, 0);
        } else if (comp instanceof JDialog) {
            dlg = new ShowOptionsDlg((JDialog)comp, title, true, msg, 0);
        }
        if (dlg == null) {
            return 1;
        }
        GuiUt.setCenterLocation(comp, dlg);
        dlg.show();
        int result = dlg.getResult();
        dlg.dispose();
        return result;
    }

    public static int showOption3Dlg(Component comp, String title, String msg) {
        ShowOptionsDlg dlg = null;
        if (GuiUt.isWindows()) {
            if (comp == null || comp instanceof Frame) {
                dlg = new ShowOptionsDlg((Frame)comp, msg, 1);
            } else if (comp instanceof JDialog) {
                dlg = new ShowOptionsDlg((JDialog)comp, msg, 1);
            }
            if (title != null) {
                dlg.setTitle(title);
            }
        } else if (comp == null || comp instanceof Frame) {
            dlg = new ShowOptionsDlg((Frame)comp, title, true, msg, 1);
        } else if (comp instanceof JDialog) {
            dlg = new ShowOptionsDlg((JDialog)comp, title, true, msg, 1);
        }
        GuiUt.setCenterLocation(comp, dlg);
        dlg.show();
        int result = dlg.getResult();
        dlg.dispose();
        return result;
    }

    public static int showRetryOptionsDlg(Component comp, String title, String msg) {
        ShowRetryOptionsDlg dlg = null;
        if (GuiUt.isWindows()) {
            if (comp == null || comp instanceof Frame) {
                dlg = new ShowRetryOptionsDlg((Frame)comp, msg, 0);
            } else if (comp instanceof JDialog) {
                dlg = new ShowRetryOptionsDlg((JDialog)comp, msg, 0);
            }
            if (dlg != null && title != null) {
                dlg.setTitle(title);
            }
        } else if (comp == null || comp instanceof Frame) {
            dlg = new ShowRetryOptionsDlg((Frame)comp, title, true, msg, 0);
        } else if (comp instanceof JDialog) {
            dlg = new ShowRetryOptionsDlg((JDialog)comp, title, true, msg, 0);
        }
        if (dlg == null) {
            return 1;
        }
        GuiUt.setCenterLocation(comp, dlg);
        dlg.show();
        int result = dlg.getResult();
        dlg.dispose();
        return result;
    }

    public static void setCenterLocation(Component parent, Component child) {
        if (parent != null) {
            int y;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension childSize = child.getPreferredSize();
            Dimension parentSize = parent.getSize();
            Point loc = parent.getLocation();
            int x = (parentSize.width - childSize.width) / 2 + loc.x;
            if (x + childSize.width > screenSize.width) {
                x = screenSize.width - childSize.width;
            }
            if (x < 0) {
                x = 0;
            }
            if ((y = (parentSize.height - childSize.height) / 2 + loc.y) + childSize.height > screenSize.height) {
                y = screenSize.height - childSize.height;
            }
            if (y < 0) {
                y = 0;
            }
            child.setLocation(x, y);
        }
    }

    public static Font getDefaultFont() {
        return (Font)UIManager.get("Label.font");
    }

    public static void initFont() {
        int width;
        UIManager.put("Label.foreground", Color.black);
        Font defaultFont = (Font)UIManager.get("Label.font");
        if (defaultFont == null) {
            System.out.println("default font=null");
            return;
        }
        defaultFont = new Font(defaultFont.getName(), 0, 12);
        MyComponent cmp = new MyComponent();
        FontMetrics fm = cmp.getFontMetrics(defaultFont);
        char[] checkstr = new char[52];
        for (int i = 0; i < 26; ++i) {
            checkstr[i] = (char)(i + 65);
            checkstr[i + 26] = (char)(i + 97);
        }
        while ((width = fm.charsWidth(checkstr, 0, checkstr.length)) > 380) {
            defaultFont = new Font(defaultFont.getName(), 0, defaultFont.getSize() - 1);
            fm = cmp.getFontMetrics(defaultFont);
        }
        FontUIResource fontUIRes = new FontUIResource(defaultFont);
        UIManager.put("Text.font", fontUIRes);
        UIManager.put("TextField.font", fontUIRes);
        UIManager.put("TextArea.font", fontUIRes);
        UIManager.put("TextPane.font", fontUIRes);
        UIManager.put("List.font", fontUIRes);
        UIManager.put("Table.font", fontUIRes);
        UIManager.put("ComboBox.font", fontUIRes);
        UIManager.put("CheckBox.font", fontUIRes);
        UIManager.put("RadioButton.font", fontUIRes);
        UIManager.put("Button.font", fontUIRes);
        UIManager.put("Label.font", fontUIRes);
        UIManager.put("MenuComponent.font", fontUIRes);
        UIManager.put("Menu.font", fontUIRes);
        UIManager.put("MenuBar.font", fontUIRes);
        UIManager.put("MenuItem.font", fontUIRes);
        UIManager.put("RadioButtonMenuItem.font", fontUIRes);
        UIManager.put("ToolTip.font", fontUIRes);
        UIManager.put("ToggleButton.font", fontUIRes);
        UIManager.put("TitledBorder.font", fontUIRes);
        UIManager.put("PopupMenu.font", fontUIRes);
        UIManager.put("TableHeader.font", fontUIRes);
        UIManager.put("PasswordField.font", fontUIRes);
        UIManager.put("ToolBar.font", fontUIRes);
        UIManager.put("MenuBar.font", fontUIRes);
        UIManager.put("Panel.font", fontUIRes);
        UIManager.put("ProgressBar.font", fontUIRes);
        UIManager.put("TextPane.font", fontUIRes);
        UIManager.put("OptionPane.font", fontUIRes);
        UIManager.put("ScrollPane.font", fontUIRes);
        UIManager.put("EditorPane.font", fontUIRes);
        UIManager.put("ColorChooser.font", fontUIRes);
        UIManager.put("TabbedPane.font", fontUIRes);
    }

    public static boolean isWindows() {
        return WebBrowser.isWindowsPlatform();
    }

    public static String mapStringForProperty(String sourceStr, Vector v) {
        String final_str = sourceStr;
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            final_str = GuiUt.mapStringForProperty(final_str, (String)v.elementAt(i));
        }
        return final_str;
    }

    public static String mapStringForProperty(String sourceStr, String[] v) {
        String final_str = sourceStr;
        int size = v.length;
        for (int i = 0; i < size; ++i) {
            final_str = GuiUt.mapStringForProperty(final_str, v[i]);
        }
        return final_str;
    }

    public static String mapStringForProperty(String sourceStr, String replaceStr) {
        return GuiUt.mapStringForProperty(sourceStr, replaceStr, true);
    }

    public static String mapStringForProperty(String sourceStr, String replaceStr, boolean addspace) {
        String returnStr = null;
        if (sourceStr == null) {
            return replaceStr;
        }
        int index = sourceStr.indexOf("%");
        returnStr = index < 0 ? sourceStr + " " + replaceStr : (addspace ? sourceStr.substring(0, index) + " " + replaceStr + " " + sourceStr.substring(index + 1, sourceStr.length()) : sourceStr.substring(0, index) + replaceStr + sourceStr.substring(index + 1, sourceStr.length()));
        return returnStr;
    }

    public static String rightTrim(String str) {
        return TextUt.rightTrim(str);
    }

    public static String getIDString(String str) {
        return TextUt.getIDString(str);
    }

    public static String singleQuoteHandle(String varName) {
        String tmp = GuiUt.rightTrim(varName);
        byte[] source = tmp.getBytes();
        byte[] dest = new byte[source.length * 2];
        int j = 0;
        for (int i = 0; i < source.length; ++i) {
            if (source[i] == 39) {
                dest[j++] = 39;
            }
            dest[j++] = source[i];
        }
        return new String(dest, 0, j);
    }

    public static void printByte(String str) {
        System.out.print("str=");
        if (str == null) {
            return;
        }
        byte[] b = str.getBytes();
        for (int i = 0; i < b.length; ++i) {
            System.out.print(b[i]);
        }
        System.out.println("");
    }

    public static String getJavaVersion() {
        if (javaversion == null) {
            javaversion = System.getProperty("java.version");
        }
        return javaversion;
    }

    public static void startTool(String tool) {
        try {
            String cmd;
            if (GuiUt.isWindows()) {
                String home = System.getProperty("java.home");
                String fileseparator = System.getProperty("file.separator");
                String userdir = System.getProperty("user.dir");
                String exefile = home + fileseparator + "bin" + fileseparator + "javaw";
                if (exefile.indexOf(32) > 0) {
                    exefile = "\"" + exefile + "\"";
                }
                String[] jars = new String[]{"jtools.jar", "jh.jar", "dmjdbc.jar", "jhelp.jar"};
                String tmp = null;
                String classpath = "";
                for (int i = 0; i < jars.length; ++i) {
                    tmp = userdir + fileseparator + jars[i];
                    if (tmp.indexOf(32) >= 0) {
                        tmp = "\"" + tmp + "\"";
                    }
                    classpath = classpath.length() == 0 ? tmp : classpath + ";" + tmp;
                }
                cmd = exefile + " -classpath " + classpath + " " + tool;
            } else {
                cmd = "java " + tool;
            }
            System.out.println(cmd);
            Process process = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ex) {
            System.out.println("Error start " + tool + ": " + ex.getMessage());
        }
    }

    public static Object getNewInstance(String clsname, Class[] paramtypes, Object[] paramvalues) {
        try {
            Class<?> cls = Class.forName(clsname);
            Constructor<?> ctr = cls.getConstructor(paramtypes);
            return ctr.newInstance(paramvalues);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            System.out.println(cnfe.getMessage());
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.getMessage());
            return null;
        }
    }

    static class MyComponent
    extends Component {
        MyComponent() {
        }
    }
}

