/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.treetable;

import com.syscom.treetable.TreeTableModel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    JTree tree;
    TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree1) {
        this.tree = tree1;
        this.treeTableModel = treeTableModel;
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = TreeTableModelAdapter.this.tree.getSelectionPath();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPath(path);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreePath path = TreeTableModelAdapter.this.tree.getSelectionPath();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPath(path);
            }
        });
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        return treePath.getLastPathComponent();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }
}

