/*
 * Decompiled with CFR 0.152.
 */
package wizard.storedcommand;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.HelpButton;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.WizardTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.text.EditorPane;
import dbaut.textField.CharField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import wizard.WizardPanel;

public class CreateStoredCommandDlg
extends JDialog {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.wizard.ResWizard", LocaleManager.getLocale());
    private CharField Command_Name = new CharField(128, true);
    private JEditorPane Command_Statement = new EditorPane();
    private HelpButton help_Button = new HelpButton();

    public CreateStoredCommandDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CreateStoredCommandDlg(Frame frame) {
        super(frame);
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setName("StoreCommandDialogWizard");
        DbaButton Cancel_Button = new DbaButton();
        Cancel_Button.setName("CancelButton");
        DbaButton OK_Button = new DbaButton();
        JPanel panel1 = new JPanel(new BorderLayout());
        DbFrame.frame.enableDialogHelp(this.getRootPane(), this.help_Button, "CreateStoredCommandDlgHelpIDInformation", null);
        this.setTitle(this.res.getString("Create_Stored_Command_settitle"));
        panel1.setPreferredSize(new Dimension(640, 500));
        JPanel panel12 = new JPanel(new BorderLayout());
        panel12.add((Component)new JLabel(DBAImageResource.getResource(this.getClass(), "/jdbaimages/storedcommandwizard.gif")), "North");
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.getViewport().add((Component)new WizardTextPane(18, 14, Color.WHITE, this.res.getString("Create_Stored_Command") + " " + this.res.getString("It_is_possible_to_create_a_stored_command")), null);
        panel12.add((Component)jScrollPane1, "Center");
        panel1.add((Component)panel12, "West");
        panel12 = new JPanel(new BorderLayout());
        panel12.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel panel14 = new JPanel(new GridLayout(1, 2, 4, 4));
        panel14.add(new JLabel(this.res.getString("Stored_Command_Name")));
        panel14.add(this.Command_Name);
        panel12.add((Component)panel14, "North");
        jScrollPane1 = new JScrollPane();
        jScrollPane1.getViewport().add((Component)this.Command_Statement, null);
        panel12.add((Component)jScrollPane1, "Center");
        JTextArea textArea = new JTextArea(this.res.getString("For_example_n").trim() + "\n" + "    select * from SYSADM.TableOne order by c1\n" + "    delete from SYSADM.TableTwo where c1 > 100\n" + "    insert into SYSADM.TableThree (c1,c2) values (?,?)\n" + "    update SYSADM.TableFour set c1 = ? where c2 = ?\n");
        textArea.setEditable(false);
        textArea.setOpaque(true);
        textArea.setBackground(WizardPanel.sysColor);
        textArea.setBorder(null);
        panel12.add((Component)textArea, "South");
        panel1.add((Component)panel12, "Center");
        panel12 = new JPanel(new FlowLayout(2));
        panel12.add(OK_Button);
        panel12.add(Cancel_Button);
        panel12.add(this.help_Button);
        panel1.add((Component)panel12, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel1, "Center");
        Cancel_Button.setText(this.res.getString("Cancel"));
        Cancel_Button.setMnemonic('C');
        Cancel_Button.addActionListener(new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        OK_Button.setText(this.res.getString("Ok"));
        OK_Button.setMnemonic('O');
        OK_Button.addActionListener(new ReflectionAction(this, "OK_Button_actionPerformed"));
        this.Command_Statement.setBorder(null);
        OK_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        Cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        this.help_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/help.gif"));
        this.Command_Name.setName("CommandNameField");
        this.Command_Statement.setName("CommandScriptsEditorPanel");
        OK_Button.setName("OKButton");
    }

    public void OK_Button_actionPerformed(ActionEvent e) {
        String cmd_name = this.Command_Name.getText();
        String cmd_stmt = this.Command_Statement.getText();
        if (cmd_name.length() == 0 || cmd_stmt.length() == 0) {
            GuiUt.showErrorDlg(this, this.res.getString("Command_name_and_statement_are_both_required"), null);
            return;
        }
        String query = null;
        query = "CREATE COMMAND " + GuiUt.getIDString(cmd_name) + " AS " + cmd_stmt;
        boolean result = DatabaseConnection.executeSQL(this, query);
        if (!result) {
            return;
        }
        GuiUt.showInformationDlg(DbFrame.frame, this.res.getString("Stored_command_is_created_successful"));
        this.Cancel_Button_actionPerformed(null);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

