/*
 * Decompiled with CFR 0.152.
 */
package wizard.schedule;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.HelpButton;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import wizard.schedule.Panel_schedule1;
import wizard.schedule.Panel_schedule2;
import wizard.schedule.Panel_schedule3;
import wizard.schedule.Panel_schedule4;
import wizard.schedule.Panel_schedule5;

public class Wizard_schedule
extends JDialog {
    private static final long serialVersionUID = 1615423204201358879L;
    DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.wizard.ResWizard", LocaleManager.getLocale());
    JPanel jPanel1 = new JPanel(new BorderLayout());
    DbaButton Cancel_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancelwizard.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
    DbaButton Next_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Next_"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/next.gif"), new ReflectionAction(this, "Next_Button_actionPerformed"));
    DbaButton Previous_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("_Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/jdbaimages/previous.gif"), new ReflectionAction(this, "Previous_Button_actionPerformed"));
    private Vector<JPanel> panels = new Vector();
    private int cur_step = 0;
    Color sysColor = UIManager.getColor(new UIManager());
    private boolean isMoreTimes = false;
    boolean isDBMaker = true;
    HelpButton help_Button = new HelpButton();

    public Wizard_schedule(Frame frame) {
        super(frame);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Wizard_schedule(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String mapDatabaseDriver(String inStr) {
        String inStrUpper = inStr.toUpperCase();
        String dbbrand = "DBMAKER";
        if (!LocaleManager.getIsDBMaker()) {
            dbbrand = "DBMASTER";
        }
        if (inStr.equals("Oracle")) {
            return "ORACLE";
        }
        if (inStr.equals("Microsoft SQL Server")) {
            return "MICROSOFT";
        }
        if (inStr.equals("Sybase")) {
            return "SYBASE";
        }
        if (inStr.equals("Informix")) {
            return "INFORMIX";
        }
        if (inStrUpper.startsWith(dbbrand + "X")) {
            return "DBMAKERX";
        }
        if (inStrUpper.equals("DB2")) {
            return "DB2";
        }
        if (inStrUpper.equals("MYSQL")) {
            return "MYSQL";
        }
        if (inStrUpper.equals("POSTGRESQL")) {
            return "POSTGRESQL";
        }
        if (inStrUpper.equals("ODBCX")) {
            return "ODBCX";
        }
        return dbbrand;
    }

    private String combineSqlString() {
        String tmpStr;
        Panel_schedule2 tmpSchedule2 = (Panel_schedule2)this.panels.elementAt(1);
        Panel_schedule3 tmpSchedule3 = (Panel_schedule3)this.panels.elementAt(2);
        Panel_schedule4 tmpSchedule4 = (Panel_schedule4)this.panels.elementAt(3);
        String sqlString = "create schedule for ";
        sqlString = this.isDBMaker ? (tmpSchedule2.expressCheckBox.isEnabled() && tmpSchedule2.expressCheckBox.isSelected() ? sqlString + "express replication to " : sqlString + "replication to ") : sqlString + "replication to ";
        String dbbrand = "DBMAKER";
        if (!LocaleManager.getIsDBMaker()) {
            dbbrand = "DBMASTER";
        }
        sqlString = tmpSchedule2.userCheckBox.isSelected() ? ((tmpStr = this.mapDatabaseDriver(tmpSchedule2.userRemoteDBTypeComboBox.getSelectedItem().toString().trim())).equals(dbbrand) ? sqlString + "\"" + tmpSchedule2.userRemoteDBNameTextField.getText().trim() + "\"" : sqlString + "\"" + tmpSchedule2.userRemoteDBNameTextField.getText().trim() + "\"" + " ( " + tmpStr + " )") : ((tmpStr = this.mapDatabaseDriver(tmpSchedule2.remoteDBTypeComboBox.getSelectedItem().toString().trim())).equals(dbbrand) ? sqlString + "\"" + tmpSchedule2.remoteDBNameComboBox.getSelectedItem().toString().trim() + "\"" : sqlString + "\"" + tmpSchedule2.remoteDBNameComboBox.getSelectedItem().toString().trim() + "\"" + " ( " + tmpStr + " )");
        sqlString = sqlString + " begin at " + tmpSchedule3.startDateTextField.getText().trim() + " " + tmpSchedule3.startTimeTextField.getText().trim() + " every ";
        if (tmpSchedule3.everyDaysTextField.getInt() != 0) {
            sqlString = sqlString + tmpSchedule3.everyDaysTextField.getValue().toString() + " days ";
            if (!tmpSchedule3.everyTimesTextField.getText().trim().equals("00:00:00")) {
                sqlString = sqlString + "and " + tmpSchedule3.everyTimesTextField.getText().trim() + " ";
            }
        } else {
            sqlString = sqlString + tmpSchedule3.everyTimesTextField.getText().trim() + " ";
        }
        if (tmpSchedule4.retryTimesTextField.getValue() != 0) {
            sqlString = sqlString + "retry " + tmpSchedule4.retryTimesTextField.getValue().toString().trim() + " times ";
            if (tmpSchedule4.retrySecondsTextField.getValue() != 0) {
                sqlString = sqlString + "after " + tmpSchedule4.retrySecondsTextField.getValue().toString().trim() + " seconds ";
            }
        }
        if (this.isDBMaker) {
            if (!tmpSchedule2.expressCheckBox.isSelected() && tmpSchedule4.stopErrorCheckBox.isSelected()) {
                sqlString = sqlString + "stop on error ";
            }
        } else if (tmpSchedule4.stopErrorCheckBox.isSelected()) {
            sqlString = sqlString + "stop on error ";
        }
        if (tmpSchedule4.checkSchemaCheckBox.isSelected()) {
            sqlString = sqlString + "with no check ";
        }
        sqlString = sqlString + "identified by " + GuiUt.getIDString(tmpSchedule2.userName_TextField.getText());
        if (tmpSchedule2.Password.getPassword().length > 0) {
            sqlString = sqlString + " " + GuiUt.getIDString(new String(tmpSchedule2.Password.getPassword()));
        }
        return sqlString;
    }

    void setHelpId(int step) {
        String[] ids = new String[]{"Wizard_schedule_StepOneHelpIDInformation", "Wizard_schedule_StepTwoHelpIDInformation", "Wizard_schedule_StepThreeHelpIDInformation", "Wizard_schedule_StepFourHelpIDInformation", "Wizard_schedule_StepFiveHelpIDInformation"};
        if (step < 0 || step >= ids.length) {
            return;
        }
        DbFrame.frame.enableDialogHelp(this.getRootPane(), this.help_Button, ids[step], null);
    }

    void jbInit() throws Exception {
        this.setName("ScheduleReplicationDialogWizard");
        this.Cancel_Button.setName("CancelButton");
        this.Next_Button.setName("NextButton");
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(this.res.getString("Create_Schedule_Wizard_Introduction"));
        this.jPanel1.setPreferredSize(new Dimension(640, 500));
        if (this.cur_step == 0) {
            this.panels.add(this.cur_step, new Panel_schedule1(this));
            this.jPanel1.add((Component)((Panel_schedule1)this.panels.elementAt(this.cur_step)), "Center");
            this.Previous_Button.setEnabled(false);
            this.setHelpId(this.cur_step);
            ++this.cur_step;
        }
        this.help_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/help.gif"));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.add(this.Previous_Button);
        bottomPanel.add(this.Next_Button);
        bottomPanel.add(this.Cancel_Button);
        bottomPanel.add(this.help_Button);
        this.jPanel1.add((Component)bottomPanel, "South");
        this.Next_Button.setEnabled(true);
    }

    public void Next_Button_actionPerformed(ActionEvent e) {
        JPanel cur_panel = this.panels.elementAt(this.cur_step - 1);
        if (cur_panel instanceof Panel_schedule5) {
            Panel_schedule5 tmpSchedule5 = (Panel_schedule5)cur_panel;
            String s = tmpSchedule5.jEditorPane1.getText().trim();
            if (DatabaseConnection.executeSQL(this, s, false)) {
                GuiUt.showInformationDlg(this, this.res.getString("The_schedule_is_created_successful"));
                this.setVisible(false);
                this.panels.removeAllElements();
                this.dispose();
            }
        } else {
            Panel_schedule2 schedule2;
            if (this.panels.size() == this.cur_step) {
                if (this.cur_step == 1) {
                    this.panels.add(this.cur_step, new Panel_schedule2(this));
                    this.setTitle(this.res.getString("Create_Schedule_Wizard_Select_the_Remote_Database_Name"));
                } else if (this.cur_step == 2) {
                    schedule2 = (Panel_schedule2)this.panels.elementAt(this.cur_step - 1);
                    if (schedule2.userCheckBox.isSelected()) {
                        if (DbFrame.conn_DatabaseConnection.isScheduleExist(schedule2.userRemoteDBNameTextField.getText().trim())) {
                            GuiUt.showWarningDlg(this, this.res.getString("Warning"), schedule2.userRemoteDBNameTextField.getText().trim() + " " + this.res.getString("already_exist"));
                            --this.cur_step;
                        } else {
                            this.panels.add(this.cur_step, new Panel_schedule3(this));
                            this.setTitle(this.res.getString("Create_Schedule_Wizard_Start_Time_of_Replicating_and_Replicating_Period"));
                        }
                    } else {
                        this.panels.add(this.cur_step, new Panel_schedule3(this));
                        this.setTitle(this.res.getString("Create_Schedule_Wizard_Start_Time_of_Replicating_and_Replicating_Period"));
                    }
                } else if (this.cur_step == 3) {
                    Panel_schedule3 schedule3 = (Panel_schedule3)this.panels.elementAt(this.cur_step - 1);
                    if (!this.validatePanel3(schedule3)) {
                        --this.cur_step;
                    } else {
                        this.panels.add(this.cur_step, new Panel_schedule4(this, (Panel_schedule2)this.panels.elementAt(1)));
                        this.setTitle(this.res.getString("Create_Schedule_Wizard_Retry_Times_and_the_Period_Seconds_of_Next_Retry"));
                    }
                } else if (this.cur_step == 4) {
                    Panel_schedule4 tmpSchedule4 = (Panel_schedule4)this.panels.elementAt(3);
                    if (!this.validatePanel4(tmpSchedule4)) {
                        --this.cur_step;
                    } else {
                        Panel_schedule5 tmpSchedule5 = new Panel_schedule5(this);
                        tmpSchedule5.jEditorPane1.setText(this.combineSqlString());
                        this.panels.add(this.cur_step, tmpSchedule5);
                        this.Next_Button.setText(this.res.getString("Finish"));
                        this.Next_Button.setName("FinishButton");
                        this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"));
                        this.Next_Button.setMnemonic('F');
                        this.setTitle(this.res.getString("Create_Schedule_Wizard_Final_Review"));
                    }
                }
            } else if (this.cur_step == 1) {
                this.setTitle(this.res.getString("Create_Schedule_Wizard_Select_the_Remote_Database_Name"));
                this.isMoreTimes = true;
            } else if (this.cur_step == 2) {
                schedule2 = (Panel_schedule2)this.panels.elementAt(this.cur_step - 1);
                if (schedule2.userCheckBox.isSelected()) {
                    if (DbFrame.conn_DatabaseConnection.isScheduleExist(schedule2.userRemoteDBNameTextField.getText().trim())) {
                        GuiUt.showWarningDlg(this, this.res.getString("Warning"), schedule2.userRemoteDBNameTextField.getText().trim() + " " + this.res.getString("already_exist"));
                        --this.cur_step;
                    } else {
                        this.setTitle(this.res.getString("Create_Schedule_Wizard_Start_Time_of_Replicating_and_Replicating_Period"));
                    }
                } else {
                    this.setTitle(this.res.getString("Create_Schedule_Wizard_Start_Time_of_Replicating_and_Replicating_Period"));
                }
            } else if (this.cur_step == 3) {
                Panel_schedule2 tmpSchedule2 = (Panel_schedule2)this.panels.elementAt(1);
                Panel_schedule3 tmpSchedule3 = (Panel_schedule3)this.panels.elementAt(2);
                Panel_schedule4 tmpSchedule4 = (Panel_schedule4)this.panels.elementAt(3);
                if (!this.validatePanel3(tmpSchedule3)) {
                    --this.cur_step;
                } else {
                    if (!this.isDBMaker) {
                        tmpSchedule4.checkSchemaCheckBox.setSelected(true);
                        tmpSchedule4.checkSchemaCheckBox.setEnabled(false);
                        tmpSchedule4.stopErrorCheckBox.setEnabled(true);
                    } else {
                        tmpSchedule4.checkSchemaCheckBox.setEnabled(true);
                        if (tmpSchedule2.expressCheckBox.isSelected()) {
                            tmpSchedule4.stopErrorCheckBox.setSelected(false);
                            tmpSchedule4.stopErrorCheckBox.setEnabled(false);
                        } else {
                            tmpSchedule4.stopErrorCheckBox.setEnabled(true);
                        }
                    }
                    this.setTitle(this.res.getString("Create_Schedule_Wizard_Retry_Times_and_the_Period_Seconds_of_Next_Retry"));
                }
            } else if (this.cur_step == 4) {
                Panel_schedule4 tmpUser4 = (Panel_schedule4)this.panels.elementAt(this.cur_step - 1);
                if (!this.validatePanel4(tmpUser4)) {
                    --this.cur_step;
                } else {
                    Panel_schedule5 tmpUser5 = (Panel_schedule5)this.panels.elementAt(this.cur_step);
                    tmpUser5.jEditorPane1.setText(this.combineSqlString());
                    this.Next_Button.setText(this.res.getString("Finish"));
                    this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"));
                    this.Next_Button.setMnemonic('F');
                    this.Next_Button.setName("FinishButton");
                    this.setTitle(this.res.getString("Create_Schedule_Wizard_Final_Review"));
                }
            }
            this.jPanel1.remove(this.panels.elementAt(this.cur_step - 1));
            this.jPanel1.add((Component)this.panels.elementAt(this.cur_step), "Center");
            this.Previous_Button.setEnabled(true);
            this.jPanel1.revalidate();
            this.jPanel1.repaint();
            this.setHelpId(this.cur_step);
            ++this.cur_step;
        }
        if (this.isMoreTimes) {
            Panel_schedule2 mySchedule2 = (Panel_schedule2)this.panels.elementAt(this.cur_step - 1);
            if (mySchedule2.userCheckBox.isSelected()) {
                if (mySchedule2.userName_TextField.getText().length() == 0 || mySchedule2.userRemoteDBNameTextField.getText().length() == 0) {
                    this.Next_Button.setEnabled(false);
                } else {
                    this.Next_Button.setEnabled(true);
                }
            } else if (mySchedule2.userName_TextField.getText().equalsIgnoreCase("")) {
                this.Next_Button.setEnabled(false);
            } else {
                this.Next_Button.setEnabled(true);
            }
            this.isMoreTimes = false;
        }
    }

    private boolean validatePanel3(Panel_schedule3 panel3) {
        if (panel3.everyDaysTextField.getValue() == null) {
            GuiUt.showErrorDlg(this, GuiUt.mapStringForProperty(this.res.getString("Invalid_interval_format"), panel3.everyDaysTextField.getStringValue(), false), null);
            return false;
        }
        if (panel3.startDateTextField.getText().equals("    /  /  ")) {
            GuiUt.showErrorDlg(this, GuiUt.mapStringForProperty(this.res.getString("Invalid_date_time_format"), panel3.startDateTextField.getText(), false), null);
            return false;
        }
        return true;
    }

    private boolean validatePanel4(Panel_schedule4 panel4) {
        if (panel4.retryTimesTextField.getValue() == null) {
            GuiUt.showErrorDlg(this, GuiUt.mapStringForProperty(this.res.getString("Invalid_retry"), panel4.retryTimesTextField.getStringValue(), false), null);
            return false;
        }
        if (panel4.retrySecondsTextField.getValue() == null) {
            GuiUt.showErrorDlg(this, GuiUt.mapStringForProperty(this.res.getString("Invalid_seconds_between_retries"), panel4.retrySecondsTextField.getStringValue(), false), null);
            return false;
        }
        return true;
    }

    public void Previous_Button_actionPerformed(ActionEvent e) {
        --this.cur_step;
        this.setHelpId(this.cur_step - 1);
        if (this.cur_step == 1) {
            this.jPanel1.remove((Panel_schedule2)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_schedule1)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.Previous_Button.setEnabled(false);
            this.Next_Button.setEnabled(true);
            this.setTitle(this.res.getString("Create_Schedule_Wizard_Introduction"));
        } else if (this.cur_step == 2) {
            this.jPanel1.remove((Panel_schedule3)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_schedule2)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.setTitle(this.res.getString("Create_Schedule_Wizard_Select_the_Remote_Database_Name"));
        } else if (this.cur_step == 3) {
            this.jPanel1.remove((Panel_schedule4)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_schedule3)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.setTitle(this.res.getString("Create_Schedule_Wizard_Start_Time_of_Replicating_and_Replicating_Period"));
        } else if (this.cur_step == 4) {
            this.jPanel1.remove((Panel_schedule5)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_schedule4)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.setTitle(this.res.getString("Create_Schedule_Wizard_Retry_Times_and_the_Period_Seconds_of_Next_Retry"));
        }
        this.Next_Button.setText(this.res.getString("Next_"));
        this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/next.gif"));
        this.Next_Button.setMnemonic('N');
        this.Next_Button.setName("NextButton");
        this.jPanel1.revalidate();
        this.jPanel1.repaint();
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.panels.removeAllElements();
        this.dispose();
    }

    long stringToLongInt(String inputStr) {
        Long objectLong = new Long(inputStr);
        long lint = objectLong;
        return lint;
    }

    String longIntToString(long inputLong) {
        Long objectLong = new Long(inputLong);
        String s = objectLong.toString().trim();
        return s;
    }
}

