/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import dbaut.textField.IntegerRangeField2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ui.gui.JsqlGUI;

public class JsqlBlobShowDialog
extends JDialog {
    private JRadioButton size = new JRadioButton("Show size");
    private JRadioButton file = new JRadioButton("Show as file");
    private JLabel prefLable = new JLabel("File prefix:");
    private JTextField filePref = new JTextField();
    private JLabel maxLabel = new JLabel("Max rows:");
    private IntegerRangeField2 maxRows = new IntegerRangeField2(1, Integer.MAX_VALUE, true);
    private JRadioButton print = new JRadioButton("Show contents");
    private JLabel printLabel = new JLabel("Blob width:");
    private IntegerRangeField2 blobWidth = new IntegerRangeField2(1, Integer.MAX_VALUE, true);
    private JLabel unitLabel = new JLabel("bytes");
    private DbaButton okButton = new DbaButton(new Dimension(100, 24), "OK", 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "okButtonActionPerformed"));
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), "Cancel", 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private JsqlGUI ui = null;

    public JsqlBlobShowDialog(JsqlGUI ui) {
        super(ui.getFrame());
        this.ui = ui;
        this.init();
        this.pack();
    }

    private void init() {
        this.setTitle("Blob Show");
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                JsqlBlobShowDialog.this.okButton.grabFocus();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                JsqlBlobShowDialog.this.cancelButtonActionPerformed(null);
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.size);
        bg.add(this.file);
        bg.add(this.print);
        JPanel sizePanel = new JPanel(new FlowLayout(0, 10, 0));
        sizePanel.setBorder(BorderFactory.createEtchedBorder());
        sizePanel.add(this.size);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel filePanel = new JPanel(new FlowLayout(0, 10, 0));
        filePanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel tPanel = new JPanel(new FlowLayout(1));
        tPanel.add(this.prefLable);
        this.filePref.setPreferredSize(new Dimension(100, 24));
        tPanel.add(this.filePref);
        JPanel t1Panel = new JPanel(new FlowLayout(1));
        t1Panel.add(this.maxLabel);
        t1Panel.add(this.maxRows);
        filePanel.add(this.file);
        filePanel.add(tPanel);
        JPanel printPanel = new JPanel(new FlowLayout(0, 10, 0));
        printPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel t2Panel = new JPanel(new FlowLayout(1));
        t2Panel.add(this.printLabel);
        t2Panel.add(this.blobWidth);
        t2Panel.add(this.unitLabel);
        printPanel.add(this.print);
        printPanel.add(t2Panel);
        centerPanel.add((Component)sizePanel, "North");
        centerPanel.add((Component)filePanel, "Center");
        centerPanel.add((Component)printPanel, "South");
        JPanel southPanel = new JPanel(new FlowLayout(1));
        southPanel.add(this.okButton);
        southPanel.add(this.cancelButton);
        Container container = this.getContentPane();
        container.add((Component)new JPanel(), "North");
        container.add((Component)centerPanel, "Center");
        container.add((Component)southPanel, "South");
        this.size.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (JsqlBlobShowDialog.this.size.isSelected()) {
                    JsqlBlobShowDialog.this.prefLable.setEnabled(false);
                    JsqlBlobShowDialog.this.filePref.setEnabled(false);
                    JsqlBlobShowDialog.this.maxLabel.setEnabled(false);
                    JsqlBlobShowDialog.this.maxRows.setEnabled(false);
                    JsqlBlobShowDialog.this.printLabel.setEnabled(false);
                    JsqlBlobShowDialog.this.blobWidth.setEnabled(false);
                }
            }
        });
        this.file.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (JsqlBlobShowDialog.this.file.isSelected()) {
                    JsqlBlobShowDialog.this.prefLable.setEnabled(true);
                    JsqlBlobShowDialog.this.filePref.setEnabled(true);
                    JsqlBlobShowDialog.this.maxLabel.setEnabled(true);
                    JsqlBlobShowDialog.this.maxRows.setEnabled(true);
                    JsqlBlobShowDialog.this.printLabel.setEnabled(false);
                    JsqlBlobShowDialog.this.blobWidth.setEnabled(false);
                }
            }
        });
        this.print.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (JsqlBlobShowDialog.this.print.isSelected()) {
                    JsqlBlobShowDialog.this.printLabel.setEnabled(true);
                    JsqlBlobShowDialog.this.blobWidth.setEnabled(true);
                    JsqlBlobShowDialog.this.prefLable.setEnabled(false);
                    JsqlBlobShowDialog.this.filePref.setEnabled(false);
                    JsqlBlobShowDialog.this.maxLabel.setEnabled(false);
                    JsqlBlobShowDialog.this.maxRows.setEnabled(false);
                }
            }
        });
        this.setNames();
        this.initBlobShowStatus();
    }

    private void initBlobShowStatus() {
        String blobShow = this.ui.getIsqlStatus(9);
        String blobPref = this.ui.getIsqlStatus(10);
        String blobWidth = this.ui.getIsqlStatus(11);
        if (blobShow.equalsIgnoreCase("size")) {
            this.size.setSelected(true);
        } else if (blobShow.equalsIgnoreCase("file")) {
            this.file.setSelected(true);
        } else if (blobShow.equalsIgnoreCase("print")) {
            this.print.setSelected(true);
        }
        this.filePref.setText(blobPref);
        this.blobWidth.setText(blobWidth);
    }

    private void setNames() {
        this.setName("BlobShowDialog");
        this.okButton.setName("OKButton");
        this.cancelButton.setName("CancelButton");
        this.size.setName("SizeRadioButton");
        this.file.setName("FileRadioButton");
        this.print.setName("PrintRadioButton");
        this.filePref.setName("PrefixField");
        this.blobWidth.setName("BlobWidthField");
    }

    public void okButtonActionPerformed(ActionEvent e) {
        if (this.size.isSelected()) {
            String cmd = "set blobshow size;";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(9, "size");
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        } else if (this.file.isSelected()) {
            String pref = this.filePref.getText();
            if (pref == null || pref.length() < 1) {
                return;
            }
            String cmd = "set blobshow file;";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(9, "file");
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
            cmd = "set blobpref '" + pref + "';";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(10, pref);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        } else if (this.print.isSelected()) {
            String width = this.blobWidth.getText();
            if (width == null || width.length() < 1) {
                return;
            }
            String cmd = "set blobshow print;";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(9, "print");
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
            cmd = "set blobwidth " + width + ";";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(11, width);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public static void showDialog(JsqlGUI ui) {
        JsqlBlobShowDialog dlg = new JsqlBlobShowDialog(ui);
        GuiUt.setCenterLocation(ui.getFrame(), dlg);
        dlg.setVisible(true);
    }
}

