/*
 * Decompiled with CFR 0.152.
 */
package ui;

import dbmaker.sql.JdbcOdbcConnection;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionStatus {
    public static final String[] DATE_FORMAT = new String[]{"mm/dd/yy", "mm-dd-yy", "dd/mon/yy", "dd-mon-yy", "mm/dd/yyyy", "mm-dd-yyyy", "yyyy/mm/dd", "yyyy-mm-dd", "dd/mon/yyyy", "dd-mon-yyyy", "dd.mm.yyyy", "yyyy.mm.dd", "all"};
    public static final int[] DATE_FORMAT_INT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final String[] TIME_FORMAT = new String[]{"hh:mm:ss.fff", "hh:mm:ss", "hh:mm", "hh", "hh:mm:ss.fff tt", "hh:mm:ss tt", "hh:mm tt", "hh tt", "tt hh:mm:ss.fff", "tt hh:mm:ss", "tt hh:mm", "tt hh", "all"};
    public static final int[] TIME_FORMAT_INT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final int EXT_NAME = 1;
    public static final int DATE_INPUT_FORMAT = 2;
    public static final int DATE_OUTPUT_FORMAT = 3;
    public static final int TIME_INPUT_FORMAT = 4;
    public static final int TIME_OUTPUT_FORMAT = 5;
    private Connection connection = null;
    private String dbName = null;
    private String userName = null;
    private String password = null;
    private boolean isConnected = false;
    private String dateInputFormat = null;
    private String dateOutputFormat = null;
    private String timeInputFormat = null;
    private String timeOutputFormat = null;

    public void setConnection(Connection connection, String dbName, String userName, String password) {
        if (connection != null) {
            this.connection = connection;
            this.dbName = dbName;
            this.userName = userName;
            this.password = password;
            this.isConnected = true;
        } else {
            this.connection = null;
            this.dbName = null;
            this.userName = null;
            this.password = null;
            this.dateInputFormat = null;
            this.isConnected = false;
        }
    }

    public void setConnectionAttr(int key, String value) throws SQLException {
        if (this.connection == null) {
            return;
        }
        JdbcOdbcConnection con = (JdbcOdbcConnection)this.connection;
        int ret = -1;
        switch (key) {
            case 2: {
                this.dateInputFormat = value;
                ret = this.getDateFormatFromString(this.dateInputFormat);
                con.setOption(1110, ret);
                break;
            }
            case 3: {
                this.dateOutputFormat = value;
                ret = this.getDateFormatFromString(this.dateOutputFormat);
                con.setOption(1111, ret);
                break;
            }
            case 4: {
                this.timeInputFormat = value;
                ret = this.getTimeFormatFromString(this.timeInputFormat);
                con.setOption(1112, ret);
                break;
            }
            case 5: {
                this.timeOutputFormat = value;
                ret = this.getTimeFormatFromString(this.timeOutputFormat);
                con.setOption(1113, ret);
                break;
            }
            default: {
                System.out.println("error");
            }
        }
    }

    public String getConnectionAttr(int key) throws SQLException {
        if (this.connection == null) {
            return null;
        }
        JdbcOdbcConnection con = (JdbcOdbcConnection)this.connection;
        int ret = -1;
        switch (key) {
            case 2: {
                ret = con.getOptionInt(1110);
                this.dateInputFormat = this.getDateFormatFromInt(ret);
                return this.dateInputFormat;
            }
            case 3: {
                ret = con.getOptionInt(1111);
                this.dateOutputFormat = this.getDateFormatFromInt(ret);
                return this.dateOutputFormat;
            }
            case 4: {
                ret = con.getOptionInt(1112);
                this.timeInputFormat = this.getTimeFormatFromInt(ret);
                return this.timeInputFormat;
            }
            case 5: {
                ret = con.getOptionInt(1113);
                this.timeOutputFormat = this.getTimeFormatFromInt(ret);
                return this.timeOutputFormat;
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.format("%20s", "Date in format").toUpperCase() + " : " + this.dateInputFormat + "\n");
        buf.append(String.format("%20s", "Date out format").toUpperCase() + " : " + this.dateOutputFormat + "\n");
        buf.append(String.format("%20s", "Time in format").toUpperCase() + " : " + this.timeInputFormat + "\n");
        buf.append(String.format("%20s", "Time out format").toUpperCase() + " : " + this.timeOutputFormat);
        return buf.toString();
    }

    public String getDBName() {
        if (this.connection == null) {
            return null;
        }
        return this.dbName;
    }

    public String getUserName() {
        if (this.connection == null) {
            return null;
        }
        return this.userName;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private int getDateFormatFromString(String format) {
        for (int i = 0; i < DATE_FORMAT.length; ++i) {
            if (!format.equals(DATE_FORMAT[i])) continue;
            return DATE_FORMAT_INT[i];
        }
        return -1;
    }

    private String getDateFormatFromInt(int format) {
        for (int i = 0; i < DATE_FORMAT.length; ++i) {
            if (format != DATE_FORMAT_INT[i]) continue;
            return DATE_FORMAT[i];
        }
        return null;
    }

    private int getTimeFormatFromString(String format) {
        for (int i = 0; i < TIME_FORMAT.length; ++i) {
            if (!format.equals(TIME_FORMAT[i])) continue;
            return TIME_FORMAT_INT[i];
        }
        return -1;
    }

    private String getTimeFormatFromInt(int format) {
        for (int i = 0; i < TIME_FORMAT.length; ++i) {
            if (format != TIME_FORMAT_INT[i]) continue;
            return TIME_FORMAT[i];
        }
        return null;
    }
}

