/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.restore;

import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.DbaUtDef;
import dbaut.GuiUt;
import dbaut.JBackupHistory;
import dbaut.JdmConfig;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaFileFilter;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.comp.WizardTextPane;
import dbaut.locale.LocaleManager;
import dbaut.panel.PanelWithVerticalLayout;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.FilePathField;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import svrmgrwizard.restore.CreateHistoryFailedException;
import svrmgrwizard.restore.OffBackupListFile;
import svrmgrwizard.restore.PanelRestoreOfflineFullBackup;
import svrmgrwizard.restore.PanelRestoreOfflineSummary;
import svrmgrwizard.restore.PanelRestoreOnlineFullBackup;
import svrmgrwizard.restore.PanelRestoreOnlineSummary;
import svrmgrwizard.restore.RestoreConstants;
import svrmgrwizard.restore.RestoreDlg;

public class PanelRestoreInitLocation
extends AbstractWizardPanel {
    private static final long serialVersionUID = 3825256919242216219L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.ResWizard", LocaleManager.getLocale());
    private RestoreDlg parentDlg = null;
    private AbstractWizardPanel previousPanel = null;
    private String title = null;
    private AbstractWizardPanel next = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton nextButton = new DbaButton(new Dimension(100, 24), this.res.getString("Next_"), 'N', DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"), new ReflectionAction(this, "nextButtonActionPerformed"));
    private DbaButton lastButton = new DbaButton(new Dimension(100, 24), this.res.getString("Last"), 'L', DBAImageResource.getResource(this.getClass(), "/dbautimages/last.gif"), new ReflectionAction(this, "lastButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(100, 24), this.res.getString("_Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private FilePathField configFilePathField = new FilePathField((Component)this, false, new DbaFileFilter("ini", "Ini Files (*.ini)"));
    private SteppedComboBox DatabaseNames_ComboBox = new SteppedComboBox();
    private FilePathField HistoryFile_Field = new FilePathField((Component)this, false, new DbaFileFilter[]{new DbaFileFilter("lst", "List Files (*.lst)"), new DbaFileFilter("his", "History Files (*.his)")});
    private String configFileFullPath = null;
    private String restoreDBName = null;
    private String historyFileFullPath = null;
    private String fOHistoryFileFullPath = null;
    private String spHistoryFileFullPath = null;

    public PanelRestoreInitLocation(RestoreDlg parentDlg, AbstractWizardPanel previousPanel) {
        this.parentDlg = parentDlg;
        this.previousPanel = previousPanel;
        this.init();
    }

    private void init() {
        this.setName("InitLocationPanel");
        this.nextButton.setName("NextButton");
        this.lastButton.setName("LastButton");
        this.DatabaseNames_ComboBox.setName("DatabaseNameComboBox");
        this.configFilePathField.setName("ConfigFilePathPanel");
        this.HistoryFile_Field.setName("HistoryFilePathPanel");
        JPanel mainPanel = new JPanel(new BorderLayout());
        ImageIcon imgWizard = DBAImageResource.getResource(this.getClass(), "/svrmgrimages/restorewizard-1.gif");
        JLabel imgLabel = new JLabel();
        imgLabel.setBorder(BorderFactory.createEtchedBorder());
        imgLabel.setIcon(new ImageIcon(imgWizard.getImage().getScaledInstance(150, 450, 4)));
        mainPanel.add((Component)imgLabel, "West");
        JScrollPane jScrollPane1 = new JScrollPane();
        WizardTextPane jTextPane1 = new WizardTextPane(20, 14);
        jScrollPane1.setPreferredSize(new Dimension(-1, 205));
        jTextPane1.setText(this.res.getString("Restore_Init_Location_FullStop"));
        jTextPane1.setBackground(Color.white);
        jScrollPane1.getViewport().add((Component)jTextPane1, null);
        PanelWithVerticalLayout xyPanel = new PanelWithVerticalLayout("North");
        PanelWithVerticalLayout jPanel2 = new PanelWithVerticalLayout();
        JLabel jLabel2 = new JLabel(this.res.getString("Restore_Configuration_From"));
        ((Container)jPanel2).add(jLabel2);
        this.configFilePathField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    PanelRestoreInitLocation.this.configFilePathFieldEvent();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PanelRestoreInitLocation.this.configFilePathFieldEvent();
            }
        });
        this.configFilePathField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelRestoreInitLocation.this.configFilePathFieldEvent();
            }
        });
        this.configFilePathField.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(134, 134, 134)), this.res.getString("Restore_Dmconfig_ini")));
        ((Container)jPanel2).add(this.configFilePathField);
        ((Container)xyPanel).add(jPanel2);
        PanelWithVerticalLayout jPanel3 = new PanelWithVerticalLayout("North");
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(134, 134, 134)), this.res.getString("Select_To_Be_Restore_Database")));
        JLabel jLabel3 = new JLabel(this.res.getString("Database_Name_"));
        ((Container)jPanel3).add(jLabel3);
        this.DatabaseNames_ComboBox.addActionListener(new ReflectionAction(this, "DatabaseNamesComboBoxActionPerformed"));
        ((Container)jPanel3).add(this.DatabaseNames_ComboBox);
        JLabel jLabel4 = new JLabel(this.res.getString("Get_History_File_From"));
        ((Container)jPanel3).add(jLabel4);
        this.HistoryFile_Field.setBorder(BorderFactory.createLoweredBevelBorder());
        ((Container)jPanel3).add(this.HistoryFile_Field);
        this.HistoryFile_Field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    PanelRestoreInitLocation.this.historyFileFieldEvent();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PanelRestoreInitLocation.this.historyFileFieldEvent();
            }
        });
        this.HistoryFile_Field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelRestoreInitLocation.this.historyFileFieldEvent();
            }
        });
        ((Container)xyPanel).add(jPanel3);
        this.initExistPathLocation();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)jScrollPane1, "North");
        panel.add((Component)xyPanel, "Center");
        mainPanel.add((Component)panel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.nextButton.setHorizontalTextPosition(2);
        this.lastButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Wizard_restore_init_location", null);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(this.lastButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        this.add((Component)mainPanel, "Center");
        this.setButtonBar(buttonPanel);
        this.nextButton.setEnabled(false);
        this.lastButton.setEnabled(false);
    }

    private void initExistPathLocation() {
        String filePath = SmFrame.frame.configfilename;
        if (filePath != null) {
            this.configFilePathField.setText(filePath);
            this.configFileFullPath = filePath;
        }
        Vector<String> dataSource = JdmConfig.getDatabaseNames("dmconfig.ini", true);
        dataSource.insertElementAt(new String("  "), 0);
        DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>(dataSource);
        this.DatabaseNames_ComboBox.setModel((ComboBoxModel)comboBoxModel);
        this.DatabaseNames_ComboBox.setSelectedIndex(0);
        this.HistoryFile_Field.setText("");
    }

    private void configFilePathFieldEvent() {
        String config;
        DefaultComboBoxModel<String> model = (DefaultComboBoxModel<String>)this.DatabaseNames_ComboBox.getModel();
        if (model.getSize() > 0) {
            model.removeAllElements();
        }
        if ((config = this.configFilePathField.getText()) == null || config.trim().length() <= 0 || !config.trim().endsWith(".ini")) {
            System.out.println("PanelRestoreInitLocation---get dmconfig.ini path error");
            return;
        }
        File f = new File(config);
        if (f.exists()) {
            this.configFileFullPath = config;
            Vector<String> v = JdmConfig.getDatabaseNames(config, true);
            v.insertElementAt(new String("  "), 0);
            model = new DefaultComboBoxModel<String>(v);
            this.DatabaseNames_ComboBox.setModel((ComboBoxModel)model);
            this.DatabaseNames_ComboBox.setSelectedIndex(0);
            this.HistoryFile_Field.setText("");
        }
    }

    private void historyFileFieldEvent() {
        String hisFilePath = this.HistoryFile_Field.getText();
        System.out.println(hisFilePath);
        if (hisFilePath == null || hisFilePath.trim().length() <= 0) {
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
        } else if (hisFilePath.trim().endsWith("dmBackup.his") || hisFilePath.trim().endsWith("dmOffBK.lst") || hisFilePath.trim().endsWith("dmOffBK.his")) {
            this.nextButton.setEnabled(true);
            this.lastButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
        }
    }

    public void DatabaseNamesComboBoxActionPerformed(ActionEvent e) {
        String dbName = (String)this.DatabaseNames_ComboBox.getSelectedItem();
        if (dbName == null || dbName.trim().length() <= 0) {
            this.HistoryFile_Field.setText("");
            this.HistoryFile_Field.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
        } else {
            this.HistoryFile_Field.setEnabled(true);
            this.nextButton.setEnabled(true);
            this.lastButton.setEnabled(true);
            String db_bkdir = JdmConfig.getOnlineBackupDir(this.configFileFullPath, dbName);
            if (db_bkdir == null || db_bkdir.trim().length() < 1) {
                this.HistoryFile_Field.setText("");
            } else {
                String hisFilePath;
                File file;
                String tmpStr = db_bkdir;
                if (!tmpStr.endsWith(RestoreConstants.FILE_SEPARATOR)) {
                    tmpStr = db_bkdir + RestoreConstants.FILE_SEPARATOR;
                }
                if ((file = new File(hisFilePath = tmpStr + "dmBackup.his")).exists()) {
                    this.HistoryFile_Field.setText(hisFilePath);
                } else {
                    this.HistoryFile_Field.setText("");
                }
            }
        }
    }

    public void nextButtonActionPerformed(ActionEvent e) {
        block6: {
            this.configFileFullPath = this.getConfigFilePath();
            this.restoreDBName = this.getRestoreDBName();
            this.historyFileFullPath = this.getHistoryFilePath();
            this.fOHistoryFileFullPath = this.getFOMapFilePath();
            this.spHistoryFileFullPath = this.getSpBkFilePath();
            File hisFile = new File(this.historyFileFullPath);
            if (!hisFile.exists()) {
                GuiUt.showErrorDlg(this.parentDlg, hisFile.getAbsolutePath() + " " + this.res.getString("file_not_exist_fullstop"), "");
                return;
            }
            try {
                if (this.historyFileFullPath.endsWith("dmBackup.his")) {
                    this.next = new PanelRestoreOnlineFullBackup(this.parentDlg, this, this.configFileFullPath, this.restoreDBName, this.historyFileFullPath, this.fOHistoryFileFullPath, this.spHistoryFileFullPath);
                    break block6;
                }
                if (this.historyFileFullPath.endsWith("dmOffBK.his")) {
                    this.next = new PanelRestoreOfflineFullBackup(this.parentDlg, this, this.configFileFullPath, this.restoreDBName, this.historyFileFullPath, false);
                    break block6;
                }
                if (this.historyFileFullPath.endsWith("dmOffBK.lst")) {
                    this.next = new PanelRestoreOfflineFullBackup(this.parentDlg, this, this.configFileFullPath, this.restoreDBName, this.historyFileFullPath, true);
                    break block6;
                }
                GuiUt.showErrorDlg(this.parentDlg, hisFile.getAbsolutePath() + " " + this.res.getString("file_format_wrong_fullstop"), "");
                return;
            }
            catch (CreateHistoryFailedException e1) {
                GuiUt.showErrorDlg(this.parentDlg, this.res.getString("backup_sequence_is_incomplete_excalmatorymark"), "");
                return;
            }
        }
        this.parentDlg.Next(this.next);
    }

    public void lastButtonActionPerformed(ActionEvent e) {
        boolean isOffline;
        File hisFile;
        this.configFileFullPath = this.getConfigFilePath();
        this.restoreDBName = this.getRestoreDBName();
        this.historyFileFullPath = this.getHistoryFilePath();
        if (this.historyFileFullPath.endsWith("dmOffBK.lst")) {
            OffBackupListFile listFile = new OffBackupListFile(this.historyFileFullPath);
            this.historyFileFullPath = listFile.getLastHisPath();
        }
        if (!(hisFile = new File(this.historyFileFullPath)).exists()) {
            GuiUt.showErrorDlg(this.parentDlg, hisFile.getAbsolutePath() + " " + this.res.getString("file_not_exist_fullstop"), "");
            return;
        }
        JBackupHistory historyFile = new JBackupHistory(SmFrame.frame);
        int rc = historyFile.FileOpen(this.restoreDBName, this.historyFileFullPath, "0");
        if (rc != DbaUtDef.RTN_OK) {
            return;
        }
        Vector fullBackupList = historyFile.getFullBackupList();
        historyFile.FileClose();
        if (fullBackupList.size() < 1) {
            GuiUt.showErrorDlg(this.parentDlg, hisFile.getAbsolutePath() + " " + this.res.getString("Backup sequence is incomplete!"), "");
            return;
        }
        String fullBackupInfo = (String)fullBackupList.get(0);
        String offlineRTime = fullBackupInfo.substring(6, 25);
        boolean bl = isOffline = fullBackupInfo.indexOf("off") > -1;
        if (isOffline) {
            this.next = new PanelRestoreOfflineSummary(this.parentDlg, this, this.configFileFullPath, this.restoreDBName, this.historyFileFullPath, this.historyFileFullPath, offlineRTime);
        } else {
            Calendar now = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            String nowTimeString = sdf.format(now.getTime());
            this.fOHistoryFileFullPath = this.getFOMapFilePath();
            this.spHistoryFileFullPath = this.getSpBkFilePath();
            this.next = new PanelRestoreOnlineSummary(this.parentDlg, this, this.configFileFullPath, this.restoreDBName, this.historyFileFullPath, this.historyFileFullPath, this.fOHistoryFileFullPath, this.spHistoryFileFullPath, nowTimeString);
        }
        this.parentDlg.Next(this.next);
    }

    public void previousButtonActionPerformed(ActionEvent e) {
        this.parentDlg.Next(this.previousPanel);
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.parentDlg.dispose();
    }

    @Override
    public String getTitle() {
        this.title = "Restore_Database_Init_File_Location";
        return this.title;
    }

    public String getConfigFilePath() {
        return this.configFilePathField.getText().trim();
    }

    public String getRestoreDBName() {
        return this.DatabaseNames_ComboBox.getSelectedItem().toString();
    }

    public String getHistoryFilePath() {
        return this.HistoryFile_Field.getText().trim();
    }

    private String getFOMapFilePath() {
        String db_bkdir = JdmConfig.getOnlineBackupDir(this.configFileFullPath, this.restoreDBName);
        String foMap = db_bkdir + RestoreConstants.FILE_SEPARATOR + "FO" + RestoreConstants.FILE_SEPARATOR + "dmFoMap.his";
        File file = new File(foMap);
        if (!file.exists()) {
            foMap = "";
        }
        return foMap;
    }

    private String getSpBkFilePath() {
        String db_bkdir = JdmConfig.getOnlineBackupDir(this.configFileFullPath, this.restoreDBName);
        String spBk = db_bkdir + RestoreConstants.FILE_SEPARATOR + "SP" + RestoreConstants.FILE_SEPARATOR + "dmSpBk.his";
        File file = new File(spBk);
        if (!file.exists()) {
            spBk = "";
        }
        return spBk;
    }
}

