/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.diagnoseDB;

import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.ColumnTableModel;
import dbaut.GuiUt;
import dbaut.SyscomCommonDatabaseConnection;
import dbaut.alarm.Sleeper;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import svrmgrwizard.diagnoseDB.Alarm;
import svrmgrwizard.diagnoseDB.Introduction;
import svrmgrwizard.diagnoseDB.ProcessPanel;

public class RepairTableDialog
extends JDialog
implements Sleeper {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.DiagnoseRes", LocaleManager.getLocale());
    private JPanel self = new JPanel(new BorderLayout());
    private AbstractWizardPanel current = null;
    String dbname = null;
    String password = null;
    String username = null;
    SyscomCommonDatabaseConnection conn = null;
    boolean autorepiar = false;
    boolean repaired = false;
    boolean hasError = false;
    int repairoption = 0;
    boolean isRepairOn = false;
    String endline = GuiUt.isWindows() ? "\r\n" : "\n";
    StringBuffer log = new StringBuffer(1024);
    ColumnTableModel checktable_model = new ColumnTableModel(new String[]{this.res.getString("Status"), this.res.getString("Owner"), this.res.getString("Table"), this.res.getString("Message")});
    ColumnTableModel checkcatalog_model = new ColumnTableModel(new String[]{this.res.getString("Status"), this.res.getString("Tablespace"), this.res.getString("Message")});

    public RepairTableDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.setName("DiagnoseDatabaseDialog");
        this.setSize(640, 480);
        this.getContentPane().add(this.self);
        this.Next(new Introduction(this));
    }

    @Override
    public void dispose() {
        Statement stmt = null;
        if (this.conn != null && this.conn.isConnected) {
            try {
                stmt = this.conn.getDbConnection().createStatement();
                this.setRepairOption(this.conn, stmt, false);
                stmt.close();
            }
            catch (SQLException sqle) {
                GuiUt.showSQLException(this, this.res.getString("CreateStatement_error"), sqle);
                return;
            }
            this.conn.disconnect();
            this.conn = null;
        }
        super.dispose();
    }

    public boolean setRepairOption(SyscomCommonDatabaseConnection conn, Statement stmt, boolean on) {
        Connection dbconn = conn.getDbConnection();
        if ((double)conn.getDBMakerVersion() < 3.9) {
            try {
                ((JdbcOdbcConnection)dbconn).setOption(1140, on ? 1 : 0);
                this.isRepairOn = on;
                return true;
            }
            catch (SQLException sqle) {
                GuiUt.showErrorDlg(this, this.res.getString("set_repair_option_error") + sqle.getMessage(), null);
                return false;
            }
        }
        String query = "call SETSYSTEMOPTION('dbrepair', " + (on ? "'1'" : "'0'") + ")";
        this.isRepairOn = on;
        try {
            stmt.execute(query);
            return true;
        }
        catch (SQLException sqle) {
            GuiUt.showErrorDlg(this, query + " error: " + sqle.getMessage(), null);
            return false;
        }
    }

    public void Next(AbstractWizardPanel panel) {
        Component comp;
        this.self.removeAll();
        this.current = panel;
        this.setTitle(this.res.getString("Frame_title") + " - " + panel.getTitle());
        this.self.add((Component)this.current, "Center");
        this.current.setCursor(Cursor.getPredefinedCursor(0));
        this.self.revalidate();
        this.self.repaint();
        if (this.current instanceof ProcessPanel) {
            Alarm clock = new Alarm();
            clock.cancelAlarm(this);
            clock.setAlarmMilli(this, 10);
        }
        if ((comp = this.current.getFocusComponent()) != null) {
            comp.requestFocus();
        }
    }

    @Override
    public synchronized void wakeUp() {
        if (this.current instanceof ProcessPanel) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            ((ProcessPanel)((Object)this.current)).procStart();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

