/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.diagnoseDB;

import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.JdmConfig;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import svrmgrwizard.diagnoseDB.FinalPanel;
import svrmgrwizard.diagnoseDB.RepairTableDialog;

public class RepairReport
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.DiagnoseRes", LocaleManager.getLocale());
    private String title = this.res.getString("wizard_title7");
    private RepairTableDialog redlg = null;
    private AbstractWizardPanel next1 = null;
    private AbstractWizardPanel previous = null;

    public RepairReport(RepairTableDialog redlg, AbstractWizardPanel previous) {
        try {
            this.redlg = redlg;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setName("RepairReportPanel");
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        DbaButton save_Button = new DbaButton(this.res.getString("Save"), 'S', new ReflectionAction(this, "save_Button_actionPerformed"));
        DbaButton next_Button = new DbaButton();
        next_Button.setName("NextButton");
        SmHelpButton help_Button = new SmHelpButton();
        JTextPane textpanel = new JTextPane();
        JPanel panel1 = new JPanel(new BorderLayout(10, 0));
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel(new BorderLayout());
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("This_is_the_status"));
        JScrollPane jscroll2 = new JScrollPane(textpanel);
        next_Button.setHorizontalTextPosition(2);
        next_Button.setMnemonic('N');
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        save_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/save.gif"));
        jscroll2.setVerticalScrollBarPolicy(20);
        textpanel.setEditable(false);
        textpanel.setText(this.redlg.log.toString());
        next_Button.addActionListener(new ReflectionAction(this, "next_Button_actionPerformed"));
        SmFrame.frame.enableDialogHelp(this, help_Button, "wizard_DiagnoseDB_RepairReport", null);
        JPanel panel7 = new JPanel(new FlowLayout(0));
        panel7.add((Component)save_Button, null);
        panel6.add((Component)jscroll2, "Center");
        panel6.add((Component)panel7, "South");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/svrmgrimages/DiagnoseDB.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        panel4.add(back_Button);
        panel4.add(next_Button);
        panel4.add(new EmptyPanel());
        if (!this.redlg.repaired) {
            panel4.add(new EmptyPanel());
            next_Button.setText(this.res.getString("Done"));
            next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/done.gif"));
        } else {
            panel4.add(cancel_Button);
            next_Button.setText(this.res.getString("Next"));
            next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"));
        }
        panel4.add(help_Button);
    }

    public void save_Button_actionPerformed(ActionEvent e) {
        String dbdir = JdmConfig.getDBDir(this.redlg.dbname);
        if (dbdir == null) {
            dbdir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser(dbdir);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        int state = chooser.showDialog(this.redlg, this.res.getString("Save"));
        if (state == 0) {
            File f = chooser.getSelectedFile();
            try {
                FileOutputStream out = new FileOutputStream(f);
                out.write(this.redlg.log.toString().getBytes());
                out.close();
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.redlg.Next(this.previous);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        if (!this.redlg.repaired) {
            this.cancel_Button_actionPerformed(e);
            return;
        }
        if (this.next1 == null) {
            this.next1 = new FinalPanel(this.redlg, this);
        }
        this.redlg.Next(this.next1);
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.redlg.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

