/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.backup;

import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.WizardTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import svrmgrwizard.backup.BackupDlg;
import svrmgrwizard.backup.OnlineBackupByBackupServerPanel;
import svrmgrwizard.backup.OnlineDifferentialBackupPanel;
import svrmgrwizard.backup.OnlineFullBackupPanel;
import svrmgrwizard.backup.OnlineFullBackupToTapePanel;
import svrmgrwizard.backup.OnlineIncrementalBackupPanel;
import svrmgrwizard.backup.OnlineIncrementalBackupToCurrentPanel;

public class SelectOnlineBackupTypePanel
extends AbstractWizardPanel {
    private static final long serialVersionUID = -737883015775053213L;
    private BackupDlg parentDialog = null;
    private AbstractWizardPanel previousPanel = null;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.BackupRes", LocaleManager.getLocale());
    private String title = null;
    private AbstractWizardPanel next = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton nextButton = new DbaButton(new Dimension(100, 24), this.res.getString("Next"), 'N', DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"), new ReflectionAction(this, "nextButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(100, 24), this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private JRadioButton backupServerFullBackupRadioButton = new JRadioButton(this.res.getString("Full_Backup"), true);
    private JRadioButton backupServerDifferentialBackupRadioButton = new JRadioButton(this.res.getString("Differential_Backup"));
    private JRadioButton backupServerIncrementalBackupRadioButton = new JRadioButton(this.res.getString("Incremental_Backup"));
    private JRadioButton interactiveFullBackupRadioButton = new JRadioButton(this.res.getString("Full_Backup"), true);
    private JRadioButton interactiveDifferentialBackupRadioButton = new JRadioButton(this.res.getString("Differential_Backup"));
    private JRadioButton interactiveIncrementalBackupRadioButton = new JRadioButton(this.res.getString("Incremental_Backup"));
    private JRadioButton interactiveIncrementalBackupToCurrentRadioButton = new JRadioButton(this.res.getString("Incremental_Backup_To_Current"));
    private JCheckBox isToTapeCheckBox = new JCheckBox(this.res.getString("Is_To_Tape"));
    private boolean isToTapeStatus = false;
    private DatabaseConnection connection = null;
    private ArrayList connectionInfo = null;
    private JRadioButton byBackupServerRadioButton = null;
    private JRadioButton interactiveRadioButton = null;
    private String dbName = null;
    private String rpMode = "1";

    public SelectOnlineBackupTypePanel(BackupDlg parentDialog, AbstractWizardPanel previousPanel, DatabaseConnection connection, ArrayList connectionInfo) {
        this.parentDialog = parentDialog;
        this.previousPanel = previousPanel;
        this.connection = connection;
        this.connectionInfo = connectionInfo;
        this.init();
    }

    private void init() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel jLabel1 = new JLabel();
        jLabel1.setBorder(BorderFactory.createLoweredBevelBorder());
        ImageIcon imgIcon = DBAImageResource.getResource(this.getClass(), "/svrmgrimages/BackupDBleft.gif");
        jLabel1.setIcon(imgIcon);
        JPanel jPanel1 = new JPanel();
        jPanel1.setPreferredSize(new Dimension(470, 440));
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        jPanel1.setLayout(new BorderLayout());
        WizardTextPane jTextPane1 = new WizardTextPane(20, 14);
        jTextPane1.setText(this.res.getString("Online_Backup_Description_FullStop"));
        JPanel selectPanel = new JPanel((LayoutManager)new XYLayout());
        selectPanel.setBorder(BorderFactory.createEtchedBorder());
        this.byBackupServerRadioButton = new JRadioButton(this.res.getString("By_Backup_Server"));
        this.interactiveRadioButton = new JRadioButton(this.res.getString("Interactive_Backup"));
        selectPanel.add((Component)this.byBackupServerRadioButton, new XYConstraints(10, 5, 300, 20));
        selectPanel.add((Component)this.backupServerFullBackupRadioButton, new XYConstraints(40, 30, 300, 20));
        selectPanel.add((Component)this.backupServerDifferentialBackupRadioButton, new XYConstraints(40, 55, 300, 20));
        selectPanel.add((Component)this.backupServerIncrementalBackupRadioButton, new XYConstraints(40, 80, 300, 20));
        selectPanel.add((Component)this.interactiveRadioButton, new XYConstraints(10, 105, 300, 20));
        selectPanel.add((Component)this.interactiveFullBackupRadioButton, new XYConstraints(40, 130, 140, 20));
        selectPanel.add((Component)this.isToTapeCheckBox, new XYConstraints(180, 130, 250, 20));
        selectPanel.add((Component)this.interactiveIncrementalBackupRadioButton, new XYConstraints(40, 155, 300, 20));
        selectPanel.add((Component)this.interactiveIncrementalBackupToCurrentRadioButton, new XYConstraints(40, 180, 300, 20));
        ButtonGroup bg0 = new ButtonGroup();
        bg0.add(this.byBackupServerRadioButton);
        bg0.add(this.interactiveRadioButton);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.backupServerFullBackupRadioButton);
        bg1.add(this.backupServerDifferentialBackupRadioButton);
        bg1.add(this.backupServerIncrementalBackupRadioButton);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.interactiveFullBackupRadioButton);
        bg2.add(this.interactiveIncrementalBackupRadioButton);
        bg2.add(this.interactiveIncrementalBackupToCurrentRadioButton);
        this.byBackupServerRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectOnlineBackupTypePanel.this.byBackupServerRadioButtonActionPerformed(e);
            }
        });
        this.interactiveRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectOnlineBackupTypePanel.this.interactiveRadioButtonActionPerformed(e);
            }
        });
        this.interactiveFullBackupRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectOnlineBackupTypePanel.this.interactiveFullBackupRadioButtonActionPerformed(e);
            }
        });
        this.interactiveIncrementalBackupRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectOnlineBackupTypePanel.this.interactiveIncrementalBackupRadioButtonActionPerformed(e);
            }
        });
        this.interactiveIncrementalBackupToCurrentRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectOnlineBackupTypePanel.this.interactiveIncrementalBackupToCurrentRadioButtonActionPerformed(e);
            }
        });
        this.isToTapeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectOnlineBackupTypePanel.this.isToTapeCheckBoxActionPerformed(e);
            }
        });
        jPanel1.add((Component)jTextPane1, "North");
        jPanel1.add((Component)selectPanel, "Center");
        panel.add((Component)jLabel1, "West");
        panel.add((Component)jPanel1, "East");
        this.add((Component)panel, "Center");
        this.setName("SelectOnlineBackupTypePanel");
        this.byBackupServerRadioButton.setName("ByBackupServerRadioButton");
        this.backupServerFullBackupRadioButton.setName("ByBKsvrFullRadioButton");
        this.backupServerDifferentialBackupRadioButton.setName("ByBksvrDiffRadioButton");
        this.backupServerIncrementalBackupRadioButton.setName("ByBksvrIncRadioButton");
        this.interactiveRadioButton.setName("InteractiveRadioButton");
        this.interactiveFullBackupRadioButton.setName("InterFullRadioButton");
        this.interactiveIncrementalBackupRadioButton.setName("InterIncRadioButton");
        this.interactiveIncrementalBackupToCurrentRadioButton.setName("InterIncCurrentRadioButton");
        this.nextButton.setName("NextButton");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.nextButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Help_Backup_SelectOnlineBackupTypePanel", null);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        this.setButtonBar(buttonPanel);
        this.initBackupTypeRadioButtonStatus();
    }

    private void initBackupTypeRadioButtonStatus() {
        JdmConfig dmconfig = new JdmConfig();
        this.dbName = (String)this.connectionInfo.get(0);
        if (this.connection != null) {
            try {
                String sql = "CALL GETSYSTEMOPTION('BKSVR',?)";
                CallableStatement stmt = this.connection.dbconn.prepareCall(sql);
                stmt.registerOutParameter(1, 12);
                stmt.executeQuery();
                String value = stmt.getString(1);
                if (value.equalsIgnoreCase("1") && dmconfig.isLocalHost("dmconfig.ini", this.dbName)) {
                    this.byBackupServerRadioButton.setEnabled(true);
                    this.interactiveRadioButton.setEnabled(true);
                    this.byBackupServerRadioButton.setSelected(true);
                    this.byBackupServerRadioButtonActionPerformed(null);
                    this.nextButton.setEnabled(true);
                } else if (value.equalsIgnoreCase("1") && !dmconfig.isLocalHost("dmconfig.ini", this.dbName)) {
                    this.byBackupServerRadioButton.setEnabled(true);
                    this.byBackupServerRadioButton.setSelected(true);
                    this.interactiveRadioButton.setEnabled(false);
                    this.interactiveFullBackupRadioButton.setEnabled(false);
                    this.interactiveIncrementalBackupRadioButton.setEnabled(false);
                    this.interactiveIncrementalBackupToCurrentRadioButton.setEnabled(false);
                    this.isToTapeCheckBox.setEnabled(false);
                    this.nextButton.setEnabled(true);
                } else if (value.equalsIgnoreCase("0") && dmconfig.isLocalHost("dmconfig.ini", this.dbName)) {
                    this.byBackupServerRadioButton.setEnabled(false);
                    this.interactiveRadioButton.setSelected(true);
                    this.interactiveRadioButtonActionPerformed(null);
                    this.nextButton.setEnabled(true);
                } else {
                    this.byBackupServerRadioButton.setEnabled(false);
                    this.interactiveRadioButton.setEnabled(false);
                    this.backupServerFullBackupRadioButton.setEnabled(false);
                    this.backupServerDifferentialBackupRadioButton.setEnabled(false);
                    this.backupServerIncrementalBackupRadioButton.setEnabled(false);
                    this.interactiveFullBackupRadioButton.setEnabled(false);
                    this.interactiveIncrementalBackupRadioButton.setEnabled(false);
                    this.interactiveIncrementalBackupToCurrentRadioButton.setEnabled(false);
                    this.isToTapeCheckBox.setEnabled(false);
                    this.nextButton.setEnabled(false);
                }
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void byBackupServerRadioButtonActionPerformed(ActionEvent e) {
        if (this.byBackupServerRadioButton.isSelected()) {
            this.backupServerFullBackupRadioButton.setEnabled(true);
            this.backupServerDifferentialBackupRadioButton.setEnabled(true);
            this.backupServerIncrementalBackupRadioButton.setEnabled(true);
            this.interactiveFullBackupRadioButton.setEnabled(false);
            this.isToTapeCheckBox.setEnabled(false);
            this.interactiveIncrementalBackupRadioButton.setEnabled(false);
            this.interactiveIncrementalBackupToCurrentRadioButton.setEnabled(false);
        }
    }

    private void interactiveRadioButtonActionPerformed(ActionEvent e) {
        if (this.interactiveRadioButton.isSelected()) {
            try {
                String sql2 = "CALL GETSYSTEMOPTION('RPMODE',?)";
                CallableStatement stmt2 = this.connection.dbconn.prepareCall(sql2);
                stmt2.registerOutParameter(1, 12);
                stmt2.execute();
                this.rpMode = stmt2.getString(1).trim();
                stmt2.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            this.backupServerFullBackupRadioButton.setEnabled(false);
            this.backupServerDifferentialBackupRadioButton.setEnabled(false);
            this.backupServerIncrementalBackupRadioButton.setEnabled(false);
            this.interactiveFullBackupRadioButton.setEnabled(true);
            if (this.interactiveFullBackupRadioButton.isSelected()) {
                this.isToTapeCheckBox.setEnabled(true);
            } else {
                this.isToTapeCheckBox.setEnabled(false);
            }
            if (this.rpMode.equalsIgnoreCase("1")) {
                this.interactiveIncrementalBackupRadioButton.setEnabled(false);
                this.interactiveIncrementalBackupToCurrentRadioButton.setEnabled(false);
            } else {
                this.interactiveIncrementalBackupRadioButton.setEnabled(true);
                this.interactiveIncrementalBackupToCurrentRadioButton.setEnabled(true);
            }
        }
    }

    private void interactiveFullBackupRadioButtonActionPerformed(ActionEvent e) {
        if (this.interactiveFullBackupRadioButton.isSelected()) {
            this.isToTapeCheckBox.setEnabled(true);
            this.isToTapeCheckBox.setSelected(this.isToTapeStatus);
        }
    }

    private void interactiveDifferentialBackupRadioButtonActionPerformed(ActionEvent e) {
        if (this.isToTapeCheckBox.isEnabled()) {
            this.isToTapeStatus = this.isToTapeCheckBox.isSelected();
        }
        if (this.interactiveDifferentialBackupRadioButton.isSelected()) {
            this.isToTapeCheckBox.setEnabled(false);
        }
    }

    private void interactiveIncrementalBackupRadioButtonActionPerformed(ActionEvent e) {
        if (this.isToTapeCheckBox.isEnabled()) {
            this.isToTapeStatus = this.isToTapeCheckBox.isSelected();
        }
        if (this.interactiveIncrementalBackupRadioButton.isSelected()) {
            this.isToTapeCheckBox.setEnabled(false);
        }
    }

    private void interactiveIncrementalBackupToCurrentRadioButtonActionPerformed(ActionEvent e) {
        if (this.isToTapeCheckBox.isEnabled()) {
            this.isToTapeStatus = this.isToTapeCheckBox.isSelected();
        }
        if (this.interactiveIncrementalBackupToCurrentRadioButton.isSelected()) {
            this.isToTapeCheckBox.setEnabled(false);
        }
    }

    private void isToTapeCheckBoxActionPerformed(ActionEvent e) {
        this.isToTapeStatus = this.isToTapeCheckBox.isSelected();
    }

    public void previousButtonActionPerformed(ActionEvent e) {
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.parentDialog.next(this.previousPanel);
    }

    public void nextButtonActionPerformed(ActionEvent e) {
        try {
            if (this.byBackupServerRadioButton.isSelected()) {
                int tmpType = -1;
                if (this.backupServerFullBackupRadioButton.isSelected()) {
                    tmpType = 3;
                } else if (this.backupServerDifferentialBackupRadioButton.isSelected()) {
                    tmpType = 6;
                } else if (this.backupServerIncrementalBackupRadioButton.isSelected()) {
                    tmpType = 8;
                } else {
                    System.out.println("Unsupported backup type by backup server.");
                    return;
                }
                this.next = new OnlineBackupByBackupServerPanel(this.parentDialog, this, tmpType, this.connection, this.connectionInfo);
            }
            if (this.interactiveRadioButton.isSelected()) {
                if (this.interactiveFullBackupRadioButton.isSelected() && this.isToTapeCheckBox.isSelected()) {
                    this.next = new OnlineFullBackupToTapePanel(this.parentDialog, this, this.connection, this.connectionInfo);
                } else if (this.interactiveFullBackupRadioButton.isSelected() && !this.isToTapeCheckBox.isSelected()) {
                    this.next = new OnlineFullBackupPanel(this.parentDialog, this, this.connection, this.connectionInfo);
                } else if (this.interactiveDifferentialBackupRadioButton.isSelected()) {
                    this.next = new OnlineDifferentialBackupPanel(this.parentDialog, this, this.connection, this.connectionInfo);
                } else if (this.interactiveIncrementalBackupRadioButton.isSelected()) {
                    this.next = new OnlineIncrementalBackupPanel(this.parentDialog, this, this.connection, this.connectionInfo);
                } else if (this.interactiveIncrementalBackupToCurrentRadioButton.isSelected()) {
                    this.next = new OnlineIncrementalBackupToCurrentPanel(this.parentDialog, this, this.connection, this.connectionInfo);
                } else {
                    System.out.println("Unsupported interactive backup type.");
                    return;
                }
            }
            this.parentDialog.next(this.next);
        }
        catch (Exception ex) {
            GuiUt.showErrorDlg(this.parentDialog, ex.getMessage(), "");
        }
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.next = null;
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.parentDialog.dispose();
    }

    @Override
    public void windowClosing() {
        this.cancelButtonActionPerformed(null);
    }

    @Override
    public String getTitle() {
        this.title = "Select_Online_Backup_Type";
        return this.title;
    }
}

