/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.FilePathField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import queryAnalyzer.DbaFileFilter;
import queryAnalyzer.HelpButton;
import queryAnalyzer.QueryFrame;

public class RunBatchDlg
extends JDialog {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    private DBAResourceBundle res2 = DBAResourceBundle.getDBAResourceBundle("jsqldbaut.dbautproperties.dbaut.Res", LocaleManager.getLocale());
    private Object[] encObj = new Object[]{"Default", "Auto", "UnicodeLittle", "UnicodeBig"};
    private SteppedComboBox encBox = new SteppedComboBox(this.encObj);
    private FilePathField inputFilePathField;
    private File inputFile;
    private FilePathField outputFilePathField;
    private File outputFile;

    public RunBatchDlg(QueryFrame frame, boolean modal) {
        this.inputFilePathField = new FilePathField((Component)this, QueryFrame.frame.px.getBlobFilePath(), this.res2.getString("Open"), false, false, new DbaFileFilter("txt"));
        this.inputFile = null;
        this.outputFilePathField = new FilePathField((Component)this, QueryFrame.frame.px.getBlobFilePath(), this.res.getString("save_as"), false, false, new DbaFileFilter("txt"));
        this.outputFile = null;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUt.showErrorDlg(this, ex.getMessage(), "");
            return;
        }
    }

    void jbInit() throws Exception {
        this.setTitle(this.res.getString("Choose_encoding_of_input_file"));
        HelpButton helpButton = new HelpButton(new Dimension(130, 24));
        JPanel containPane = new JPanel(new BorderLayout(4, 4));
        JLabel label1 = new JLabel(this.res.getString("Please_select_an_input_file"));
        JLabel label2 = new JLabel(this.res.getString("Please_select_an_output_file"));
        JLabel label3 = new JLabel(this.res.getString("Choose_encoding_method"));
        label1.setPreferredSize(new Dimension(200, 24));
        label2.setPreferredSize(new Dimension(200, 24));
        label3.setPreferredSize(new Dimension(200, 24));
        this.encBox.setPreferredSize(new Dimension(150, 25));
        this.encBox.setBorder(BorderFactory.createLoweredBevelBorder());
        this.inputFilePathField.setPreferredSize(new Dimension(250, 25));
        this.inputFilePathField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.outputFilePathField.setPreferredSize(new Dimension(250, 25));
        this.outputFilePathField.setBorder(BorderFactory.createLoweredBevelBorder());
        DbaButton okButton = new DbaButton(new Dimension(130, 24), this.res.getString("Ok"), 'O', DBAImageResource.getResource(this.getClass(), "/jsqldbaut/dbautimages/ok.gif"), new ReflectionAction(this, "okButton_actionPerformed"));
        DbaButton cancelButton = new DbaButton(new Dimension(130, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/jsqldbaut/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButton_actionPerformed"));
        JPanel buttonPane = new JPanel(new FlowLayout(1, 5, 20));
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        buttonPane.add(helpButton);
        JPanel centerPane = new JPanel(new GridLayout(3, 1, 5, 10));
        JPanel pane1 = new JPanel(new FlowLayout(0, 5, 0));
        pane1.add(label1);
        pane1.add(this.inputFilePathField);
        JPanel pane2 = new JPanel(new FlowLayout(0, 5, 0));
        pane2.add(label2);
        pane2.add(this.outputFilePathField);
        JPanel pane3 = new JPanel(new FlowLayout(0, 5, 0));
        pane3.add(label3);
        pane3.add(this.encBox);
        centerPane.add(pane1);
        centerPane.add(pane2);
        centerPane.add(pane3);
        containPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        containPane.add((Component)centerPane, "Center");
        containPane.add((Component)buttonPane, "South");
        this.getContentPane().add(containPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent l) {
                RunBatchDlg.this.cancelButton_actionPerformed(null);
            }
        });
        QueryFrame.frame.enableDialogHelp(this.getRootPane(), helpButton, "RunBatchDlg", null);
    }

    public void okButton_actionPerformed(ActionEvent e) {
        if (this.inputFilePathField.getText().trim().length() <= 0) {
            GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("Please_input_batch_file"));
            return;
        }
        if (this.outputFilePathField.getText().trim().length() <= 0) {
            GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("Please_specify_an_output_file_name"));
            return;
        }
        this.inputFile = new File(this.inputFilePathField.getText());
        this.outputFile = new File(this.outputFilePathField.getText());
        String filterName = this.outputFilePathField.getFileFilter();
        if (filterName != null && filterName.equalsIgnoreCase("*.txt") && this.outputFile.getPath().indexOf(".") < 0) {
            this.outputFile = new File(this.outputFile.getPath() + ".txt");
        }
        String encode = this.encBox.getSelectedItem().toString();
        if (this.inputFile != null) {
            if (!this.inputFile.exists()) {
                String s1 = this.res.getString("file_does_not_exist");
                String s2 = GuiUt.mapStringForProperty(s1, this.inputFile.toString());
                GuiUt.showWarningDlg(this, this.res.getString("Warning"), s2);
                return;
            }
            if (!this.inputFile.canRead()) {
                String s1 = this.res.getString("file_cannot_be_readed");
                String s2 = GuiUt.mapStringForProperty(s1, this.inputFile.toString());
                GuiUt.showWarningDlg(this, this.res.getString("Warning"), s2);
                return;
            }
            if (encode.equalsIgnoreCase("Auto")) {
                try {
                    FileInputStream fs = new FileInputStream(this.inputFile);
                    byte[] b = new byte[2];
                    fs.read(b, 0, 2);
                    Byte b1 = new Byte(b[0]);
                    Byte b2 = new Byte(b[1]);
                    encode = b1.intValue() == -2 && b2.intValue() == -1 ? "UnicodeBig" : (b1.intValue() == -1 && b2.intValue() == -2 ? "UnicodeLittle" : null);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            if (encode == null || encode.equalsIgnoreCase("Default")) {
                encode = null;
            }
        } else {
            GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("Please_input_batch_file"));
            return;
        }
        if (this.outputFile != null && this.outputFile.exists()) {
            String s2;
            String s1;
            if (!this.outputFile.canWrite()) {
                s1 = this.res.getString("file_cannot_be_written");
                s2 = GuiUt.mapStringForProperty(s1, this.outputFile.toString());
                GuiUt.showWarningDlg(this, this.res.getString("Warning"), s2);
                return;
            }
            s1 = this.res.getString("file_cannot_is_existed");
            s2 = GuiUt.mapStringForProperty(s1, this.outputFile.toString());
            int answer = GuiUt.showOptionDlg(this, this.res.getString("Warning"), s2);
            if (answer == 0) {
                this.outputFile.delete();
            } else {
                return;
            }
        }
        QueryFrame.frame.clearQueryPane();
        QueryFrame.frame.clearResultPane();
        QueryFrame.frame.executeBatch(this.inputFile, this.outputFile, encode);
        this.dispose();
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

