/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbatool.DbFrame;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaFileChooser;
import dbaut.comp.DbaTable;
import dbaut.comp.TableColumnSelectionListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.util.JdbcUtil;
import dbmaker.sql.JdbcOdbcBlob;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import queryAnalyzer.AsTableModel;
import queryAnalyzer.DbaFileFilter;
import queryAnalyzer.QueryFrame;
import queryAnalyzer.TableToolBar;
import tableCell.BlobCellObject;

public class AsQueryPane
extends JPanel {
    private static final long serialVersionUID = -6933424279221000621L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    public int[] info = new int[3];
    public boolean[] enable = new boolean[5];
    public String query = null;
    private AsTableModel tableModel = null;
    private DbaTable resultTable = null;
    public ArrayList<String> nameRecord = null;
    public ArrayList<String> dataTypeRecord = null;
    private int[] columnWidth = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private int dataSum = 0;
    private int jump = 0;
    private int counter = 0;
    public static final int pageUP = 0;
    public static final int pageDOWN = 1;
    public static final int pageFIRST = 2;
    public static final int pageLAST = 3;
    private TableToolBar tableToolBar = new TableToolBar(this);

    void TableSelectionChanged(ListSelectionEvent e) {
        int row = this.resultTable.getSelectedRow();
        int col = this.resultTable.getSelectedColumn();
        if (row < 0 || col < 0) {
            return;
        }
        if (row >= this.resultTable.getRowCount() || col >= this.resultTable.getColumnCount()) {
            return;
        }
        Integer rowPosition = new Integer(row + 1 + this.info[2]);
        int temp = 0;
        if (this.info[2] > 0) {
            temp = this.info[0] + 1;
        }
        QueryFrame.frame.setRowField(rowPosition.toString(), temp, this.info[1], this.info[2]);
    }

    public AsQueryPane(Statement stmt, ResultSet rs, Connection conn2, int[] info, boolean[] enable, String query, AsTableModel tableModel, DbaTable resultTable, ArrayList<String> nameRecord, ArrayList<String> dataTypeRecord) {
        this.info = info;
        this.stmt = stmt;
        this.rs = rs;
        this.dataSum = info[1];
        this.jump = info[0];
        this.counter = info[2];
        this.info[0] = 0;
        this.enable = enable;
        this.query = query;
        this.tableModel = tableModel;
        this.resultTable = resultTable;
        this.nameRecord = nameRecord;
        this.dataTypeRecord = dataTypeRecord;
        this.tableToolBar.setToolbarStatus(enable);
        JScrollPane p = new JScrollPane();
        p.getViewport().add(resultTable);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tableToolBar, "North");
        this.add((Component)p, "Center");
        resultTable.setCellSelectionEnabled(true);
        resultTable.addRowSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AsQueryPane.this.TableSelectionChanged(e);
                }
            }
        });
        resultTable.addColumnSelectionListener(new TableColumnSelectionListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AsQueryPane.this.TableSelectionChanged(e);
                }
            }
        });
    }

    public void buttonAction(Integer act) {
        int col;
        int start = this.info[0];
        int end = start + this.jump;
        if (act != null) {
            int action = act;
            switch (action) {
                case 0: {
                    this.counter -= this.jump;
                    if (start - this.jump < 0) {
                        return;
                    }
                    end = (start -= this.jump) + this.jump;
                    break;
                }
                case 1: {
                    this.counter += this.jump;
                    if (start + this.jump > this.dataSum) {
                        return;
                    }
                    end = (start += this.jump) + this.jump;
                    if (end <= this.dataSum) break;
                    end = this.dataSum;
                    break;
                }
                case 2: {
                    this.counter = 0;
                    start = 0;
                    end = start + this.jump;
                    break;
                }
                case 3: {
                    int moduleMax = this.dataSum % this.jump;
                    start = moduleMax == 0 ? this.dataSum - this.jump : this.dataSum - moduleMax;
                    end = this.dataSum;
                    this.counter = start;
                }
            }
            this.info[0] = start;
            this.info[1] = end;
            this.info[2] = this.counter;
        }
        this.executeSql(this.query, this.nameRecord, this.dataTypeRecord, this.tableModel, start, end);
        this.enable[1] = start > 0;
        this.enable[0] = this.enable[1];
        this.enable[3] = end < this.dataSum;
        this.enable[2] = this.enable[3];
        if (this.resultTable.getRowCount() < this.jump) {
            this.enable[3] = false;
            this.enable[2] = false;
        }
        this.enable[4] = true;
        int temp = 0;
        if (this.dataSum > 0) {
            temp = start + 1;
        }
        QueryFrame.frame.setRowField("", temp, end, this.dataSum);
        for (col = 0; col < this.nameRecord.size(); ++col) {
            if (!QueryFrame.frame.isBlobType(this.dataTypeRecord.get(col).toString())) continue;
            QueryFrame.frame.setUpBlobEditor(this.resultTable, this.tableModel, col);
        }
        if (this.columnWidth != null) {
            for (col = 0; col < this.nameRecord.size(); ++col) {
                this.resultTable.getColumnModel().getColumn(col).setPreferredWidth(this.columnWidth[col]);
            }
        }
        this.tableToolBar.setToolbarStatus(this.enable);
    }

    private void executeSql(String sqlStatement, ArrayList<String> nameRecord, ArrayList<String> dataTypeRecord, AsTableModel tableModel, int start, int end) {
        try {
            if (this.rs == null) {
                System.out.println("error,rs is null,this is happend in jsql QueryFrame.java->ExecuteSql.");
                return;
            }
            tableModel.removeAll();
            Blob blob = null;
            int size = nameRecord.size();
            String colType = null;
            Object[] rowData = null;
            int rowNum = 0;
            this.rs.relative(start);
            if (this.dataSum > 0) {
                while (++rowNum <= end - start) {
                    rowData = new Object[size];
                    for (int col = 0; col < size; ++col) {
                        colType = dataTypeRecord.get(col).toString().trim();
                        if (colType.equalsIgnoreCase("long varchar") || colType.equalsIgnoreCase("clob") || colType.equalsIgnoreCase("nclob") || colType.equalsIgnoreCase("long varbinary") || colType.equalsIgnoreCase("blob") || colType.equalsIgnoreCase("file")) {
                            blob = this.rs.getBlob(col + 1);
                            long length = blob.length();
                            if (length != -1L && !this.rs.wasNull()) {
                                rowData[col] = new BlobCellObject(this.rs, rowNum, col + 1, nameRecord.get(col).toString(), dataTypeRecord.get(col).toString(), length, this.rs.wasNull());
                                ((JdbcOdbcBlob)blob).close();
                            }
                            JdbcUtil.free(blob);
                            continue;
                        }
                        rowData[col] = this.rs.getString(col + 1);
                    }
                    tableModel.addValue(rowData);
                    if (this.rs.next()) continue;
                }
            }
            this.rs.first();
            tableModel.fireTableChanged(new TableModelEvent(tableModel));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void closeResultSet() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        DbaObject.close(this.rs);
        DbaObject.close(this.stmt);
    }

    private void saveTableAction(File file) {
        try {
            int i;
            String colType;
            DecimalFormatSymbols dfs;
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            int rowCount = this.tableModel.getRowCount();
            int colCount = this.tableModel.getColumnCount();
            StringBuffer strColName = new StringBuffer();
            String value = null;
            Object obj = null;
            String lineSeparator = System.getProperty("line.separator");
            StringBuffer sb = new StringBuffer();
            char columnDelimiter = ',';
            boolean[] changeDecimalPoint = new boolean[colCount];
            Arrays.fill(changeDecimalPoint, false);
            char decimalPointChar = '.';
            if (DbFrame.conn_DatabaseConnection.db_lcdec != 0 && (decimalPointChar = (char)(dfs = new DecimalFormatSymbols(Locale.getDefault())).getDecimalSeparator()) != '.') {
                colType = null;
                for (i = 0; i < colCount; ++i) {
                    colType = this.dataTypeRecord.get(i).toString().trim();
                    if (colType.compareToIgnoreCase("decimal") != 0) continue;
                    columnDelimiter = ';';
                    changeDecimalPoint[i] = true;
                }
            }
            for (int i2 = 0; i2 < colCount; ++i2) {
                value = this.tableModel.getColumnName(i2);
                strColName.append(value);
                if (i2 + 1 >= colCount) continue;
                strColName.append(columnDelimiter);
            }
            out.write(strColName.toString());
            out.newLine();
            boolean[] addQuote = new boolean[colCount];
            Arrays.fill(addQuote, false);
            colType = null;
            for (i = 0; i < colCount; ++i) {
                colType = this.dataTypeRecord.get(i).toString().trim();
                if (colType.compareToIgnoreCase("char") != 0 && colType.compareToIgnoreCase("varchar") != 0 && colType.compareToIgnoreCase("nchar") != 0 && colType.compareToIgnoreCase("nvarchar") != 0) continue;
                addQuote[i] = true;
            }
            for (i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    value = null;
                    obj = this.tableModel.getValueAt(i, j);
                    if (obj != null) {
                        value = obj.toString();
                        if (changeDecimalPoint[j]) {
                            value = value.replace('.', decimalPointChar);
                        }
                    }
                    if (j != 0) {
                        sb.append(columnDelimiter);
                    }
                    if (addQuote[j]) {
                        sb.append('\"');
                        sb.append(value);
                        sb.append('\"');
                        continue;
                    }
                    sb.append(value);
                }
                sb.append(lineSeparator);
            }
            out.write(sb.toString());
            out.newLine();
            out.flush();
            out.close();
            GuiUt.showInformationDlg(QueryFrame.frame, this.res.getString("Save_table_successful"));
        }
        catch (Exception e) {
            GuiUt.showErrorDlg(QueryFrame.frame, this.res.getString("Save_table_fail"), "");
            e.printStackTrace();
        }
    }

    private void saveAllAction(File file) {
        try {
            int i;
            DecimalFormatSymbols dfs;
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            boolean rc = false;
            String colType = null;
            int size = this.nameRecord.size();
            Blob blob = null;
            long length = 0L;
            String str = null;
            StringBuffer strColName = new StringBuffer();
            int columnDelimiter = 44;
            boolean[] changeDecimalPoint = new boolean[size];
            Arrays.fill(changeDecimalPoint, false);
            char decimalPointChar = '.';
            if (DbFrame.conn_DatabaseConnection.db_lcdec != 0 && (decimalPointChar = (char)(dfs = new DecimalFormatSymbols(Locale.getDefault())).getDecimalSeparator()) != '.') {
                for (i = 0; i < size; ++i) {
                    colType = this.dataTypeRecord.get(i).toString().trim();
                    if (colType.compareToIgnoreCase("decimal") != 0) continue;
                    changeDecimalPoint[i] = true;
                    columnDelimiter = 59;
                }
            }
            for (int i2 = 0; i2 < size; ++i2) {
                String value = this.tableModel.getColumnName(i2);
                strColName.append(value);
                if (i2 + 1 >= size) continue;
                strColName.append((char)columnDelimiter);
            }
            out.write(strColName.toString());
            out.newLine();
            boolean[] addQuote = new boolean[size];
            Arrays.fill(addQuote, false);
            for (i = 0; i < size; ++i) {
                colType = this.dataTypeRecord.get(i).toString().trim();
                if (colType.compareToIgnoreCase("char") != 0 && colType.compareToIgnoreCase("varchar") != 0 && colType.compareToIgnoreCase("nchar") != 0 && colType.compareToIgnoreCase("nvarchar") != 0) continue;
                addQuote[i] = true;
            }
            String lineSeparator = System.getProperty("line.separator");
            this.rs.beforeFirst();
            while (this.rs.next()) {
                for (int col = 0; col < size; ++col) {
                    if (col != 0) {
                        out.write(columnDelimiter);
                    }
                    if ((colType = this.dataTypeRecord.get(col).toString().trim()).equalsIgnoreCase("long varchar") || colType.equalsIgnoreCase("clob") || colType.equalsIgnoreCase("nclob") || colType.equalsIgnoreCase("long varbinary") || colType.equalsIgnoreCase("blob") || colType.equalsIgnoreCase("file")) {
                        blob = this.rs.getBlob(col + 1);
                        if (!this.rs.wasNull()) {
                            length = blob.length();
                            out.write(colType + "(" + length + ")");
                        } else {
                            out.write("null");
                        }
                        JdbcUtil.free(blob);
                        continue;
                    }
                    str = this.rs.getString(col + 1);
                    if (!this.rs.wasNull()) {
                        if (changeDecimalPoint[col]) {
                            str = str.replace('.', decimalPointChar);
                        }
                        if (addQuote[col]) {
                            out.write(34);
                            out.write(str);
                            out.write(34);
                            continue;
                        }
                        out.write(str);
                        continue;
                    }
                    out.write("null");
                }
                out.write(lineSeparator);
            }
            this.rs.beforeFirst();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            GuiUt.showErrorDlg(QueryFrame.frame, this.res.getString("Save_table_fail"), "");
            e.printStackTrace();
        }
    }

    public void table_focusGained(FocusEvent e) {
        Integer rowPosition = new Integer(this.resultTable.getSelectedRow() + 1 + this.info[2]);
        int temp = 0;
        if (this.info[2] > 0) {
            temp = this.info[0] + 1;
        }
        QueryFrame.frame.setRowField(rowPosition.toString(), temp, this.info[1], this.info[2]);
    }

    public void table_focusLosted(FocusEvent ee) {
        QueryFrame.frame.setRowField("", 0, 0, this.info[2]);
    }

    public void table_keyHandle(KeyEvent e) {
        Integer rowPosition = new Integer(this.resultTable.getSelectedRow() + 1 + this.info[2]);
        int temp = 0;
        if (this.info[2] > 0) {
            temp = this.info[0] + 1;
        }
        QueryFrame.frame.setRowField(rowPosition.toString(), temp, this.info[1], this.info[2]);
    }

    public void table_mouseHandle(MouseEvent e) {
        Integer rowPosition = new Integer(this.resultTable.getSelectedRow() + 1 + this.info[2]);
        int temp = 0;
        if (this.info[2] > 0) {
            temp = this.info[0] + 1;
        }
        QueryFrame.frame.setRowField(rowPosition.toString(), temp, this.info[1], this.info[2]);
    }

    public void saveColumnWidth() {
        this.columnWidth = new int[this.nameRecord.size()];
        for (int col = 0; col < this.nameRecord.size(); ++col) {
            this.columnWidth[col] = this.resultTable.getColumnModel().getColumn(col).getWidth();
        }
    }

    public void pageUp_actionPerformed(ActionEvent e) {
        this.buttonAction(0);
    }

    public void pageDown_actionPerformed(ActionEvent e) {
        this.buttonAction(1);
    }

    public void firstPage_actionPerformed(ActionEvent e) {
        this.buttonAction(2);
    }

    public void lastPage_actionPerformed(ActionEvent e) {
        this.buttonAction(3);
    }

    public void saveTable_actionPerformed(ActionEvent e) {
        DbaFileChooser outputFileChooser = new DbaFileChooser(QueryFrame.frame.px.getBlobFilePath());
        outputFileChooser.setFileFilter(new DbaFileFilter("txt"));
        int saveResponse = outputFileChooser.showDialog(QueryFrame.frame, this.res.getString("save_as"));
        if (saveResponse == 0) {
            File file = outputFileChooser.getSelectedFile();
            String filterName = outputFileChooser.getFileFilter().getDescription();
            if (filterName != null && filterName.equalsIgnoreCase("*.txt") && !file.getPath().endsWith(".txt")) {
                String s = file.getPath() + ".txt";
                file = new File(s);
            }
            if (file.exists()) {
                String s1;
                if (!file.canWrite()) {
                    s1 = this.res.getString("file_cannot_be_written");
                    String s2 = GuiUt.mapStringForProperty(s1, file.toString());
                    GuiUt.showWarningDlg(DbFrame.frame, this.res.getString("Warning"), s2);
                    return;
                }
                s1 = this.res.getString("file_cannot_is_existed");
                String s2 = GuiUt.mapStringForProperty(s1, file.toString());
                int answer = GuiUt.showOptionDlg(DbFrame.frame, this.res.getString("Warning"), s2);
                if (answer == 0) {
                    file.delete();
                } else {
                    return;
                }
            }
            this.saveTableAction(file);
        }
    }

    public void saveAll_actionPerformed(ActionEvent e) {
        DbaFileChooser outputFileChooser = new DbaFileChooser(QueryFrame.frame.px.getBlobFilePath());
        outputFileChooser.setFileFilter(new DbaFileFilter("txt"));
        int saveResponse = outputFileChooser.showDialog(QueryFrame.frame, this.res.getString("save_as"));
        if (saveResponse == 0) {
            File file = outputFileChooser.getSelectedFile();
            String filterName = outputFileChooser.getFileFilter().getDescription();
            if (filterName != null && filterName.equalsIgnoreCase("*.txt") && !file.getPath().endsWith(".txt")) {
                String s = file.getPath() + ".txt";
                file = new File(s);
            }
            if (file.exists()) {
                String s1;
                if (!file.canWrite()) {
                    s1 = this.res.getString("file_cannot_be_written");
                    String s2 = GuiUt.mapStringForProperty(s1, file.toString());
                    GuiUt.showWarningDlg(DbFrame.frame, this.res.getString("Warning"), s2);
                    return;
                }
                s1 = this.res.getString("file_cannot_is_existed");
                String s2 = GuiUt.mapStringForProperty(s1, file.toString());
                int answer = GuiUt.showOptionDlg(DbFrame.frame, this.res.getString("Warning"), s2);
                if (answer == 0) {
                    file.delete();
                } else {
                    return;
                }
            }
            this.saveAllAction(file);
        }
    }
}

