/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import com.syscom.dm.monitor.sca.DefaultMonitorAuthority;
import dbaut.JdmConfig;
import dbaut.VersionManager;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.locale.LocaleManager;
import dbaut.preference.CorePreferences;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.textField.CharPasswordField;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import monitor.DatabaseConnection;
import monitor.HelpButton;
import monitor.MonitorFrame;

public class LoginDlg
extends JDialog {
    private String selectedDBName = null;
    private String loginUserName = "SYSADM";
    private String password = "";
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", LocaleManager.getLocale());
    private static String localHostName = "";
    private static String localIpAddress = "";
    private SteppedComboBox Database_Name = new SteppedComboBox();
    private CharField User_Name_Field = new CharField(128, true);
    private CharPasswordField Password_Field = new CharPasswordField(16, true);
    private DbaButton OK_Button = new DbaButton(this.res.getString("OK"), 'O', new ReflectionAction(this, "OK_Button_actionPerformed"));
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private JCheckBox SaveUserPw_Checkbox = new JCheckBox("Save username and password");
    private CorePreferences cp = null;

    public LoginDlg(Frame frame, String title, boolean modal) {
        super(frame, title, true);
        this.setLocationRelativeTo(frame);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LoginDlg(Frame frame) {
        super(frame);
        this.setModal(true);
        this.setLocationRelativeTo(frame);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton Cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        HelpButton Help_Button = new HelpButton();
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.OK_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        Cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        this.setTitle(this.res.getString("Login"));
        MonitorFrame.frame.enableHelpAction(this.getRootPane(), Help_Button, "monitor_login", null);
        jPanel5.setLayout(new GridLayout(4, 1, 5, 5));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.res.getString("Database_name"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.res.getString("User_name"));
        this.jLabel3.setToolTipText("");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.res.getString("Password"));
        jPanel6.setLayout(new GridLayout(4, 1, 5, 5));
        Vector<String> dataSource = JdmConfig.getDatabaseNames("dmconfig.ini", false);
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>(dataSource);
        this.Database_Name.setModel((ComboBoxModel)comboModel);
        this.Database_Name.setMinimumSize(new Dimension(160, 28));
        this.Database_Name.setPreferredSize(new Dimension(160, 28));
        this.Database_Name.setMaximumRowCount(6);
        this.Database_Name.addActionListener(new ReflectionAction(this, "Database_Name_actionPerformed"));
        this.User_Name_Field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    LoginDlg.this.User_Name_Field_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                LoginDlg.this.User_Name_Field_keyReleased(e);
            }
        });
        this.Password_Field.setPreferredSize(new Dimension(160, 22));
        this.Password_Field.setMinimumSize(new Dimension(160, 22));
        this.Password_Field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    LoginDlg.this.Password_Field_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                LoginDlg.this.Password_Field_keyReleased(e);
            }
        });
        jPanel7.setLayout(new GridLayout(4, 1, 1, 1));
        jPanel8.setLayout(new BorderLayout(10, 10));
        jPanel2.setBackground(Color.darkGray);
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel2.setMinimumSize(new Dimension(2, 2));
        jPanel2.setPreferredSize(new Dimension(2, 2));
        jLabel4.setIcon(DBAImageResource.getResource(this.getClass(), "/monitorimages/monitors.gif"));
        jLabel5.setHorizontalAlignment(0);
        jLabel5.setHorizontalTextPosition(0);
        jLabel5.setText(this.res.getString("c_2001_CASEMaker") + VersionManager.getBuildYear() + " " + VersionManager.getCompanyName() + this.res.getString("c_2001_CASEMaker2"));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.User_Name_Field.setPreferredSize(new Dimension(160, 28));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel4.add((Component)jPanel5, "West");
        jPanel4.add((Component)jPanel6, "Center");
        jPanel4.add((Component)jPanel7, "East");
        jPanel5.add((Component)this.jLabel1, null);
        jPanel5.add((Component)this.jLabel2, null);
        jPanel5.add((Component)this.jLabel3, null);
        jPanel6.add((Component)this.Database_Name, null);
        jPanel6.add((Component)this.User_Name_Field, null);
        jPanel6.add((Component)this.Password_Field, null);
        jPanel6.add((Component)this.SaveUserPw_Checkbox, null);
        jPanel7.add((Component)this.OK_Button, null);
        jPanel7.add((Component)Cancel_Button, null);
        jPanel7.add((Component)Help_Button, null);
        jPanel3.add((Component)jPanel4, "Center");
        jPanel3.add((Component)jPanel8, "South");
        jPanel8.add((Component)jPanel2, "North");
        jPanel8.add((Component)jLabel4, "West");
        jPanel8.add((Component)jLabel5, "Center");
        this.getContentPane().add(jPanel3);
        if (this.Database_Name.getItemCount() == 0) {
            return;
        }
        this.cp = MonitorFrame.frame.px;
        String previouslogindb = this.cp.getLoginDbName();
        if (previouslogindb != null || previouslogindb.length() > 0) {
            this.Database_Name.setSelectedItem(previouslogindb);
            this.Database_Name_actionPerformed(null);
        } else {
            this.Database_Name.setSelectedIndex(0);
        }
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.OK_Button.requestFocus();
        }
    }

    public void OK_Button_actionPerformed(ActionEvent e) {
        DatabaseConnection conn;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.selectedDBName = this.Database_Name.getSelectedItem().toString().trim();
        this.loginUserName = this.User_Name_Field.getText();
        this.password = new String(this.Password_Field.getPassword());
        if (MonitorFrame.frame.conn_DatabaseConnection != null) {
            MonitorFrame.frame.conn_DatabaseConnection.disconnect();
            MonitorFrame.frame.conn_DatabaseConnection = null;
        }
        if ((conn = new DatabaseConnection(this.selectedDBName, this.loginUserName, this.password, this)).getConnection() == null) {
            return;
        }
        DefaultMonitorAuthority authority = new DefaultMonitorAuthority(conn);
        if (!authority.isAboveDba()) {
            authority.errorIsNotDBA(this);
            conn.disconnect();
            return;
        }
        MonitorFrame.frame.conn_DatabaseConnection = conn;
        this.cp.setLoginDbName(this.selectedDBName);
        if (this.SaveUserPw_Checkbox.isSelected()) {
            this.cp.setLoginIdName(this.loginUserName);
            this.cp.setLoginPassword(this.password);
        } else {
            this.cp.setLoginIdName(null);
            this.cp.setLoginPassword(null);
        }
        if (conn.isIDCAP()) {
            this.loginUserName = this.loginUserName.toUpperCase();
        }
        try {
            this.cp.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.setVisible(false);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        MonitorFrame.frame.isConnect = MonitorFrame.frame.conn_DatabaseConnection != null;
        this.setVisible(false);
    }

    public void Database_Name_actionPerformed(ActionEvent e) {
        String databaseName = this.Database_Name.getSelectedItem().toString();
        this.User_Name_Field.setText("");
        this.Password_Field.setText("");
        this.SaveUserPw_Checkbox.setSelected(false);
        String username = "";
        String password = "";
        if (databaseName.equalsIgnoreCase(this.cp.getLoginDbName()) && this.cp.getLoginIdName() != null && this.cp.getLoginIdName().length() > 0) {
            username = this.cp.getLoginIdName();
            password = this.cp.getLoginPassword();
            this.SaveUserPw_Checkbox.setSelected(true);
        }
        if (username != null && username.length() > 0) {
            this.User_Name_Field.setText(username);
        }
        if (password != null && password.length() > 0) {
            this.Password_Field.setText(password);
        }
    }

    private void User_Name_Field_keyReleased(KeyEvent e) {
        if (this.User_Name_Field.getText().length() > 0) {
            this.OK_Button.setEnabled(true);
            if (e.getKeyCode() == 10) {
                this.OK_Button_actionPerformed(null);
            }
        } else {
            this.OK_Button.setEnabled(false);
        }
    }

    private void Password_Field_keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.User_Name_Field.getText().length() > 0) {
            this.OK_Button_actionPerformed(null);
        }
    }
}

