/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import monitor.DataObject;
import monitor.DataSet;
import monitor.MonitorFrame;

public class ChartPanel
extends JPanel {
    private DataSet dataset = null;
    private Stroke normalstroke = null;

    public ChartPanel(DataSet dataset) {
        this.dataset = dataset;
        this.setBackground(dataset.background);
        this.setBorder(BorderFactory.createLineBorder(Color.darkGray, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChartPanel.this.this_mouseClicked(e);
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        this.setBackground(this.dataset.background);
        Insets insets = this.getInsets();
        int currentWidth = this.getWidth() - insets.left - insets.right;
        int currentHeight = this.getHeight() - insets.top - insets.bottom + 2;
        Graphics2D g2 = (Graphics2D)g;
        if (this.normalstroke == null) {
            this.normalstroke = g2.getStroke();
        }
        g2.setColor(this.dataset.gridline);
        int w = (this.dataset.rangehi - this.dataset.rangelow) / 10;
        int offset = currentHeight / 11;
        g2.setColor(this.dataset.gridline);
        for (i = currentHeight; i > 0; i -= offset) {
            g2.drawLine(insets.left, i, currentWidth + insets.left, i);
        }
        for (i = currentWidth; i > 0; i -= this.dataset.gridwidth) {
            g2.drawLine(i, insets.top, i, currentHeight + insets.bottom);
        }
        int size = this.dataset.getItemCount();
        int ar_size = 0;
        int count = 0;
        DataObject obj = null;
        long[] array = null;
        double pos_y1 = 0.0;
        double pos_y2 = 0.0;
        int h = offset * 10;
        int b = this.dataset.rangehi - this.dataset.rangelow;
        int b2 = currentHeight + insets.bottom;
        for (count = 0; count < size; ++count) {
            obj = this.dataset.getItem(count);
            array = obj.t;
            ar_size = array.length;
            g2.setColor(obj.color);
            g2.setStroke(new BasicStroke(obj.linewidth, 1, 1));
            int j = ar_size - 1;
            for (int i2 = currentWidth; i2 > 0 && j > 0; --j, i2 -= this.dataset.gridwidth) {
                pos_y1 = (double)b2 - (double)array[j] * obj.proportion.d * (double)h / (double)b;
                pos_y2 = (double)b2 - (double)array[j - 1] * obj.proportion.d * (double)h / (double)b;
                if (pos_y1 < 0.0 && pos_y2 < 0.0) {
                    pos_y1 = insets.top;
                    pos_y2 = insets.top;
                } else if (pos_y1 > (double)currentHeight && pos_y2 > (double)currentHeight) {
                    pos_y1 = currentHeight;
                    pos_y2 = currentHeight;
                }
                g2.drawLine(i2, (int)pos_y1, i2 - this.dataset.gridwidth, (int)pos_y2);
            }
        }
        if (this.dataset.gridline.equals(Color.green) || this.dataset.gridline.equals(new Color(54, 133, 54))) {
            g2.setColor(Color.white);
        } else {
            g2.setColor(Color.green);
        }
        g2.drawLine(currentWidth - this.dataset.linepos * this.dataset.gridwidth, insets.top, currentWidth - this.dataset.linepos * this.dataset.gridwidth, currentHeight + insets.bottom);
        if (this.normalstroke != null) {
            g2.setStroke(this.normalstroke);
        }
    }

    void this_mouseClicked(MouseEvent e) {
        if (this.dataset.getItemCount() > 0) {
            int xPos = e.getX();
            Insets insets = this.getInsets();
            int currentWidth = this.getWidth() - insets.left - insets.right;
            int i = (currentWidth - xPos) % this.dataset.gridwidth;
            int j = (currentWidth - xPos) / this.dataset.gridwidth;
            if (i >= 5) {
                ++j;
            }
            this.dataset.linepos = j;
            MonitorFrame.frame.repaint();
        }
    }
}

