/*
 * Decompiled with CFR 0.152.
 */
package jsql2.dialogs;

import dbaut.JdmConfig;
import framework.PreferencesXmlManager;
import java.awt.Frame;
import java.util.Vector;
import junit.framework.Assert;
import org.fest.swing.fixture.DialogFixture;
import org.fest.swing.fixture.FrameFixture;
import org.fest.swing.fixture.JMenuItemFixture;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import ui.ConnectionStatus;
import ui.gui.JsqlGUI;

public class TesLoginDialog {
    private FrameFixture frame = null;
    private JsqlGUI gui = null;

    @Before
    public void setUp() {
        this.gui = new JsqlGUI();
        this.frame = new FrameFixture((Frame)this.gui.getFrame());
    }

    @Test
    public void testDatabaseComboBox() {
        JMenuItemFixture menuItem = this.frame.menuItem("DatabaseConnectMenuItem");
        menuItem.click();
        DialogFixture dialog = this.frame.dialog("LoginDialog");
        dialog.requireVisible();
        Vector<String> names = JdmConfig.getDatabaseNames("dmconfig.ini", false);
        Object[] dbNames = names.toArray();
        String[] items = dialog.comboBox("DatabaseNameComboBox").contents();
        Assert.assertEquals((int)dbNames.length, (int)items.length);
        for (int i = 0; i < items.length; ++i) {
            Assert.assertEquals((String)items[i], (String)((String)dbNames[i]));
        }
        dialog.button("CancelButton").click();
    }

    @Test
    public void testUserNameField() {
        JMenuItemFixture menuItem = this.frame.menuItem("DatabaseConnectMenuItem");
        menuItem.click();
        DialogFixture dialog = this.frame.dialog("LoginDialog");
        dialog.requireVisible();
        String userName = JdmConfig.getUserId("TESTDB");
        String userName1 = dialog.textBox("UserNameField").text();
        Assert.assertEquals((String)userName.toUpperCase(), (String)userName1.toUpperCase());
        dialog.button("CancelButton").click();
    }

    @Test
    public void testSaveUserName() {
        JMenuItemFixture menuItem = this.frame.menuItem("DatabaseConnectMenuItem");
        menuItem.click();
        DialogFixture dialog = this.frame.dialog("LoginDialog");
        dialog.requireVisible();
        dialog.comboBox("DatabaseNameComboBox").selectItem("TESTDB");
        dialog.textBox("UserNameField").setText("SYSADM");
        dialog.textBox("PasswordField").setText("");
        String userNameInput = dialog.textBox("UserNameField").text();
        dialog.checkBox("SaveUserNameCheckBox").check();
        dialog.button("LoginButton").click();
        String userNameConfig = JdmConfig.getUserId("TESTDB");
        Assert.assertEquals((String)userNameInput, (String)userNameConfig);
    }

    @Test
    public void testOKButton() {
        JMenuItemFixture menuItem = this.frame.menuItem("DatabaseConnectMenuItem");
        menuItem.click();
        DialogFixture dialog = this.frame.dialog("LoginDialog");
        dialog.requireVisible();
        dialog.comboBox("DatabaseNameComboBox").selectItem("TESTDB");
        dialog.textBox("UserNameField").setText("SYSADM");
        dialog.textBox("PasswordField").setText("");
        dialog.button("LoginButton").click();
        ConnectionStatus cs = this.gui.getCurrentConnectionStatus();
        boolean isConnected = cs.isConnected();
        Assert.assertEquals((boolean)true, (boolean)isConnected);
    }

    @Test
    public void testCancelButton() {
        JMenuItemFixture menuItem = this.frame.menuItem("DatabaseConnectMenuItem");
        menuItem.click();
        DialogFixture dialog = this.frame.dialog("LoginDialog");
        dialog.requireVisible();
        dialog.button("CancelButton").click();
        this.frame.requireVisible();
    }

    @After
    public void tearDown() {
        this.frame.cleanUp();
        PreferencesXmlManager.cleanPreferencesXmlFile();
    }
}

