/*
 * Decompiled with CFR 0.152.
 */
package framework.data;

import framework.DatabaseConnector;
import framework.SystemUt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class TableManager {
    private static final String fileName = "testfile";

    public static void createTable(String dbName, String sql) throws SQLException {
        Connection con = DatabaseConnector.connectDatabase(dbName);
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        DatabaseConnector.disconnectDatabase(con);
    }

    public static void insertDataToTable(String dbName, String sql) throws SQLException {
        Connection con = DatabaseConnector.connectDatabase(dbName);
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        DatabaseConnector.disconnectDatabase(con);
    }

    public static void insertRepDataToTable(String dbName, String sql, int times) throws SQLException {
        Connection con = DatabaseConnector.connectDatabase(dbName);
        Statement stmt = con.createStatement();
        for (int i = 0; i < times; ++i) {
            stmt.executeUpdate(sql);
        }
        stmt.close();
        DatabaseConnector.disconnectDatabase(con);
    }

    public static void insertRepFileDataToTable(String dbName, String sql, int times) throws SQLException, IOException {
        String dataHome = SystemUt.getDataHome();
        String filePath = dataHome + SystemUt.getFileSeparator() + fileName;
        Connection con = DatabaseConnector.connectDatabase(dbName);
        PreparedStatement pstmt = con.prepareStatement(sql);
        for (int i = 0; i < times; ++i) {
            File f = new File(filePath);
            FileInputStream fis = new FileInputStream(f);
            pstmt.setBinaryStream(1, (InputStream)fis, fis.available());
            pstmt.executeUpdate();
        }
        pstmt.close();
        DatabaseConnector.disconnectDatabase(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInsertRepFileContents() {
        String contents = "";
        String dataHome = SystemUt.getDataHome();
        String filePath = dataHome + SystemUt.getFileSeparator() + fileName;
        File f = new File(filePath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            int len = fis.available();
            byte[] buf = new byte[len];
            fis.read(buf);
            contents = new String(buf);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            contents = "";
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            contents = "";
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    contents = "";
                }
            }
        }
        return contents.trim();
    }

    public static void dropTable(String dbName, String sql) throws SQLException {
        Connection con = DatabaseConnector.connectDatabase(dbName);
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        DatabaseConnector.disconnectDatabase(con);
    }
}

