/*
 * Decompiled with CFR 0.152.
 */
package framework;

import dbaut.locale.LocaleManager;

public class SystemUt {
    public static final int INTERVAL = 0;
    private static String testHome = null;

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Win");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static void setTestDBHome(String home) {
        testHome = home;
    }

    public static String getTestDBHome() {
        if (testHome == null || testHome.length() < 1) {
            testHome = System.getenv("TEST_DB_DIR");
        }
        System.out.println("Test home: " + testHome);
        return testHome;
    }

    public static String getSqlEnv() {
        String sqlenv = System.getenv("sqlenv");
        System.out.println("sqlenv: " + sqlenv);
        return sqlenv;
    }

    public static String getRegHome() {
        String regHome = System.getenv("REG_HOME");
        System.out.println("Reg Home: " + regHome);
        return regHome;
    }

    public static String getDataHome() {
        String regHome = SystemUt.getRegHome();
        String dataHome = regHome + SystemUt.getFileSeparator() + "data";
        System.out.println("Data Home: " + dataHome);
        return dataHome;
    }

    public static boolean isDBMaker() {
        return LocaleManager.getIsDBMaker();
    }

    public static String getProductName() {
        if (SystemUt.isDBMaker()) {
            return "DBMaker";
        }
        return "DBMaster";
    }

    public static void sleep(int second) {
        try {
            Thread.sleep(1000 * second);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void delay(int second) {
        if (second > 0) {
            try {
                Thread.sleep(1000 * second);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean getIsTestJdba() {
        String testDBHome = SystemUt.getTestDBHome();
        return testDBHome.indexOf("testjdba") != -1;
    }
}

