/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importText;

import datatransfer.DataTransferFrame;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.SteppedComboBox;
import dttwizard.importJson.ImJsonDialog;
import dttwizard.importODBC.odbcDialog;
import dttwizard.importText.ImTextDialog;
import dttwizard.importXML.ImXmlDialog;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;

public class SchemaTypes
extends SteppedComboBox {
    private static final long serialVersionUID = 3245396918600529407L;
    private JDialog dlg = null;

    public SchemaTypes(JDialog dlg) {
        this.dlg = dlg;
        Vector<String> v = SchemaTypes.getBasicTypes();
        v.addAll(this.getDomainTypes());
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>(v);
        this.setModel((ComboBoxModel)cbm);
    }

    public static Vector<String> getBasicTypes() {
        Vector<String> v = new Vector<String>(16);
        v.add("binary");
        v.add("blob");
        v.add("char");
        v.add("clob");
        v.add("date");
        v.add("decimal");
        v.add("double");
        v.add("file");
        v.add("real");
        v.add("integer");
        v.add("bigint");
        v.add("long varbinary");
        v.add("long varchar");
        v.add("nchar");
        v.add("nclob");
        v.add("nvarchar");
        v.add("oid");
        v.add("serial");
        v.add("bigserial");
        v.add("smallint");
        v.add("time");
        v.add("timestamp");
        v.add("varchar");
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<String> getDomainTypes() {
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> v = new Vector<String>();
        try {
            stmt = this.dlg instanceof ImTextDialog ? ((ImTextDialog)this.dlg).connection.getDbConnection().createStatement() : (this.dlg instanceof ImXmlDialog ? ((ImXmlDialog)this.dlg).connection.getDbConnection().createStatement() : (this.dlg instanceof ImJsonDialog ? ((ImJsonDialog)this.dlg).connection.getDbConnection().createStatement() : ((odbcDialog)this.dlg).destinationConnection.getDbConnection().createStatement()));
            String query = "select DOMAIN_NAME from SYSTEM.SYSDOMAIN  order by DOMAIN_OWNER, DOMAIN_NAME ";
            rs = stmt.executeQuery(query);
            String name = "";
            while (rs.next()) {
                name = rs.getString(1);
                v.add(name.trim());
            }
        }
        catch (SQLException sqle) {
            try {
                GuiUt.showSQLException(this.dlg, null, sqle);
            }
            catch (Throwable throwable) {
                DbaObject.close(rs);
                DbaObject.close(stmt);
                throw throwable;
            }
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
        return v;
    }

    public static boolean isDomainType(String type) {
        return !type.equalsIgnoreCase("BINARY") && !type.equalsIgnoreCase("CHAR") && !type.equalsIgnoreCase("DATE") && !type.equalsIgnoreCase("DECIMAL") && !type.equalsIgnoreCase("DOUBLE") && !type.equalsIgnoreCase("FILE") && !type.equalsIgnoreCase("REAL") && !type.equalsIgnoreCase("CHAR") && !type.equalsIgnoreCase("INTEGER") && !type.equalsIgnoreCase("BIGINT") && !type.equalsIgnoreCase("FLOAT") && !type.equalsIgnoreCase("LONG VARBINARY") && !type.equalsIgnoreCase("LONG VARCHAR") && !type.equalsIgnoreCase("OID") && !type.equalsIgnoreCase("SERIAL") && !type.equalsIgnoreCase("BIGSERIAL") && !type.equalsIgnoreCase("SMALLINT") && !type.equalsIgnoreCase("TIME") && !type.equalsIgnoreCase("TIMESTAMP") && !type.equalsIgnoreCase("VARCHAR") && !type.equalsIgnoreCase("NCLOB") && !type.equalsIgnoreCase("NCHAR") && !type.equalsIgnoreCase("NVARCHAR") && !type.equalsIgnoreCase("CLOB") && !type.equalsIgnoreCase("BLOB");
    }

    public static boolean isBlobType(String type) {
        return type.equalsIgnoreCase("LONG VARBINARY") || type.equalsIgnoreCase("LONG VARCHAR") || type.equalsIgnoreCase("FILE") || type.equalsIgnoreCase("NCLOB") || type.equalsIgnoreCase("CLOB") || type.equalsIgnoreCase("BLOB");
    }

    public String getDomainType(String type) {
        if (!SchemaTypes.isDomainType(type)) {
            return type;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.dlg instanceof ImTextDialog ? ((ImTextDialog)this.dlg).connection.getDbConnection().createStatement() : ((ImXmlDialog)this.dlg).connection.getDbConnection().createStatement();
            String query = "select TYPE_NAME from SYSTEM.SYSDOMAIN  where DOMAIN_NAME = '" + type + "'";
            rs = stmt.executeQuery(query);
            String type_name = "";
            while (rs.next()) {
                type_name = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return type_name;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DataTransferFrame.frame, null, sqle);
            return type;
        }
    }

    public boolean isCharType(String type) {
        if (type.equalsIgnoreCase("CHAR") || type.equalsIgnoreCase("VARCHAR") || type.equalsIgnoreCase("LONG VARBINARY") || type.equalsIgnoreCase("LONG VARCHAR") || type.equalsIgnoreCase("NCHAR") || type.equalsIgnoreCase("NVARCHAR") || type.equalsIgnoreCase("NCLOB") || type.equalsIgnoreCase("CLOB") || type.equalsIgnoreCase("BLOB")) {
            return true;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.dlg instanceof ImTextDialog ? ((ImTextDialog)this.dlg).connection.getDbConnection().createStatement() : ((ImXmlDialog)this.dlg).connection.getDbConnection().createStatement();
            String query = "select TYPE_NAME from SYSTEM.SYSDOMAIN  where DOMAIN_NAME = '" + type + "'";
            rs = stmt.executeQuery(query);
            String type_name = "";
            while (rs.next()) {
                type_name = rs.getString(1);
                type_name = type_name.trim();
            }
            rs.close();
            stmt.close();
            return type_name.equalsIgnoreCase("CHAR") || type_name.equalsIgnoreCase("VARCHAR") || type_name.equalsIgnoreCase("LONG VARBINARY") || type_name.equalsIgnoreCase("LONG VARCHAR") || type_name.equalsIgnoreCase("NCHAR") || type_name.equalsIgnoreCase("NVARCHAR") || type_name.equalsIgnoreCase("NCLOB") || type_name.equalsIgnoreCase("CLOB") || type_name.equalsIgnoreCase("BLOB");
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this.dlg, null, sqle);
            return false;
        }
    }

    public boolean isNumberType(String type) {
        if (type.equalsIgnoreCase("DECIMAL") || type.equalsIgnoreCase("DOUBLE") || type.equalsIgnoreCase("REAL") || type.equalsIgnoreCase("INTEGER") || type.equalsIgnoreCase("SERIAL") || type.equalsIgnoreCase("BIGSERIAL") || type.equalsIgnoreCase("SMALLINT") || type.equalsIgnoreCase("BIGINT")) {
            return true;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.dlg instanceof ImTextDialog ? ((ImTextDialog)this.dlg).connection.getDbConnection().createStatement() : ((ImXmlDialog)this.dlg).connection.getDbConnection().createStatement();
            String query = "select TYPE_NAME from SYSTEM.SYSDOMAIN  where DOMAIN_NAME = '" + type + "'";
            rs = stmt.executeQuery(query);
            String type_name = "";
            while (rs.next()) {
                type_name = rs.getString(1);
                type_name = type_name.trim();
            }
            rs.close();
            stmt.close();
            return type.equalsIgnoreCase("DECIMAL") || type.equalsIgnoreCase("DOUBLE") || type.equalsIgnoreCase("REAL") || type.equalsIgnoreCase("INTEGER") || type.equalsIgnoreCase("SERIAL") || type.equalsIgnoreCase("BIGSERIAL") || type.equalsIgnoreCase("SMALLINT") || type.equalsIgnoreCase("BIGINT");
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this.dlg, null, sqle);
            return false;
        }
    }
}

