/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import com.borland.jbcl.layout.VerticalFlowLayout;
import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import datatransfer.XmlFile;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaFileFilter;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.FilePathField;
import dttwizard.importODBC.SourceTableView;
import dttwizard.importODBC.SqlQueryStatement;
import dttwizard.importODBC.odbcDialog;
import dttwizard.importXML.XmlElement;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CopyQuery
extends AbstractWizardPanel {
    private static final long serialVersionUID = -4044234179579251676L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_tablequery");
    private odbcDialog odbcdlg = null;
    private AbstractWizardPanel previous = null;
    private AbstractWizardPanel next1 = null;
    private AbstractWizardPanel next2 = null;
    private AbstractWizardPanel next3 = null;
    private JRadioButton tableCopy_RadioButton = new JRadioButton(this.res.getString("Table"), true);
    private JRadioButton sqlQuery_RadioButton = new JRadioButton(this.res.getString("SQL_query"));
    private JRadioButton loadBatch_RadioButton = new JRadioButton(this.res.getString("Batch_file"));
    private FilePathField loadBatch_FilePathField = null;

    public CopyQuery(odbcDialog odbcdlg, AbstractWizardPanel previous) {
        try {
            this.odbcdlg = odbcdlg;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        DbaButton next_Button = new DbaButton(this.res.getString("Next"), 'N', new ReflectionAction(this, "next_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel panel7 = new JPanel();
        JPanel panel10 = new JPanel(new FlowLayout(0));
        JPanel panel11 = new JPanel(new FlowLayout(0));
        JPanel panel12 = new JPanel(new FlowLayout(0));
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Specify_whether_you"));
        JLabel jlabel3 = new JLabel(this.res.getString("Copy_from"));
        ButtonGroup group = new ButtonGroup();
        this.loadBatch_FilePathField = new FilePathField(this.odbcdlg, true);
        this.loadBatch_FilePathField = new FilePathField((Component)this.odbcdlg, false, new DbaFileFilter("xml", "XML Files (*.xml)"));
        next_Button.setHorizontalTextPosition(2);
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"));
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        panel7.setPreferredSize(new Dimension(80, 0));
        panel7.setBorder(null);
        group.add(this.tableCopy_RadioButton);
        group.add(this.sqlQuery_RadioButton);
        group.add(this.loadBatch_RadioButton);
        this.loadBatch_FilePathField.setPreferredSize(new Dimension(350, 24));
        this.loadBatch_FilePathField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tableCopy_RadioButton.addActionListener(new ReflectionAction(this, "tableCopy_RadioButton_actionPerformed"));
        this.sqlQuery_RadioButton.addActionListener(new ReflectionAction(this, "sqlQuery_RadioButton_actionPerformed"));
        this.loadBatch_RadioButton.addActionListener(new ReflectionAction(this, "loadBatch_RadioButton_actionPerformed"));
        panel4.add(back_Button);
        panel4.add(next_Button);
        panel4.add(panel7);
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        panel10.add(this.loadBatch_RadioButton);
        panel10.add(this.loadBatch_FilePathField);
        panel11.add(this.tableCopy_RadioButton);
        panel12.add(this.sqlQuery_RadioButton);
        panel6.add(jlabel3);
        panel6.add(panel11);
        panel6.add(panel12);
        panel6.add(panel10);
        panel6.add(panel10);
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportODBC.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_CopyQuery", null);
        this.loadBatch_FilePathField.setEnabled(false);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.odbcdlg.flowType == 0 && !this.tableCopy_RadioButton.isSelected()) {
            this.next1 = null;
        }
        if (this.odbcdlg.flowType == 1 && !this.sqlQuery_RadioButton.isSelected()) {
            this.next2 = null;
        }
        if (this.odbcdlg.flowType == 2 && !this.loadBatch_RadioButton.isSelected()) {
            this.next3 = null;
        }
        if (this.tableCopy_RadioButton.isSelected()) {
            if (this.next1 == null) {
                this.next1 = new SourceTableView(this.odbcdlg, this, false);
            }
            this.odbcdlg.flowType = 0;
            this.odbcdlg.Next(this.next1);
        } else if (this.sqlQuery_RadioButton.isSelected()) {
            if (this.next2 == null) {
                this.next2 = new SqlQueryStatement(this.odbcdlg, this, false);
            }
            this.odbcdlg.flowType = 1;
            this.odbcdlg.Next(this.next2);
        } else {
            if (GuiUt.isWindows()) {
                if (!this.loadBatch_FilePathField.getText().trim().equalsIgnoreCase(this.odbcdlg.batchFileName)) {
                    this.next3 = null;
                } else if (!this.loadBatch_FilePathField.getText().trim().equals(this.odbcdlg.batchFileName)) {
                    this.next3 = null;
                }
            }
            if (this.next3 == null) {
                String fileName = this.loadBatch_FilePathField.getText().trim();
                String ss = null;
                if (fileName.length() <= 4) {
                    GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("ErrMsg_Please_select_a_xmlfile"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                ss = fileName.substring(fileName.length() - 4, fileName.length());
                if (!ss.equalsIgnoreCase(".xml")) {
                    GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("ErrMsg_Please_select_a_xmlfile"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                File f = new File(fileName);
                if (!f.exists()) {
                    GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("Mesasge_File") + " " + fileName + " " + this.res.getString("Message_does_not_exist"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                boolean type = false;
                this.odbcdlg.xmlFile = new XmlFile(this.loadBatch_FilePathField.getText().trim());
                int rc = this.odbcdlg.xmlFile.getFileContent();
                if (rc == 0) {
                    String xmlStyle = this.odbcdlg.xmlFile.root.getAttributeValue("STYLE");
                    if (xmlStyle == null || !xmlStyle.equalsIgnoreCase("IMPORT_ODBC")) {
                        GuiUt.showErrorDlg(this.odbcdlg, this.res.getString("Message_xml_file") + " " + this.loadBatch_FilePathField.getText().trim() + " " + this.res.getString("Message_has_abnormal_style_format"), null);
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    XmlElement element = this.odbcdlg.xmlFile.root.searchElement("TRANSFER_SETTING");
                    if (element == null) {
                        GuiUt.showErrorDlg(this.odbcdlg, this.res.getString("Message_xml_file") + " " + this.loadBatch_FilePathField.getText().trim() + " " + this.res.getString("Message_cannot_get_transfer_setting_tab_name"), null);
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    String xmlType = element.getAttributeValue("TYPE");
                    if (xmlType == null || !xmlType.equalsIgnoreCase("TABLE_TYPE") && !xmlType.equalsIgnoreCase("QUERY_TYPE") && !xmlType.equalsIgnoreCase("BATCH_TYPE")) {
                        GuiUt.showErrorDlg(this.odbcdlg, this.res.getString("Message_xml_file") + " " + this.loadBatch_FilePathField.getText().trim() + " " + this.res.getString("Message_has_abnormal_type_format"), null);
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    if (xmlType.equalsIgnoreCase("TABLE_TYPE")) {
                        type = false;
                    } else if (xmlType.equalsIgnoreCase("QUERY_TYPE")) {
                        type = true;
                    }
                } else {
                    GuiUt.showErrorDlg(this.odbcdlg, this.res.getString("Message_Xml_parser_cannot_parse") + " " + this.loadBatch_FilePathField.getText().trim() + "." + this.res.getString("Message_please_check_your_xml_file"), null);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                this.odbcdlg.isLoadSuccess = true;
                if (!type) {
                    this.next3 = new SourceTableView(this.odbcdlg, this, true);
                } else if (type) {
                    this.next3 = new SqlQueryStatement(this.odbcdlg, this, true);
                }
            }
            this.odbcdlg.flowType = 2;
            this.odbcdlg.batchFileName = this.loadBatch_FilePathField.getText().trim();
            if (this.odbcdlg.isLoadSuccess) {
                this.odbcdlg.Next(this.next3);
            } else {
                this.next3 = null;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.dispose();
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.Next(this.previous);
    }

    public void loadBatch_RadioButton_actionPerformed(ActionEvent e) {
        this.loadBatch_FilePathField.setEnabled(true);
    }

    public void tableCopy_RadioButton_actionPerformed(ActionEvent e) {
        this.loadBatch_FilePathField.setEnabled(false);
    }

    public void sqlQuery_RadioButton_actionPerformed(ActionEvent e) {
        this.loadBatch_FilePathField.setEnabled(false);
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

