/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import com.borland.jbcl.layout.VerticalFlowLayout;
import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import datatransfer.PreferencesXml;
import dbaut.ComboEditorField;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.DetailDialog;
import dbaut.CommonUt.WizardTextArea;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.ComboBoxCellEditor;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaTable;
import dbaut.comp.ReflectionAction;
import dbaut.infoObject.ColumnInfoObject;
import dbaut.infoObject.TableInfoObject;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.IntegerField;
import dbaut.textField.SmallintField;
import dttwizard.importODBC.ForeignKeyInfo;
import dttwizard.importODBC.IndexInfo;
import dttwizard.importODBC.PrimaryKeyInfo;
import dttwizard.importODBC.QueryObject;
import dttwizard.importODBC.odbcDialog;
import dttwizard.importText.SchemaTypes;
import dttwizard.importText.TransferCols;
import dttwizard.importText.TransferRowInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnMapTransfer
extends AbstractWizardPanel {
    private static final long serialVersionUID = 8551425493895795348L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_columnmaptransform");
    JTextPane select_TextPane = new JTextPane();
    JTextPane insert_TextPane = new JTextPane();
    JRadioButton create_RadioButton = new JRadioButton(this.res.getString("Create_dest_table"), true);
    JRadioButton delete_RadioButton = new JRadioButton(this.res.getString("Delete_row_in"));
    JRadioButton append_RadioButton = new JRadioButton(this.res.getString("Append_row_to"));
    JRadioButton replace_RadioButton = new JRadioButton(this.res.getString("Replace_dest_table"));
    private DbaButton next_Button = new DbaButton(this.res.getString("OK"), 'O', new ReflectionAction(this, "next_Button_actionPerformed"));
    private boolean isUdfTable = false;
    private boolean isQuery = false;
    TransferCols curTransferCols = new TransferCols(true);
    DbaTable jtable = new DbaTable(this.curTransferCols);
    int previousSelectedItemCount = 0;
    short radioButtonValue = 1;
    JTextField sourceTableInfo_TextField = new JTextField();
    JTextField destinationTableInfo_TextField = new JTextField();
    DetailDialog ddlg = null;
    private odbcDialog odlg = null;
    private QueryObject qo = null;
    private TableInfoObject stio = null;
    private TableInfoObject dtio = null;
    private JComboBox sourceCombo = new JComboBox();
    private JComboBox destinationCombo = new JComboBox();
    Vector<TransferRowInfo> preVector = null;
    String select_Str = "";
    String insert_Str = "";
    private boolean[] destinationBooleanArray = null;
    private int[] destinationPositionIntArray = null;

    public ColumnMapTransfer(DetailDialog ddlg, odbcDialog odlg, TableInfoObject stio, TableInfoObject dtio, boolean isUdfTable, boolean isQuery) {
        try {
            this.ddlg = ddlg;
            this.odlg = odlg;
            this.stio = stio;
            this.dtio = dtio;
            this.isUdfTable = isUdfTable;
            this.isQuery = isQuery;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ColumnMapTransfer(DetailDialog ddlg, odbcDialog odlg, QueryObject qo, TableInfoObject dtio, boolean isUdfTable, boolean isQuery) {
        try {
            this.ddlg = ddlg;
            this.odlg = odlg;
            this.qo = qo;
            this.dtio = dtio;
            this.isUdfTable = isUdfTable;
            this.isQuery = isQuery;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        if (this.dtio.getOwner().trim().length() == 0) {
            this.dtio.owner = this.dtio.loginUserName;
        }
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel(new BorderLayout());
        JPanel panel7 = new JPanel();
        JPanel panel8 = new JPanel(new BorderLayout());
        JPanel panel9 = new JPanel(new GridLayout(2, 2, 0, 0));
        JPanel panel13 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel panel14 = new JPanel(new GridLayout(2, 1));
        JPanel panel14_1 = new JPanel(new FlowLayout(0));
        JPanel panel14_2 = new JPanel(new FlowLayout(0));
        JTabbedPane tabpane = new JTabbedPane();
        JScrollPane jscroll2 = new JScrollPane(this.jtable);
        WizardTextArea area1 = new WizardTextArea(this.title, "");
        JLabel jlabel5 = new JLabel(this.res.getString("Select_SQL"));
        JLabel jlabel6 = new JLabel(this.res.getString("Insert_SQL"));
        JLabel jlabel7 = new JLabel(this.res.getString("Source_table"));
        JLabel jlabel8 = new JLabel(this.res.getString("Destination_table"));
        ButtonGroup group = new ButtonGroup();
        this.destinationCombo.setEditor(new ComboEditorField());
        this.ddlg.setTitle(this.res.getString("Import_column_odbc"));
        this.next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        panel7.setPreferredSize(new Dimension(80, 0));
        panel7.setBorder(null);
        this.select_TextPane.setPreferredSize(new Dimension(0, 80));
        this.select_TextPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.insert_TextPane.setPreferredSize(new Dimension(0, 80));
        this.insert_TextPane.setBorder(BorderFactory.createLoweredBevelBorder());
        group.add(this.create_RadioButton);
        group.add(this.delete_RadioButton);
        group.add(this.append_RadioButton);
        group.add(this.replace_RadioButton);
        panel8.setBorder(BorderFactory.createEtchedBorder());
        this.sourceTableInfo_TextField.setEditable(false);
        this.sourceTableInfo_TextField.setPreferredSize(new Dimension(350, 24));
        this.destinationTableInfo_TextField.setEditable(false);
        this.destinationTableInfo_TextField.setPreferredSize(new Dimension(350, 24));
        this.setUpSchemaSizeEditor();
        this.setUpSchemaScaleEditor();
        this.setColType(this.jtable.getColumnModel().getColumn(2));
        this.setColSource(this.jtable.getColumnModel().getColumn(0));
        this.setColDestination(this.jtable.getColumnModel().getColumn(1));
        if (!this.isQuery) {
            this.sourceTableInfo_TextField.setText(this.stio.toString());
            this.sourceTableInfo_TextField.setToolTipText(this.stio.toString());
        } else {
            this.sourceTableInfo_TextField.setText(this.qo.toString());
            this.sourceTableInfo_TextField.setToolTipText(this.qo.toString());
        }
        this.destinationTableInfo_TextField.setText(this.dtio.toString());
        this.destinationTableInfo_TextField.setToolTipText(this.dtio.toString());
        this.jtable.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jtable.setRowHeight(24);
        this.create_RadioButton.addActionListener(new ReflectionAction(this, "setDestinationComboEditable"));
        this.delete_RadioButton.addActionListener(new ReflectionAction(this, "setDestinationComboEditable"));
        this.append_RadioButton.addActionListener(new ReflectionAction(this, "setDestinationComboEditable"));
        this.replace_RadioButton.addActionListener(new ReflectionAction(this, "setDestinationComboEditable"));
        panel4.add(this.next_Button);
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        panel4.add(panel7);
        this.create_RadioButton.setPreferredSize(new Dimension(130, 18));
        this.delete_RadioButton.setPreferredSize(new Dimension(130, 18));
        this.append_RadioButton.setPreferredSize(new Dimension(130, 18));
        this.replace_RadioButton.setPreferredSize(new Dimension(130, 18));
        panel9.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(0, Color.white, new Color(148, 145, 140)), BorderFactory.createEmptyBorder(0, 10, 5, 40)));
        panel9.add(this.create_RadioButton);
        panel9.add(this.delete_RadioButton);
        panel9.add(this.replace_RadioButton);
        panel9.add(this.append_RadioButton);
        panel13.add(jlabel5);
        panel13.add(this.select_TextPane);
        panel13.add(jlabel6);
        panel13.add(this.insert_TextPane);
        jlabel7.setPreferredSize(new Dimension(120, 24));
        jlabel8.setPreferredSize(new Dimension(120, 24));
        panel14_1.add(jlabel7);
        panel14_1.add(this.sourceTableInfo_TextField);
        panel14_2.add(jlabel8);
        panel14_2.add(this.destinationTableInfo_TextField);
        panel14.add(panel14_1);
        panel14.add(panel14_2);
        panel8.add((Component)panel9, "North");
        panel8.add((Component)jscroll2, "Center");
        tabpane.addTab(this.res.getString("Column_mapping"), panel8);
        tabpane.addTab(this.res.getString("Transformation"), panel13);
        panel6.add((Component)panel14, "North");
        panel6.add((Component)tabpane, "Center");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportODBC.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6, true);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_ColumnMapTransfer", null);
        TableColumnModel tcmodel = this.jtable.getColumnModel();
        TableColumn col = tcmodel.getColumn(0);
        col.setPreferredWidth(110);
        col = tcmodel.getColumn(1);
        col.setPreferredWidth(110);
        col = tcmodel.getColumn(2);
        col.setPreferredWidth(140);
        col = tcmodel.getColumn(3);
        col.setPreferredWidth(60);
        col = tcmodel.getColumn(4);
        col.setPreferredWidth(45);
        col = tcmodel.getColumn(5);
        col.setPreferredWidth(55);
        if (!this.isQuery) {
            this.assignColumnName(this.odlg.sourceConnection.getDbConnection(), true);
        } else {
            this.assignQueryColumnName(this.odlg.sourceConnection.getDbConnection());
        }
        if (!this.isUdfTable) {
            this.assignColumnName(this.odlg.destinationConnection.getDbConnection(), false);
        } else {
            ColumnInfoObject cio = new ColumnInfoObject("", 1, 10, 0, true, true, "");
            Vector<ColumnInfoObject> v = new Vector<ColumnInfoObject>();
            v.insertElementAt(cio, 0);
            DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
            this.destinationCombo.setModel(cbm);
        }
        this.setDestinationColumnVectorValue();
        this.assignTableData();
        this.curTransferCols.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnMapTransfer.this.setNextButton();
            }
        });
        if (this.isUdfTable) {
            this.create_RadioButton.setSelected(true);
            this.delete_RadioButton.setSelected(false);
            this.append_RadioButton.setSelected(false);
            this.replace_RadioButton.setSelected(false);
            this.create_RadioButton.setEnabled(true);
            this.delete_RadioButton.setEnabled(false);
            this.append_RadioButton.setEnabled(false);
            this.replace_RadioButton.setEnabled(false);
            this.radioButtonValue = 1;
        } else {
            this.create_RadioButton.setSelected(false);
            this.create_RadioButton.setEnabled(false);
            this.delete_RadioButton.setEnabled(true);
            this.append_RadioButton.setEnabled(true);
            this.replace_RadioButton.setEnabled(true);
            if (DataTransferFrame.frame.px.getImportOdbcOptionSetting() == 2) {
                this.delete_RadioButton.setSelected(true);
                this.append_RadioButton.setSelected(false);
                this.replace_RadioButton.setSelected(false);
                this.radioButtonValue = (short)2;
            } else if (DataTransferFrame.frame.px.getImportOdbcOptionSetting() == 4) {
                this.delete_RadioButton.setSelected(false);
                this.append_RadioButton.setSelected(false);
                this.replace_RadioButton.setSelected(true);
                this.radioButtonValue = (short)4;
            } else {
                this.delete_RadioButton.setSelected(false);
                this.append_RadioButton.setSelected(true);
                this.replace_RadioButton.setSelected(false);
                this.radioButtonValue = (short)3;
            }
        }
        this.setDestinationComboEditable(null);
        this.select_Str = "";
        this.insert_Str = "";
        boolean isDBTDE = this.odlg.destinationConnection.isTDE();
        if (!isDBTDE) {
            this.jtable.hideColumn(6);
        }
    }

    public void setDestinationComboEditable(ActionEvent e) {
        if (this.create_RadioButton.isSelected() || this.replace_RadioButton.isSelected()) {
            this.destinationCombo.setEditable(true);
            this.curTransferCols.isSchemaEditable = true;
        } else {
            this.destinationCombo.setEditable(false);
            this.curTransferCols.isSchemaEditable = false;
        }
        this.setNextButton();
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        boolean b = true;
        if (this.select_TextPane.getText().trim().length() != 0) {
            PreparedStatement pstmt = null;
            try {
                this.odlg.sourceConnection.setAutoCommit(false);
                String s = this.select_TextPane.getText().trim();
                pstmt = this.odlg.sourceConnection.getDbConnection().prepareStatement(s);
                pstmt.executeQuery();
                pstmt.close();
                this.odlg.sourceConnection.getDbConnection().rollback();
                this.odlg.sourceConnection.setAutoCommit(true);
            }
            catch (SQLException sqle) {
                GuiUt.showErrorDlg(this.ddlg, sqle.getMessage(), null);
                DbaObject.close(pstmt);
                DbaObject.rollback(this.odlg.sourceConnection.getDbConnection());
                DbaObject.setAutoCommit(this.odlg.sourceConnection.getDbConnection(), true);
                b = false;
            }
        }
        if (!b) {
            return;
        }
        b = true;
        if (this.insert_TextPane.getText().trim().length() != 0) {
            Statement stmt = null;
            PreparedStatement pstmt = null;
            try {
                stmt = this.odlg.destinationConnection.getDbConnection().createStatement();
                this.odlg.destinationConnection.getDbConnection().setAutoCommit(false);
                if (this.create_RadioButton.isSelected() || this.replace_RadioButton.isSelected()) {
                    stmt.execute(this.getCreateStr());
                }
                String s = this.insert_TextPane.getText().trim();
                pstmt = this.odlg.destinationConnection.getDbConnection().prepareStatement(s);
                pstmt.close();
                this.odlg.destinationConnection.getDbConnection().rollback();
                stmt.close();
                this.odlg.destinationConnection.getDbConnection().setAutoCommit(true);
            }
            catch (SQLException sqle) {
                GuiUt.showErrorDlg(this.ddlg, sqle.getMessage(), null);
                DbaObject.close(stmt);
                DbaObject.close(pstmt);
                DbaObject.rollback(this.odlg.destinationConnection.getDbConnection());
                DbaObject.setAutoCommit(this.odlg.destinationConnection.getDbConnection(), true);
                b = false;
            }
        }
        if (!b) {
            return;
        }
        this.preVector = this.curTransferCols.getCloneData();
        this.radioButtonValue = this.create_RadioButton.isSelected() ? (short)1 : (this.delete_RadioButton.isSelected() ? (short)2 : (this.append_RadioButton.isSelected() ? (short)3 : (short)4));
        DataTransferFrame.frame.px.updateVariables(0, Short.toString(this.radioButtonValue));
        try {
            DataTransferFrame.frame.px.save();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.select_Str = this.select_TextPane.getText().trim();
        this.insert_Str = this.insert_TextPane.getText().trim();
        this.ddlg.dispose();
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.curTransferCols.setData(this.preVector);
        this.curTransferCols.fireTableChanged(new TableModelEvent(this.curTransferCols));
        switch (this.radioButtonValue) {
            case 1: {
                this.create_RadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.delete_RadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.append_RadioButton.setSelected(true);
                break;
            }
            case 4: {
                this.replace_RadioButton.setSelected(true);
            }
        }
        DataTransferFrame.frame.px.updateVariables(0, Short.toString(this.radioButtonValue));
        try {
            DataTransferFrame.frame.px.save();
        }
        catch (Exception eee) {
            eee.printStackTrace();
        }
        this.select_TextPane.setText(this.select_Str);
        this.insert_TextPane.setText(this.insert_Str);
        this.ddlg.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void assignTableData() {
        PreferencesXml px = PreferencesXml.getPreferencesXml();
        TransferRowInfo rowInfo = null;
        ColumnInfoObject cio = null;
        String precision = "";
        String scale = "";
        String type = "";
        PreferencesXml.DataType dt = null;
        for (int i = 0; i < this.destinationPositionIntArray.length; ++i) {
            if (!this.isUdfTable) {
                cio = i < this.destinationBooleanArray.length - 1 ? (!this.destinationBooleanArray[i + 1] && this.destinationPositionIntArray[i] == 0 ? (ColumnInfoObject)this.destinationCombo.getItemAt(i + 1) : (ColumnInfoObject)this.destinationCombo.getItemAt(this.destinationPositionIntArray[i])) : (ColumnInfoObject)this.destinationCombo.getItemAt(this.destinationPositionIntArray[i]);
                if (cio.getPrecision() > 0) {
                    precision = Integer.toString(cio.getPrecision());
                }
                if (cio.getScale() > 0) {
                    scale = Integer.toString(cio.getScale());
                }
                if ((type = cio.dataType).equals("smallint") || type.equals("integer") || type.equals("bigint") || type.equals("real") || type.equals("double") || type.equals("date") || type.equals("time") || type.equals("oid") || type.equals("timestamp") || type.equals("file") || type.equals("long varbinary") || type.equals("long varchar") || type.equals("serial") || type.equals("bigserial") || type.equals("nclob") || type.equals("clob") || type.equals("blob")) {
                    precision = "";
                    scale = "";
                }
                scale = !type.equals("decimal") ? "" : Integer.toString(cio.getScale());
                rowInfo = new TransferRowInfo((ColumnInfoObject)this.sourceCombo.getItemAt(i), cio, type, precision, scale, cio.getNullable(), (Boolean)cio.isEncrypted);
            } else {
                cio = (ColumnInfoObject)this.sourceCombo.getItemAt(i);
                dt = px.getTypeMap(cio.local_type);
                if (dt != null && dt.precision > 0) {
                    precision = Integer.toString(dt.precision);
                } else if (cio.getPrecision() > 0) {
                    precision = Integer.toString(cio.getPrecision());
                }
                if (dt != null && dt.scale > 0) {
                    scale = Integer.toString(dt.scale);
                } else if (cio.getScale() > 0) {
                    scale = Integer.toString(cio.getScale());
                }
                if (dt != null && dt.dmType != null) {
                    type = dt.dmType;
                    if ((type.compareTo("char") == 0 || type.compareTo("varchar") == 0 || type.compareTo("nchar") == 0 || type.compareTo("nvarchar") == 0 || type.compareTo("binary") == 0) && precision.length() == 0) {
                        precision = "10";
                    }
                } else {
                    type = cio.getDBMakerDataType();
                }
                if (type.equals("smallint") || type.equals("integer") || type.equals("bigint") || type.equals("real") || type.equals("double") || type.equals("date") || type.equals("time") || type.equals("oid") || type.equals("timestamp") || type.equals("file") || type.equals("long varbinary") || type.equals("long varchar") || type.equals("serial") || type.equals("bigserial") || type.equals("nclob") || type.equals("clob") || type.equals("blob")) {
                    precision = "";
                    scale = "";
                }
                if (!type.equals("decimal")) {
                    scale = "";
                }
                rowInfo = new TransferRowInfo((ColumnInfoObject)this.sourceCombo.getItemAt(i), cio, type, precision, scale, cio.getNullable(), (Boolean)cio.isEncrypted);
            }
            this.curTransferCols.addValue(rowInfo);
        }
        this.preVector = this.curTransferCols.getCloneData();
    }

    void setDestinationColumnVectorValue() {
        int i;
        String source = "";
        ColumnInfoObject destination_cio = null;
        this.destinationBooleanArray = new boolean[this.destinationCombo.getItemCount()];
        this.destinationPositionIntArray = new int[this.sourceCombo.getItemCount()];
        for (i = 0; i < this.destinationBooleanArray.length; ++i) {
            this.destinationBooleanArray[i] = false;
        }
        for (i = 0; i < this.destinationPositionIntArray.length; ++i) {
            this.destinationPositionIntArray[i] = 0;
        }
        for (i = 0; i < this.sourceCombo.getItemCount(); ++i) {
            source = GuiUt.rightTrim(this.sourceCombo.getItemAt(i).toString());
            for (int j = 1; j < this.destinationCombo.getItemCount(); ++j) {
                destination_cio = (ColumnInfoObject)this.destinationCombo.getItemAt(j);
                if (!this.odlg.destinationConnection.isIDCAP()) {
                    if (!source.equals(GuiUt.rightTrim(destination_cio.toString()))) continue;
                    this.destinationBooleanArray[j] = true;
                    this.destinationPositionIntArray[i] = j;
                    continue;
                }
                if (!source.equalsIgnoreCase(GuiUt.rightTrim(destination_cio.toString()))) continue;
                this.destinationBooleanArray[j] = true;
                this.destinationPositionIntArray[i] = j;
            }
        }
    }

    private Vector<Object> assignQueryColumnName(Connection connection) {
        ResultSet rs = null;
        Statement stmt = null;
        Vector<Object> v = new Vector<Object>();
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(this.qo.queryData);
            rs.next();
            ResultSetMetaData rsmd = rs.getMetaData();
            int column_count = rsmd.getColumnCount();
            String colname = "";
            int precision = 10;
            int scale = 0;
            boolean nullable = true;
            boolean isAutoIncrement = false;
            ColumnInfoObject cio = null;
            int isNull = 0;
            for (int i = 1; i <= column_count; ++i) {
                colname = rsmd.getColumnName(i);
                int type = rsmd.getColumnType(i);
                precision = rsmd.getPrecision(i);
                scale = rsmd.getScale(i);
                isNull = rsmd.isNullable(i);
                String local_type = rsmd.getColumnTypeName(i);
                isAutoIncrement = rsmd.isAutoIncrement(i);
                if (local_type.equalsIgnoreCase("nchar") || local_type.equalsIgnoreCase("nvarchar")) {
                    precision /= 2;
                }
                switch (isNull) {
                    case 0: {
                        nullable = false;
                        break;
                    }
                    case 1: {
                        nullable = true;
                        break;
                    }
                    case 2: {
                        nullable = true;
                        break;
                    }
                    default: {
                        nullable = true;
                    }
                }
                if ((type == 5 || type == 4) && isAutoIncrement) {
                    local_type = "serial";
                } else if (type == -5 && isAutoIncrement) {
                    local_type = "bigserial";
                }
                cio = new ColumnInfoObject(colname, type, precision, scale, nullable, false, local_type);
                v.add(cio);
            }
            DefaultComboBoxModel<Object> cbm = new DefaultComboBoxModel<Object>(v);
            this.sourceCombo.setModel(cbm);
            if (v.size() != 0) {
                this.sourceCombo.setSelectedIndex(0);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.ddlg, null, sqle);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        return v;
    }

    private boolean[] getAutoIncrement(Connection connection, String owner, String name) throws SQLException {
        String sql = "select * from ";
        if (owner != null && owner.length() > 0) {
            sql = sql + GuiUt.getIDString(owner) + ".";
        }
        sql = sql + GuiUt.getIDString(name);
        PreparedStatement pstmt = connection.prepareStatement(sql);
        ResultSetMetaData rsmd = pstmt.getMetaData();
        int count = rsmd.getColumnCount();
        boolean[] result = new boolean[count];
        for (int i = 0; i < count; ++i) {
            result[i] = rsmd.isAutoIncrement(i + 1);
        }
        return result;
    }

    private Vector<Object> assignColumnName(Connection connection, boolean isSource) {
        ResultSet rs = null;
        Vector<Object> v = new Vector<Object>();
        Statement stmt = null;
        try {
            DefaultComboBoxModel<Object> cbm;
            String colname = "";
            String dbmaker_type = "";
            String local_type = "";
            int precision = 10;
            int scale = 0;
            boolean nullable = true;
            ColumnInfoObject cio = null;
            boolean isDBTDE = this.odlg.destinationConnection.isTDE();
            int isNull = 0;
            int reserve5 = 0;
            boolean isEncrypted = false;
            if (!isSource) {
                stmt = connection.createStatement();
                String owner = this.dtio.getOwner();
                String name = this.dtio.getName();
                if (this.odlg.destinationConnection.isIDCAP()) {
                    owner = owner.toUpperCase();
                    name = name.toUpperCase();
                }
                rs = stmt.executeQuery("select COLUMN_NAME, TYPE_NAME, PRECISION, SCALE, NULLABLE, RESERVE5 from SYSTEM.SYSCOLUMN where TABLE_OWNER ='" + owner + "' and TABLE_NAME = '" + name + "' order by COLUMN_ORDER");
                while (rs.next()) {
                    colname = rs.getString(1).trim();
                    dbmaker_type = rs.getString(2).toLowerCase().trim();
                    precision = rs.getInt(3);
                    scale = rs.getInt(4);
                    isNull = rs.getInt(5);
                    reserve5 = rs.getInt(6);
                    boolean bl = isEncrypted = (reserve5 & 8) != 0;
                    if (!isDBTDE && (reserve5 & 8) != 0) continue;
                    nullable = isNull == 1;
                    cio = new ColumnInfoObject(colname, dbmaker_type, precision, scale, nullable, false, isEncrypted);
                    v.add(cio);
                    cio = null;
                }
                rs.close();
                stmt.close();
            } else {
                boolean[] isAutoIncrement = this.getAutoIncrement(connection, this.stio.getOwner(), this.stio.getName());
                DatabaseMetaData dbmd = connection.getMetaData();
                rs = dbmd.getColumns(null, this.stio.getOwner(), this.stio.getName(), null);
                int i = 0;
                while (rs.next()) {
                    colname = rs.getString(4).trim();
                    int data_type = rs.getInt(5);
                    local_type = rs.getString(6);
                    int type = data_type == -4 && local_type != null && local_type.equalsIgnoreCase("file") ? 301 : data_type;
                    if ((data_type == 5 || data_type == 4) && isAutoIncrement[i]) {
                        local_type = "serial";
                    } else if (data_type == -5 && isAutoIncrement[i]) {
                        local_type = "bigserial";
                    }
                    precision = rs.getInt(7);
                    scale = rs.getInt(9);
                    isNull = rs.getInt(11);
                    switch (isNull) {
                        case 0: {
                            nullable = false;
                            break;
                        }
                        case 1: {
                            nullable = true;
                            break;
                        }
                        case 2: {
                            nullable = true;
                            break;
                        }
                        default: {
                            nullable = true;
                        }
                    }
                    cio = new ColumnInfoObject(colname, type, precision, scale, nullable, false, local_type);
                    v.add(cio);
                    cio = null;
                    ++i;
                }
                rs.close();
            }
            if (!isSource) {
                cio = new ColumnInfoObject("", "char", 10, 0, true, true);
                v.insertElementAt(cio, 0);
                cbm = new DefaultComboBoxModel<Object>(v);
                this.destinationCombo.setModel(cbm);
            } else {
                cbm = new DefaultComboBoxModel<Object>(v);
                this.sourceCombo.setModel(cbm);
                if (v.size() != 0) {
                    this.sourceCombo.setSelectedIndex(0);
                }
            }
        }
        catch (SQLException qce) {
            GuiUt.showSQLException(this.ddlg, null, qce);
            DbaObject.close(rs);
        }
        return v;
    }

    private void setColSource(TableColumn colSource) {
        colSource.setCellEditor(new DefaultCellEditor(this.sourceCombo));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for combo box");
        colSource.setCellRenderer(renderer);
    }

    private void setColDestination(TableColumn colDest) {
        colDest.setCellEditor(new ComboBoxCellEditor(this.destinationCombo, true, this.odlg.destinationConnection.getUserName()));
        colDest.setCellRenderer(new DefaultTableCellRenderer());
    }

    private void setColType(TableColumn colType) {
        SchemaTypes comboBox = new SchemaTypes(this.odlg);
        colType.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        colType.setCellRenderer(renderer);
    }

    private void setUpSchemaSizeEditor() {
        this.jtable.setUpIntegerEditorStr(3, new IntegerField(4, true, true));
    }

    private void setUpSchemaScaleEditor() {
        this.jtable.setUpShortEditorStr(4, new SmallintField(true));
    }

    public boolean isCorrectStatus() {
        boolean b = false;
        for (int i = 0; i < this.jtable.getRowCount(); ++i) {
            if (this.jtable.getValueAt(i, 1).toString().trim().length() != 0) {
                b = true;
                break;
            }
            if (i != this.jtable.getRowCount() - 1 || this.jtable.getValueAt(i, 1).toString().trim().length() != 0) continue;
            b = false;
        }
        if (!b && this.create_RadioButton.isSelected()) {
            b = true;
        }
        return b;
    }

    private String source2dest(String src) {
        int rowCount = this.jtable.getRowCount();
        String dest = null;
        String s0 = null;
        for (int i = 0; i < rowCount; ++i) {
            s0 = this.curTransferCols.getValueAt(i, 0).toString().trim();
            if (s0.compareToIgnoreCase(src) != 0) continue;
            dest = this.curTransferCols.getValueAt(i, 1).toString().trim();
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ForeignKeyInfo> getForeignKeyInfo() {
        ArrayList<ForeignKeyInfo> infos = null;
        ResultSet rs = null;
        Connection conn = this.odlg.sourceConnection.getDbConnection();
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getImportedKeys(this.stio.schema, this.stio.owner, this.stio.name);
            short colseq = 0;
            String last_fkName = null;
            String pkTable_Cat = null;
            String pkTable_Schema = null;
            String pkTable_Name = null;
            ArrayList<String> pkTable_Columns = null;
            String fkTable_Cat = null;
            String fkTable_Schema = null;
            String fkTable_Name = null;
            String pk_column = null;
            String fk_column = null;
            ArrayList<String> fkTable_Columns = null;
            short updateRule = 3;
            short deleteRule = 3;
            String fkName = null;
            String pkName = null;
            short deferrability = 5;
            while (rs.next()) {
                pkTable_Cat = rs.getString(1);
                pkTable_Schema = rs.getString(2);
                pkTable_Name = rs.getString(3);
                pk_column = rs.getString(4);
                fkTable_Cat = rs.getString(5);
                fkTable_Schema = rs.getString(6);
                fkTable_Name = rs.getString(7);
                fk_column = rs.getString(8);
                updateRule = rs.getShort(10);
                deleteRule = rs.getShort(11);
                fkName = rs.getString(12);
                deferrability = rs.getShort(14);
                if (fkName.equals(last_fkName)) {
                    colseq = rs.getShort(9);
                    if (colseq > 0 && colseq > pkTable_Columns.size()) {
                        pkTable_Columns.add(pk_column);
                        fkTable_Columns.add(fk_column);
                        continue;
                    }
                    pkTable_Columns.set(colseq - 1, pk_column);
                    fkTable_Columns.set(colseq - 1, fk_column);
                    continue;
                }
                pkTable_Columns = new ArrayList<String>();
                pkTable_Columns.add(pk_column);
                fkTable_Columns = new ArrayList<String>();
                fkTable_Columns.add(fk_column);
                last_fkName = fkName;
                if (infos == null) {
                    infos = new ArrayList<ForeignKeyInfo>();
                }
                infos.add(new ForeignKeyInfo(pkTable_Cat, this.odlg.destSchema, pkTable_Name, pkTable_Columns, fkTable_Cat, this.dtio.owner, this.dtio.name, fkTable_Columns, updateRule, deleteRule, last_fkName, pkName, deferrability));
            }
            DbaObject.close(rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbaObject.close(rs);
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimaryKeyInfo getPrimaryKeyInfo() {
        PrimaryKeyInfo info = null;
        ResultSet rs = null;
        Connection conn = this.odlg.sourceConnection.getDbConnection();
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getPrimaryKeys(this.stio.schema, this.stio.owner, this.stio.name);
            ArrayList<String> columns = new ArrayList<String>();
            String colname = null;
            int colseq = 0;
            while (rs.next()) {
                colname = rs.getString(4);
                colseq = rs.getInt(5);
                if (colname != null) {
                    colname = colname.trim();
                    colname = this.source2dest(colname);
                }
                if (colname == null || colname.length() <= 0) continue;
                if (colseq > 0 && colseq > columns.size()) {
                    columns.add(colname);
                    continue;
                }
                columns.set(colseq - 1, colname);
            }
            if (columns.size() > 0) {
                info = new PrimaryKeyInfo(this.dtio.owner, this.dtio.name, columns);
            }
            DbaObject.close(rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbaObject.close(rs);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<IndexInfo> getIndexInfo() {
        ArrayList<IndexInfo> info = new ArrayList<IndexInfo>();
        Connection conn = this.odlg.sourceConnection.getDbConnection();
        String tb_owner = null;
        String tb_name = null;
        String cur_index_name = null;
        boolean non_unique = false;
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getIndexInfo(this.stio.schema, this.stio.owner, this.stio.name, false, false);
            short colseq = 0;
            String colname = null;
            String asc_or_desc = null;
            ArrayList<IndexInfo.ColumnInfo> columns = null;
            IndexInfo.ColumnInfo col = null;
            while (rs.next()) {
                tb_owner = rs.getString(2);
                tb_name = rs.getString(3);
                non_unique = rs.getBoolean(4);
                String index_name = rs.getString(6);
                if (index_name == null || index_name.compareTo("PRIMARYKEY") == 0 || index_name.toUpperCase().contains("PRIMARY") || index_name.toUpperCase().contains((tb_name + "_PK").toUpperCase()) || index_name.toUpperCase().contains(("PK_" + tb_name).toUpperCase())) continue;
                if (cur_index_name == null || !cur_index_name.equals(index_name)) {
                    if (cur_index_name != null) {
                        info.add(new IndexInfo(this.dtio.owner, this.dtio.name, cur_index_name, !non_unique, columns));
                    }
                    cur_index_name = index_name;
                    columns = new ArrayList<IndexInfo.ColumnInfo>();
                }
                colseq = rs.getShort(8);
                colname = rs.getString(9);
                asc_or_desc = rs.getString(10);
                if (colname != null) {
                    colname = colname.trim();
                    colname = this.source2dest(colname);
                }
                col = new IndexInfo.ColumnInfo(colname, !asc_or_desc.equals("D"));
                if (colname == null || colname.length() <= 0) continue;
                if (colseq > 0 && colseq > columns.size()) {
                    columns.add(col);
                    continue;
                }
                columns.set(colseq - 1, col);
            }
            if (columns != null && columns.size() > 0) {
                info.add(new IndexInfo(this.dtio.owner, this.dtio.name, cur_index_name, !non_unique, columns));
            }
            DbaObject.close(rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbaObject.close(rs);
        }
        return info;
    }

    public String getCreateStr() {
        this.jtable.editingStopped(null);
        boolean sign = false;
        String createStr = "create table ";
        this.dtio.owner = this.odlg.destSchema;
        createStr = createStr + GuiUt.getIDString(this.odlg.destSchema) + ".";
        createStr = this.dtio.getName().startsWith("\"") && this.dtio.getName().endsWith("\"") ? createStr + this.dtio.getName() + " (" : createStr + GuiUt.getIDString(this.dtio.getName()) + " (";
        int rowCount = this.jtable.getRowCount();
        String tmpStr = "";
        String myStr = "";
        for (int i = 0; i < rowCount; ++i) {
            if (this.curTransferCols.getValueAt(i, 1).toString().trim().length() == 0) continue;
            String cName = this.curTransferCols.getValueAt(i, 1).toString().trim();
            String type = this.curTransferCols.getValueAt(i, 2).toString().trim();
            String size = this.curTransferCols.getValueAt(i, 3).toString().trim();
            String scale = this.curTransferCols.getValueAt(i, 4).toString().trim();
            String nullable = this.curTransferCols.getValueAt(i, 5).toString().trim();
            if (cName.trim().length() == 0) continue;
            if (!sign) {
                sign = true;
                tmpStr = "";
                myStr = myStr + GuiUt.getIDString(cName);
                if (!size.equalsIgnoreCase("")) {
                    tmpStr = tmpStr + "(" + size;
                    tmpStr = scale.equalsIgnoreCase("") ? tmpStr + ")" : tmpStr + "," + scale + ")";
                }
                myStr = type.indexOf(" ") >= 0 ? (type.equalsIgnoreCase("long varchar") || type.equalsIgnoreCase("long varbinary") || type.equalsIgnoreCase("nclob") || type.equalsIgnoreCase("clob") || type.equalsIgnoreCase("blob") ? myStr + " " + type + tmpStr : myStr + " " + "\"" + type + "\"" + tmpStr) : myStr + " " + type + tmpStr;
                if (nullable.equalsIgnoreCase("false") && !type.equalsIgnoreCase("serial") && !type.equalsIgnoreCase("bigserial")) {
                    myStr = myStr + " not null";
                }
                createStr = createStr + myStr;
                continue;
            }
            myStr = "";
            tmpStr = "";
            myStr = myStr + "\"" + cName + "\"";
            if (!size.equalsIgnoreCase("")) {
                tmpStr = tmpStr + "(" + size;
                tmpStr = scale.equalsIgnoreCase("") ? tmpStr + ")" : tmpStr + "," + scale + ")";
            }
            myStr = type.indexOf(" ") >= 0 ? (type.equalsIgnoreCase("long varchar") || type.equalsIgnoreCase("long varbinary") || type.equalsIgnoreCase("nclob") || type.equalsIgnoreCase("clob") || type.equalsIgnoreCase("blob") ? myStr + " " + type + tmpStr : myStr + " " + "\"" + type + "\"" + tmpStr) : myStr + " " + type + tmpStr;
            if (nullable.equalsIgnoreCase("false") && !type.equalsIgnoreCase("serial") && !type.equalsIgnoreCase("bigserial")) {
                myStr = myStr + " not null";
            }
            createStr = createStr + " ," + myStr;
        }
        if ((createStr = createStr.trim()).endsWith(",")) {
            createStr = createStr.substring(0, createStr.length() - 1);
        }
        createStr = createStr + ")";
        return createStr;
    }

    public String getSelectStr() {
        PreferencesXml px = PreferencesXml.getPreferencesXml();
        this.jtable.editingStopped(null);
        String selectStr = "";
        if (!this.isQuery) {
            if (this.select_TextPane.getText().trim().length() != 0) {
                selectStr = this.select_TextPane.getText().trim();
            } else {
                selectStr = "select ";
                int rowCount = this.jtable.getRowCount();
                ColumnInfoObject cio = null;
                String udf = null;
                String castType = null;
                for (int i = 0; i < rowCount; ++i) {
                    if (this.curTransferCols.getValueAt(i, 1).toString().trim().length() == 0) continue;
                    String cName = this.curTransferCols.getValueAt(i, 0).toString().trim();
                    cio = (ColumnInfoObject)this.curTransferCols.getValueAt(i, 0);
                    if (i != 0) {
                        selectStr = selectStr + ", ";
                    }
                    selectStr = this.odlg.isVFPDriver ? selectStr + cName : ((udf = px.getUdfForType(cio.local_type)) != null ? selectStr + udf + "(" + cName + ")" : ((castType = px.getDmTypeForType(cio.local_type)) != null ? selectStr + "cast(" + cName + " as " + castType + ")" : selectStr + GuiUt.getIDString(cName, this.odlg.getQuoteIdChar())));
                }
                if ((selectStr = selectStr.trim()).endsWith(",")) {
                    selectStr = selectStr.substring(0, selectStr.length() - 1);
                }
                selectStr = selectStr + " from " + this.stio.toString();
            }
        } else {
            selectStr = this.select_TextPane.getText().trim().length() != 0 ? this.select_TextPane.getText().trim() : this.qo.queryData;
        }
        System.out.println("selectStr=" + selectStr);
        return selectStr;
    }

    public String getInsertStr() {
        this.jtable.editingStopped(null);
        String insertStr = "";
        if (this.insert_TextPane.getText().trim().length() != 0) {
            insertStr = this.insert_TextPane.getText().trim();
        } else {
            insertStr = "insert into \"" + this.dtio.getOwner() + "\".\"" + this.dtio.getName() + "\" ";
            int rowCount = this.jtable.getRowCount();
            String s = null;
            String valueStr = "";
            short[] shortA = new short[rowCount];
            int j = 0;
            boolean b = false;
            for (int i = 0; i < rowCount; ++i) {
                s = this.jtable.getValueAt(i, 1).toString();
                if (s.trim().length() == 0) continue;
                if (i == 0) {
                    insertStr = insertStr + "(" + GuiUt.getIDString(s);
                    valueStr = valueStr + "( ?";
                    b = true;
                } else if (!b) {
                    insertStr = insertStr + "(" + GuiUt.getIDString(s);
                    valueStr = valueStr + "( ?";
                    b = true;
                } else {
                    insertStr = insertStr + "," + GuiUt.getIDString(s);
                    valueStr = valueStr + ", ?";
                }
                shortA[j++] = (short)(i + 1);
            }
            insertStr = insertStr + ") values ";
            insertStr = insertStr + valueStr + ")";
        }
        return insertStr;
    }

    public boolean setNextButton() {
        int rowCount = this.jtable.getRowCount();
        boolean b = false;
        for (int i = 0; i < rowCount; ++i) {
            if (this.jtable.getValueAt(i, 1).toString().trim().length() != 0) {
                b = true;
                break;
            }
            b = false;
        }
        if (this.delete_RadioButton.isSelected() || this.append_RadioButton.isSelected()) {
            if (b) {
                this.next_Button.setEnabled(true);
            } else {
                this.next_Button.setEnabled(false);
            }
        } else {
            this.next_Button.setEnabled(true);
        }
        return b;
    }
}

