/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importJson;

import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importJson.LogDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class ViewLogFile
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportTextRes", LocaleManager.getLocale());
    private String title = this.res.getString("Json_review_log");
    private LogDialog logdlg = null;
    private JTextPane logContent_TextPane = new JTextPane();
    private StringBuffer logName = null;

    public ViewLogFile(LogDialog logdlg, StringBuffer logName) {
        try {
            this.logdlg = logdlg;
            this.logName = logName;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton ok_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Json_ok"), 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "ok_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        WizardTextArea area1 = new WizardTextArea(this.title, "");
        JScrollPane jscroll = new JScrollPane(this.logContent_TextPane);
        this.logContent_TextPane.setCaretPosition(0);
        JPanel panel1 = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new FlowLayout(2));
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_ViewLogFile", null);
        jscroll.setPreferredSize(new Dimension(0, 400));
        jscroll.setBorder(BorderFactory.createLineBorder(null));
        this.logContent_TextPane.setEditable(false);
        panel2.add(ok_Button);
        panel2.add(help_Button);
        panel1.add((Component)jscroll, "Center");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportText.jpg"));
        this.setButtonBar(panel2);
        this.setTextArea(area1);
        this.setContent(panel1, false);
        this.getFileContent(this.logName);
    }

    public void ok_Button_actionPerformed(ActionEvent e) {
        this.logdlg.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private void getFileContent(StringBuffer filename) {
        try {
            this.logContent_TextPane.setText("");
            this.logContent_TextPane.setText(filename.toString());
        }
        catch (Exception e) {
            GuiUt.showErrorDlg(this, e.getMessage(), null);
        }
    }
}

