/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importJson;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbmaker.sql.JdbcOdbcConnection;
import dttwizard.importJson.ImJsonDialog;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class JsonDataHandle {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportTextRes", LocaleManager.getLocale());
    private ImJsonDialog imt = null;
    private PreparedStatement pstmt = null;
    private int recordNum = 0;
    private StringBuffer infoMsg = new StringBuffer();
    Connection conn = null;
    ArrayList<String> columnLists = null;
    private String insertSql;

    public JsonDataHandle(ImJsonDialog imt, ArrayList<String> columnLists, String insertSql) {
        try {
            this.imt = imt;
            this.columnLists = columnLists;
            this.insertSql = insertSql;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadJson() throws Exception {
        long lStartTime = System.nanoTime();
        Object jsonFile = null;
        try {
            FileInputStream is = new FileInputStream(this.imt.sourceFileName.trim());
            InputStreamReader isr = new InputStreamReader(is);
            JsonReader reader = new JsonReader((Reader)isr);
            JsonToken token = null;
            block2: while (reader.hasNext() && (token = reader.peek()).equals((Object)JsonToken.BEGIN_ARRAY)) {
                reader.beginArray();
                while (true) {
                    if ((token = reader.peek()).equals((Object)JsonToken.END_ARRAY)) {
                        reader.endArray();
                        continue block2;
                    }
                    if (!token.equals((Object)JsonToken.BEGIN_OBJECT)) continue block2;
                    this.handleRow(reader);
                }
            }
        }
        catch (IOException e) {
            this.infoMsg.append(e.getMessage()).append("\n");
            return;
        }
        long lEndTime = System.nanoTime();
        long output = lEndTime - lStartTime;
        if (this.infoMsg.length() > 0) {
            this.infoMsg.append("\n");
        }
        String importedRecords = this.res.getString("Json_process_keyword") + " " + this.recordNum + " " + this.res.getString("Json_records_keyword");
        this.infoMsg.append(importedRecords).append("\n");
        this.infoMsg.append(this.res.getString("Json_elapsed_time") + " " + output / 1000000L / 1000L).append("\n");
        this.imt.infoMsg = this.infoMsg;
        this.recordNum = 0;
        this.infoMsg = null;
    }

    private void handleRow(JsonReader reader) throws Exception {
        int i;
        reader.beginObject();
        JsonToken token = null;
        String name = null;
        int index = 0;
        boolean[] isNull = new boolean[this.columnLists.size()];
        for (i = 0; i < isNull.length; ++i) {
            isNull[i] = true;
        }
        while (reader.hasNext()) {
            token = reader.peek();
            if (token.equals((Object)JsonToken.NAME)) {
                name = token.name();
                index = this.columnLists.indexOf(name);
                if (index < 0) {
                    reader.nextString();
                    continue;
                }
                this.pstmt.setString(index + 1, reader.nextString());
                isNull[index] = false;
                continue;
            }
            if (!token.equals((Object)JsonToken.END_OBJECT)) continue;
            for (i = 0; i < isNull.length; ++i) {
                if (!isNull[i]) continue;
                this.pstmt.setNull(i + 1, 1);
            }
            this.pstmt.executeUpdate();
            reader.endObject();
            return;
        }
    }

    private PreparedStatement generateSqlQuery() {
        try {
            this.conn = this.imt.connection.getDbConnection();
            ((JdbcOdbcConnection)this.conn).setOption(1136, 1);
            return this.conn.prepareStatement(this.insertSql.toString());
        }
        catch (SQLException sqle) {
            this.infoMsg.append(sqle.getMessage()).append("\n");
            return null;
        }
    }

    private boolean isSelectedColumn(String jsonColumn) {
        Iterator<String> it = this.columnLists.iterator();
        Boolean isFlag = false;
        while (it.hasNext()) {
            if (!jsonColumn.trim().equalsIgnoreCase(it.next().toString().trim())) continue;
            isFlag = true;
            break;
        }
        return isFlag;
    }
}

