/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importJson;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import datatransfer.DataTransferFrame;
import dbaut.GuiUt;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class DataFileTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8950445729755131339L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportTextRes", LocaleManager.getLocale());
    private ArrayList<ColumnInfo> columnNames = new ArrayList();
    private ArrayList<String[]> data = new ArrayList();
    protected File jsonFile;
    public int initResult = 0;

    public DataFileTableModel(File f) {
        this.jsonFile = f;
        this.initData();
    }

    private int searchName(String name) {
        ColumnInfo col = null;
        for (int i = 0; i < this.columnNames.size(); ++i) {
            col = this.columnNames.get(i);
            if (!col.name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    public ArrayList<ColumnInfo> getColumnNames() {
        return this.columnNames;
    }

    private boolean isInteger(JsonElement json) {
        try {
            new Integer(json.getAsString());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private JsonElement loadJson() throws Exception {
        JsonArray root = null;
        FileInputStream is = new FileInputStream(this.jsonFile);
        InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
        JsonReader reader = new JsonReader((Reader)isr);
        JsonToken token = null;
        if (reader.hasNext()) {
            token = reader.peek();
            if (!token.equals((Object)JsonToken.BEGIN_ARRAY)) {
                this.initResult = -1;
                GuiUt.showErrorDlg(DataTransferFrame.frame, this.res.getString("Json_node_is_not_array"), null);
                return null;
            }
            reader.beginArray();
            root = new JsonArray();
            for (int count = 0; count < 5; ++count) {
                token = reader.peek();
                if (token.equals((Object)JsonToken.END_ARRAY)) {
                    reader.endArray();
                    break;
                }
                if (!token.equals((Object)JsonToken.BEGIN_OBJECT)) break;
                this.handleRow(root, reader);
            }
        }
        return root;
    }

    private void handleRow(JsonArray root, JsonReader reader) throws Exception {
        reader.beginObject();
        JsonToken token = null;
        String name = null;
        String value = null;
        JsonObject obj = new JsonObject();
        root.add((JsonElement)obj);
        while (reader.hasNext()) {
            token = reader.peek();
            if (token.equals((Object)JsonToken.NAME)) {
                name = reader.nextName();
                token = reader.peek();
                if (token.equals((Object)JsonToken.NULL)) {
                    reader.nextNull();
                    value = null;
                } else {
                    value = reader.nextString();
                }
                obj.addProperty(name, value);
                continue;
            }
            if (token.equals((Object)JsonToken.END_OBJECT)) break;
            return;
        }
        reader.endObject();
    }

    private void initData() {
        try {
            JsonElement root = null;
            if (this.jsonFile.length() < 1000000L) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.jsonFile), "UTF-8"));
                Gson gson = new Gson();
                root = (JsonElement)gson.fromJson((Reader)bufferedReader, JsonElement.class);
            } else {
                GuiUt.showWarningDlg(DataTransferFrame.frame, "Warning", this.res.getString("Json_file_too_big"));
                root = this.loadJson();
            }
            if (root == null || root.isJsonNull()) {
                this.initResult = -1;
                GuiUt.showErrorDlg(DataTransferFrame.frame, this.res.getString("Json_node_is_empty"), null);
                return;
            }
            if (!root.isJsonArray()) {
                this.initResult = -1;
                GuiUt.showErrorDlg(DataTransferFrame.frame, this.res.getString("Json_node_is_not_array"), null);
                return;
            }
            int rowIndex = 0;
            String name = null;
            int index = 0;
            for (JsonElement node : root.getAsJsonArray()) {
                if (!node.isJsonObject()) continue;
                for (Map.Entry entry : node.getAsJsonObject().entrySet()) {
                    name = (String)entry.getKey();
                    index = this.searchName(name);
                    if (index >= 0) continue;
                    this.columnNames.add(new ColumnInfo(name));
                }
                if (++rowIndex != 5) continue;
                break;
            }
            if (this.columnNames.size() == 0) {
                this.initResult = -1;
                GuiUt.showErrorDlg(DataTransferFrame.frame, this.res.getString("Json_node_is_empty"), null);
                return;
            }
            rowIndex = 0;
            JsonElement elm = null;
            ColumnInfo col = null;
            for (JsonElement node : root.getAsJsonArray()) {
                Map.Entry entry;
                String[] rowData = new String[this.columnNames.size()];
                if (!node.isJsonObject()) continue;
                Iterator i$ = node.getAsJsonObject().entrySet().iterator();
                while (i$.hasNext() && (index = this.searchName(name = (String)(entry = (Map.Entry)i$.next()).getKey())) >= 0) {
                    elm = (JsonElement)entry.getValue();
                    rowData[index] = elm.isJsonNull() ? null : elm.getAsString();
                    col = this.columnNames.get(index);
                    if (elm.isJsonPrimitive() && elm.getAsJsonPrimitive().isNumber()) {
                        col.type = this.isInteger(elm) ? "integer" : "float";
                    }
                    if (this.columnNames.get((int)index).type != null) continue;
                    col.type = "nvarchar";
                    col.precision = 255;
                }
                this.data.add(rowData);
                if (++rowIndex != 5) continue;
                break;
            }
            this.initResult = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.initResult = -1;
            GuiUt.showErrorDlg(DataTransferFrame.frame, this.res.getString("Json_load_error"), null);
            return;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column).toString();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data.get(rowIndex)[columnIndex];
    }

    class ColumnInfo {
        String name = null;
        String type = null;
        int precision = 0;
        boolean isEncrypted = false;

        ColumnInfo(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

