/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.exportText;

import com.borland.jbcl.layout.VerticalFlowLayout;
import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.FilePathField;
import dttwizard.exportText.ExTextDialog;
import dttwizard.exportText.FileFormat;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TextName
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Export.dtt_ExportTextRes", LocaleManager.getLocale());
    private String title = this.res.getString("Name_the_textfile");
    private ExTextDialog ext = null;
    private AbstractWizardPanel previous = null;
    private AbstractWizardPanel next1 = null;
    private DbaButton next_Button = new DbaButton(this.res.getString("Next"), 'N', new ReflectionAction(this, "next_Button_actionPerformed"));
    private FilePathField filePath_TextField = null;
    private String filename = null;

    public TextName(ExTextDialog ext, AbstractWizardPanel previous, String filename) {
        try {
            this.ext = ext;
            this.previous = previous;
            this.title = this.title;
            this.filename = filename;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel panel7 = new JPanel(new FlowLayout(0));
        JPanel panel8 = new JPanel();
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Specify_a_name"));
        JScrollPane jscroll1 = new JScrollPane(area1);
        JLabel jlabel3 = new JLabel(this.res.getString("text_file"));
        this.filePath_TextField = new FilePathField(this.ext, false);
        this.next_Button.setHorizontalTextPosition(2);
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        this.next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"));
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        panel8.setPreferredSize(new Dimension(80, 0));
        panel8.setBorder(null);
        this.filePath_TextField.setPreferredSize(new Dimension(250, 24));
        this.filePath_TextField.setBorder(BorderFactory.createLoweredBevelBorder());
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(panel8);
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        panel7.add(jlabel3);
        panel7.add(this.filePath_TextField);
        panel6.add(panel7);
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ExportText.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        if (DataTransferFrame.frame != null) {
            DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ExportText_TextName", null);
        }
        this.filePath_TextField.setText(this.filename);
        this.filePath_TextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextName.this.filePath_TextField_keyReleased(null);
            }
        });
    }

    void filePath_TextField_keyReleased(KeyEvent e) {
        if (this.filePath_TextField.getText().length() > 0) {
            this.next_Button.setEnabled(true);
        } else {
            this.next_Button.setEnabled(false);
        }
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.ext.Next(this.previous);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        File file;
        int p;
        String s;
        if (this.ext.fileName != null) {
            if (GuiUt.isWindows()) {
                if (!this.ext.fileName.equalsIgnoreCase(this.filePath_TextField.getText().trim())) {
                    this.next1 = null;
                }
            } else if (!this.ext.fileName.equals(this.filePath_TextField.getText().trim())) {
                this.next1 = null;
            }
        }
        if ((s = this.filePath_TextField.getText().trim()).length() == 0) {
            GuiUt.showErrorDlg(this.ext, this.res.getString("Text_file_name_or_file_path_cannot_be_all_spaces"), null);
            return;
        }
        if (s.length() >= 252) {
            GuiUt.showErrorDlg(this.ext, this.res.getString("The_file_extension_is_not_txt_and_file_path_length_is_over_251"), null);
            return;
        }
        String extension = "";
        int i = s.lastIndexOf(46);
        if (i > (p = Math.max(s.lastIndexOf(47), s.lastIndexOf(92)))) {
            extension = s.substring(i + 1);
        }
        if (extension.length() == 0) {
            s = s + ".txt";
        }
        this.ext.fileName = s;
        this.filePath_TextField.setText(s);
        File f = new File(this.ext.fileName);
        String path = f.getParent();
        if (path != null && !(file = new File(path)).exists()) {
            GuiUt.showErrorDlg(this.ext, this.res.getString("Directory") + " " + file.getPath() + " " + this.res.getString("Does_not_exist"), null);
            this.next1 = null;
            return;
        }
        if (this.next1 == null) {
            this.next1 = new FileFormat(this.ext, this);
        }
        this.ext.Next(this.next1);
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.ext.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

