/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.textField.IntegerField;
import dbaut.util.PlatformUtil;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class IntegerRangeField2
extends IntegerField {
    private static final long serialVersionUID = -3553067095918107385L;
    private int minValue;
    private int maxValue;

    public IntegerRangeField2(int minValue, int maxValue, boolean positive) {
        super(positive);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.init();
    }

    private void init() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                IntegerRangeField2.this.valueFieldFocusLost(e);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    IntegerRangeField2.this.valueFieldKeyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                IntegerRangeField2.this.valueFieldKeyReleased(e);
            }
        });
    }

    private void valueFieldFocusLost(FocusEvent e) {
        Integer v = (Integer)this.getValue();
        if (v == null) {
            return;
        }
        if (v <= this.minValue) {
            this.setValue(this.minValue);
        }
        if (v >= this.maxValue) {
            this.setValue(this.maxValue);
        }
    }

    private void valueFieldKeyReleased(KeyEvent e) {
        if (e.getKeyCode() != 39 && e.getKeyCode() != 37 && e.getKeyCode() != 36) {
            Integer v = (Integer)this.getValue();
            if (v == null) {
                return;
            }
            if (v >= this.maxValue || v <= this.minValue) {
                this.valueFieldFocusLost(null);
            }
            if (e.getKeyCode() == 10) {
                this.valueFieldFocusLost(null);
            }
        }
    }
}

