/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.text.TextField;
import dbaut.textField.DbaTextField;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntegerField
extends TextField
implements DbaTextField {
    private static final long serialVersionUID = 3943479229269364319L;
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);
    private int max_length = 0;
    private boolean positive = false;
    private boolean length_limited = false;
    public IntegerField field = this;
    private static String MAX_VALUE = new Integer(Integer.MAX_VALUE).toString();
    private static String MIN_VALUE = new Integer(Integer.MIN_VALUE).toString();
    private String origValue = null;

    public IntegerField(int columns) {
        super(columns);
        this.integerFormatter.setParseIntegerOnly(true);
    }

    public IntegerField(int value, int columns, int max_length) {
        this(columns);
        this.max_length = max_length;
        this.length_limited = true;
        this.setInitValue(value);
    }

    public IntegerField(boolean positive) {
        this(5);
        this.positive = positive;
    }

    public IntegerField(int max_length, boolean flag, boolean positive) {
        this(5);
        this.max_length = max_length;
        this.length_limited = flag;
        this.positive = positive;
    }

    public IntegerField(int max_length, boolean flag) {
        this(5);
        this.max_length = max_length;
        this.length_limited = flag;
    }

    public IntegerField(int value, int columns) {
        this(columns);
        super.setText(Integer.toString(value));
    }

    public IntegerField(int value, int columns, boolean positive) {
        this(columns);
        super.setText(Integer.toString(value));
        this.positive = positive;
    }

    public IntegerField() {
        this(5);
    }

    @Override
    public Object getValue() {
        int retVal = 0;
        try {
            String t = this.getText().trim();
            if (this.isOverFlow(t)) {
                System.out.println(t + " is over flow the int range");
                retVal = t.startsWith("-") ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            } else {
                retVal = this.integerFormatter.parse(t).intValue();
            }
        }
        catch (ParseException e) {
            return null;
        }
        return new Integer(retVal);
    }

    public boolean isOverFlow(String t) {
        if (t.startsWith("-")) {
            if (t.length() > MIN_VALUE.length()) {
                return true;
            }
            if (t.length() < MIN_VALUE.length()) {
                return false;
            }
            int size = t.length();
            for (int i = 0; i < size; ++i) {
                if (t.charAt(i) > MIN_VALUE.charAt(i)) {
                    return true;
                }
                if (t.charAt(i) >= MIN_VALUE.charAt(i)) continue;
                return false;
            }
        } else {
            if (t.length() > MAX_VALUE.length()) {
                return true;
            }
            if (t.length() < MAX_VALUE.length()) {
                return false;
            }
            int size = t.length();
            for (int i = 0; i < size; ++i) {
                if (t.charAt(i) > MAX_VALUE.charAt(i)) {
                    return true;
                }
                if (t.charAt(i) >= MAX_VALUE.charAt(i)) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isChanged() {
        String current = this.getText().trim();
        return this.origValue != null && this.origValue.compareTo(current) != 0 || this.origValue == null && current.length() > 0;
    }

    @Override
    public boolean isEmpty() {
        String txt = this.getText();
        return txt == null || txt.trim().length() <= 0;
    }

    public void setInitValue(int value) {
        this.setValue(value);
        this.origValue = Integer.toString(value);
    }

    @Override
    public void setInitValue(String value) {
        this.setValue(value);
        this.origValue = value;
    }

    public void setValue(int value) {
        this.setText(Integer.toString(value));
    }

    public void setValue(String value) {
        if (value != null && value.length() > 0) {
            try {
                Integer.parseInt(value.trim());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                return;
            }
        }
        this.setText(value);
    }

    @Override
    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    protected class IntegerDocument
    extends PlainDocument {
        private static final long serialVersionUID = -3570852090818430585L;

        protected IntegerDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String temp;
            if (str == null) {
                return;
            }
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            if (IntegerField.this.length_limited && (temp = IntegerField.this.field.getText()).length() + source.length > IntegerField.this.max_length) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            int length = result.length;
            for (int i = 0; i < length; ++i) {
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                if (!IntegerField.this.positive && offs == 0 && i == 0 && source[i] == '-') {
                    result[j++] = source[i];
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

