/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.GuiUt;
import dbaut.comp.DbaFileChooser;
import dbaut.comp.LockedJFileChooser;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FilePathField
extends JPanel {
    private static final long serialVersionUID = 6522048506071122157L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", LocaleManager.getLocale());
    private int LEN_FNAME = 255;
    DbaFileChooser chooser = null;
    String fileseparator = System.getProperty("file.separator");
    public CharField File_Path = new CharField(255, true);
    public JButton Browse_Button = new JButton();
    boolean isDirectorlyOnly = false;
    private Component parent_comp = null;
    private String button_text = null;
    private String default_dir = null;
    private boolean islocked = false;
    private FileFilter[] filter = null;
    ActionListener listener = null;
    KeyListener keyListener = null;

    public FilePathField(boolean isDirectoryOnly) {
        this(null, null, null, isDirectoryOnly, false, (FileFilter)null);
    }

    public FilePathField(boolean isDirectoryOnly, FileFilter[] filter) {
        this(null, null, null, isDirectoryOnly, false, filter);
    }

    public FilePathField(Component comp, boolean isDirectoryOnly, FileFilter afilter) {
        this(comp, null, null, isDirectoryOnly, false, afilter);
    }

    public FilePathField(Component comp, boolean isDirectoryOnly, FileFilter[] filter) {
        this(comp, null, null, isDirectoryOnly, false, filter);
    }

    public FilePathField(Component comp, String default_dir, String buttonText, boolean isDirectoryOnly) {
        this(comp, default_dir, buttonText, isDirectoryOnly, false, (FileFilter)null);
    }

    public FilePathField(Component comp, String default_dir, String buttonText, boolean isDirectoryOnly, int pLEN_FNAME) {
        this(comp, default_dir, buttonText, isDirectoryOnly, false, (FileFilter)null);
        if (pLEN_FNAME != 0) {
            this.LEN_FNAME = pLEN_FNAME;
        }
    }

    public FilePathField(Component comp, boolean isDirectoryOnly) {
        this(comp, null, null, isDirectoryOnly, false, (FileFilter)null);
    }

    public FilePathField(Component comp, String default_dir, String buttonText, boolean isDirectoryOnly, boolean islocked, FileFilter afilter) {
        this(comp, default_dir, buttonText, isDirectoryOnly, islocked, (FileFilter[])null);
        if (afilter != null) {
            this.filter = new FileFilter[1];
            this.filter[0] = afilter;
        }
    }

    public FilePathField(Component comp, String default_dir, String buttonText, boolean isDirectoryOnly, boolean islocked, FileFilter[] filter) {
        this.parent_comp = comp;
        this.default_dir = default_dir;
        this.button_text = buttonText;
        this.isDirectorlyOnly = isDirectoryOnly;
        this.islocked = islocked;
        this.filter = filter;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    @Override
    public void addKeyListener(KeyListener l) {
        this.keyListener = l;
    }

    private void jbInit() throws Exception {
        this.File_Path.setName("FilePathField");
        this.File_Path.setCaretPosition(0);
        this.setLayout(new BorderLayout());
        this.Browse_Button.setMargin(new Insets(2, 2, 2, 2));
        this.Browse_Button.setText("...");
        this.Browse_Button.setPreferredSize(new Dimension(22, 22));
        this.Browse_Button.setBorder(BorderFactory.createRaisedBevelBorder());
        this.Browse_Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePathField.this.Browse_Button_actionPerformed(e);
            }
        });
        this.File_Path.setBorder(null);
        this.File_Path.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    FilePathField.this.File_Path_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                FilePathField.this.File_Path_keyReleased(e);
            }
        });
        this.add((Component)this.File_Path, "Center");
        this.add((Component)this.Browse_Button, "East");
        if (this.islocked && this.default_dir == null) {
            this.Browse_Button.setEnabled(false);
        }
    }

    public void setTextBackground(Color color) {
        this.File_Path.setBackground(color);
    }

    public void setButtonText(String text) {
        this.button_text = text;
    }

    public JTextField getPathField() {
        return this.File_Path;
    }

    public void setText(String text) {
        this.File_Path.setText(text);
    }

    public String getText() {
        String textContent = this.File_Path.getText();
        return textContent;
    }

    public String getFileFilter() {
        String filterName = "";
        if (this.chooser != null) {
            filterName = this.chooser.getFileFilter().getDescription();
        }
        return filterName;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.File_Path.setEnabled(enable);
        this.Browse_Button.setEnabled(enable);
    }

    void Browse_Button_actionPerformed(ActionEvent e) {
        int state;
        this.chooser = this.islocked ? new LockedJFileChooser(this.default_dir) : new DbaFileChooser();
        if (this.filter != null) {
            int size = this.filter.length;
            for (int i = 0; i < size; ++i) {
                this.chooser.addChoosableFileFilter(this.filter[i]);
            }
        }
        this.chooser.setLocale(LocaleManager.getLocale());
        String path = this.File_Path.getText();
        if (path != null && path.length() > 0 && path.indexOf(this.fileseparator) > 0) {
            this.chooser.setCurrentDirectory(path);
        } else if (this.default_dir != null) {
            this.chooser.setCurrentDirectory(this.default_dir);
        } else {
            this.chooser.setCurrentDirectory(System.getProperty("user.dir"));
        }
        String filename = null;
        filename = this.File_Path.getText();
        if (filename != null && filename.length() > 0) {
            this.chooser.setSelectedFile(new File(filename));
        }
        if (this.isDirectorlyOnly) {
            this.chooser.setFileSelectionMode(1);
        }
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.setFileHidingEnabled(false);
        if (this.button_text == null) {
            this.button_text = this.res.getString("Open");
        }
        if ((state = this.chooser.showDialog(this.parent_comp, this.button_text)) != 0) {
            return;
        }
        File f = this.chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        if (f.getPath() == null) {
            return;
        }
        if (f.getPath().length() > this.LEN_FNAME - 1) {
            if (this.parent_comp != null) {
                GuiUt.showErrorDlg(this.parent_comp, "File path is longer than " + (this.LEN_FNAME - 1) + ".", null);
            } else {
                System.out.println("File path is longer than " + (this.LEN_FNAME - 1) + ".");
            }
        } else {
            if (this.isDirectorlyOnly) {
                this.File_Path.setText(f.getPath());
                this.File_Path.setCaretPosition(0);
            } else {
                String pathname = f.getParent();
                if (pathname.equals(this.default_dir)) {
                    this.File_Path.setText(f.getName());
                    this.File_Path.setCaretPosition(0);
                } else {
                    this.File_Path.setText(f.getPath());
                    this.File_Path.setCaretPosition(0);
                }
            }
            if (this.listener != null) {
                this.listener.actionPerformed(null);
            }
        }
    }

    void File_Path_keyReleased(KeyEvent e) {
        if (this.keyListener != null) {
            this.keyListener.keyReleased(e);
            return;
        }
        if (this.listener != null && e.getKeyCode() == 10) {
            this.listener.actionPerformed(null);
        }
    }
}

