/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.GuiUt;
import dbaut.text.TextField;
import dbaut.textField.DbaTextField;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DecimalField
extends TextField
implements DbaTextField {
    private static final long serialVersionUID = 4214436698023373371L;
    private DecimalFormat formatter = new DecimalFormat();

    public DecimalField(int precision, int scale) {
        this.formatter.setGroupingSize(0);
        this.formatter.setDecimalSeparatorAlwaysShown(false);
        this.formatter.setMaximumFractionDigits(scale);
        this.formatter.setMinimumFractionDigits(scale);
    }

    @Override
    public Object getValue() {
        String t = this.getText();
        try {
            Double.parseDouble(t);
        }
        catch (NumberFormatException e) {
            if (t.length() > 0) {
                Toolkit.getDefaultToolkit().beep();
                GuiUt.showErrorDlg(this, t + " can't be formatted as Double", null);
            }
            return null;
        }
        return t;
    }

    @Override
    protected Document createDefaultModel() {
        return new DoubleDocument();
    }

    @Override
    public void setInitValue(String value) {
        throw new UnsupportedOperationException("Method setInitValue() not yet implemented.");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Method isEmpty() not yet implemented.");
    }

    @Override
    public boolean isChanged() {
        throw new UnsupportedOperationException("Method isChanged() not yet implemented.");
    }

    protected class DoubleDocument
    extends PlainDocument {
        private static final long serialVersionUID = -178406346275069192L;

        protected DoubleDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int size = str.length();
            for (int i = 0; i < size; ++i) {
                if (Character.isDigit(str.charAt(i)) || str.charAt(i) == '.' || str.charAt(i) == '-' || str.charAt(i) == 'E' || str.charAt(i) == 'e') continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

