/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.textField.CalendarDialog;
import dbaut.textField.DateField2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateFieldWithChooser
extends JPanel {
    private JTextField dateField;
    private JButton openButton;
    private Date selectedDate;
    private SimpleDateFormat dateFormat;
    private final JDialog parent;

    public DateFieldWithChooser(JDialog parent) {
        this(parent, new BorderLayout());
    }

    public DateFieldWithChooser(final JDialog parent, LayoutManager layout) {
        super(layout);
        this.parent = parent;
        this.dateField = new DateField2();
        this.openButton = new JButton("...");
        this.dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarDialog calendarDialog = new CalendarDialog(parent);
                calendarDialog.setVisible(true);
                Date date = calendarDialog.getSelectedDate();
                if (date != null) {
                    DateFieldWithChooser.this.selectedDate = date;
                    DateFieldWithChooser.this.dateField.setText(DateFieldWithChooser.this.dateFormat.format(date));
                    DateFieldWithChooser.this.revalidate();
                    DateFieldWithChooser.this.repaint();
                }
            }
        });
        this.add((Component)this.dateField, "Center");
        this.add((Component)this.openButton, "East");
    }

    @Override
    public void setEnabled(boolean enable) {
        this.dateField.setEnabled(enable);
        this.dateField.setEditable(enable);
        this.openButton.setEnabled(enable);
    }

    public void setText(String txt) {
        this.dateField.setText(txt);
    }

    public String getText() {
        return this.dateField.getText();
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }
}

