/*
 * Decompiled with CFR 0.152.
 */
package dbaut.text;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class TextField
extends JTextField {
    private static final long serialVersionUID = 8105008030980391146L;
    UndoManager undoManager = new UndoManager();
    UndoHandler undoHandler = new UndoHandler();
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    KeyStroke undoKeystroke = KeyStroke.getKeyStroke(90, 2);
    KeyStroke redoKeystroke = KeyStroke.getKeyStroke(89, 2);

    public TextField() {
        this.setupUndoRedo();
    }

    public TextField(String text) {
        super(text);
        this.setupUndoRedo();
    }

    public TextField(int columns) {
        super(columns);
        this.setupUndoRedo();
    }

    public TextField(String text, int columns) {
        super(text, columns);
        this.setupUndoRedo();
    }

    public TextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.setupUndoRedo();
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void redo() {
        this.undoManager.redo();
    }

    public void setupUndoRedo() {
        this.getInputMap().put(this.undoKeystroke, "undoKeystroke");
        this.getActionMap().put("undoKeystroke", this.undoAction);
        this.getInputMap().put(this.redoKeystroke, "redoKeystroke");
        this.getActionMap().put("redoKeystroke", this.redoAction);
        this.getDocument().addUndoableEditListener(this.undoHandler);
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -731716311693118517L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextField.this.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                ex.printStackTrace();
            }
            this.update();
            TextField.this.undoAction.update();
        }

        protected void update() {
            if (TextField.this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", TextField.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 130221570602668519L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextField.this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.update();
            TextField.this.redoAction.update();
        }

        protected void update() {
            if (TextField.this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", TextField.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            TextField.this.undoManager.addEdit(e.getEdit());
            TextField.this.undoAction.update();
            TextField.this.redoAction.update();
        }
    }
}

