/*
 * Decompiled with CFR 0.152.
 */
package dbaut.system;

import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.dbalib;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class BackupFile {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", LocaleManager.getLocale());
    private short backup_type;
    private String backup_path;
    private static String fileseparator = System.getProperty("file.separator");
    public String copyFileErrorMessage = "";

    public BackupFile(String path, short type) {
        this.backup_path = path;
        this.backup_type = type;
    }

    public BackupFile() {
    }

    public static void makeDir(String name) {
        int index = name.lastIndexOf(fileseparator);
        if (index < 0) {
            return;
        }
        String path = new String(name.substring(0, index));
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFile(String source, String dest) {
        boolean bl;
        if (dest.trim().endsWith(".gz")) {
            return dbalib.utZipToFile(source, dest) == 0;
        }
        BackupFile.makeDir(dest);
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buff = new byte[1024];
            int read = in.read(buff);
            while (read >= 0) {
                out.write(buff, 0, read);
                read = in.read(buff);
            }
            in.close();
            out.close();
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                this.copyFileErrorMessage = e.getMessage();
                bl2 = false;
            }
            catch (Throwable throwable) {
                DbaObject.close(in);
                DbaObject.close(out);
                throw throwable;
            }
            DbaObject.close(in);
            DbaObject.close(out);
            return bl2;
        }
        DbaObject.close(in);
        DbaObject.close(out);
        return bl;
    }

    public boolean copyFile(String logical_name, String source, String dest, Component frame) {
        File f;
        if (source.length() <= 0) {
            String s = this.res.getString("source_file_is_required");
            String[] sa = new String[]{source};
            s = GuiUt.mapStringForProperty(s, sa);
            GuiUt.showErrorDlg(frame, s, null);
            return false;
        }
        if (dest.length() <= 0) {
            String s = this.res.getString("dest_file_is_required");
            String[] sa = new String[]{dest};
            s = GuiUt.mapStringForProperty(s, sa);
            GuiUt.showErrorDlg(frame, s, null);
            return false;
        }
        if (logical_name != null && (f = new File(dest)).exists()) {
            GuiUt.showErrorDlg(frame, "Destination file is existing.", null);
            return false;
        }
        if (dest.trim().endsWith(".gz")) {
            return dbalib.utZipToFile(source, dest) == 0;
        }
        BackupFile.makeDir(dest);
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buff = new byte[1024];
            int read = in.read(buff);
            while (read >= 0) {
                out.write(buff, 0, read);
                read = in.read(buff);
            }
            in.close();
            out.close();
            if (logical_name == null) {
                return true;
            }
            return true;
        }
        catch (IOException e) {
            DbaObject.close(in);
            DbaObject.close(out);
            this.copyFileErrorMessage = e.getMessage();
            return false;
        }
    }

    public boolean copyFile(String logical_name, String source, String dest) {
        return this.copyFile(logical_name, source, dest, null);
    }

    public static boolean copy(String source, String dest) {
        if (source.length() <= 0) {
            System.out.println("source file is required.");
            return false;
        }
        if (dest.length() <= 0) {
            System.out.println("destination file is required.");
            return false;
        }
        File f = new File(dest);
        if (f.exists()) {
            f.delete();
        }
        f = null;
        BackupFile.makeDir(dest);
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buff = new byte[1024];
            int read = in.read(buff);
            while (read >= 0) {
                out.write(buff, 0, read);
                read = in.read(buff);
            }
            in.close();
            out.close();
            return true;
        }
        catch (IOException e) {
            DbaObject.close(in);
            DbaObject.close(out);
            System.out.println(e.getMessage());
            return false;
        }
    }
}

