/*
 * Decompiled with CFR 0.152.
 */
package dbaut.editorPanel;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.WrappedPlainView;

public class ColorView
extends WrappedPlainView {
    public static Hashtable<String, Color> keywords = new Hashtable();
    public static Color STRING_LITERAL_COLOR = new Color(0, 120, 0);
    public static Color COMMENT_COLOR = new Color(1, 152, 88);
    private boolean in_single_quote = false;
    private boolean in_double_quote = false;
    private boolean in_comment = false;

    public ColorView(Element e) {
        super(e);
    }

    public ColorView(Element e, boolean wordWrap) {
        super(e, wordWrap);
    }

    private int tokenizer(Graphics g, Segment line, int x, int y) {
        StringTokenizer str = new StringTokenizer(line.toString(), " ;=><()',\n\"", true);
        int offset = 0;
        Color c = null;
        String t = null;
        while (str.hasMoreTokens()) {
            t = str.nextToken();
            if (this.in_comment) {
                if (t.equals("\n")) {
                    this.in_comment = false;
                }
                c = COMMENT_COLOR;
            } else if (this.in_double_quote) {
                if (t.equals("\"")) {
                    this.in_double_quote = false;
                }
                c = Color.black;
            } else if (this.in_single_quote) {
                if (t.equals("'")) {
                    this.in_single_quote = false;
                }
                c = STRING_LITERAL_COLOR;
            } else if (t.startsWith("--")) {
                this.in_comment = true;
                c = COMMENT_COLOR;
            } else if (t.equals("\"")) {
                this.in_double_quote = true;
                c = Color.BLACK;
            } else if (t.equals("'")) {
                this.in_single_quote = true;
                c = STRING_LITERAL_COLOR;
            } else if (this.in_single_quote) {
                c = STRING_LITERAL_COLOR;
            } else {
                c = keywords.get(t.toUpperCase());
                if (c == null) {
                    c = Color.black;
                }
            }
            g.setColor(c);
            line.count = t.length();
            x = Utilities.drawTabbedText(line, x, y, g, (TabExpander)this, offset);
            line.offset += t.length();
            offset += t.length();
        }
        return x;
    }

    @Override
    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        if (p0 == 0) {
            this.in_single_quote = false;
            this.in_double_quote = false;
            this.in_comment = false;
        }
        Segment line = new Segment();
        this.getDocument().getText(p0, p1 - p0, line);
        x = this.tokenizer(g, line, x, y);
        return x;
    }

    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        try {
            Segment line = new Segment();
            Element lineElement = this.getElement().getElement(lineIndex);
            int start = lineElement.getStartOffset();
            int end = lineElement.getEndOffset();
            this.getDocument().getText(start, end - (start + 1), line);
            this.tokenizer(g, line, x, y);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public static boolean isKeyword(String s) {
        Color c = keywords.get(s.toUpperCase());
        return c != null;
    }

    private static void initColors() {
        keywords = new Hashtable();
        keywords.put("AUTHORIZATION", Color.blue);
        keywords.put("AUTO", Color.blue);
        keywords.put("ABORT", Color.blue);
        keywords.put("ACL", Color.blue);
        keywords.put("ACTION", Color.blue);
        keywords.put("ADD", Color.blue);
        keywords.put("AFTER", Color.blue);
        keywords.put("ALL", Color.blue);
        keywords.put("ALLOW", Color.blue);
        keywords.put("ALTER", Color.blue);
        keywords.put("AND", Color.blue);
        keywords.put("ANY", Color.blue);
        keywords.put("AS", Color.blue);
        keywords.put("ASC", Color.blue);
        keywords.put("ASYNC", Color.blue);
        keywords.put("AT", Color.blue);
        keywords.put("AUTOEXTEND", Color.blue);
        keywords.put("AUTOCOMMIT", Color.blue);
        keywords.put("AVG", Color.blue);
        keywords.put("BACKUP", Color.blue);
        keywords.put("BASIC", Color.blue);
        keywords.put("BEFORE", Color.blue);
        keywords.put("BEGIN", Color.blue);
        keywords.put("BETWEEN", Color.blue);
        keywords.put("BIGINT", Color.BLUE);
        keywords.put("BINARY", Color.blue);
        keywords.put("BIT", Color.blue);
        keywords.put("BLOB", Color.blue);
        keywords.put("BLOCK", Color.blue);
        keywords.put("BOOLEAN", Color.blue);
        keywords.put("BROWSE", Color.blue);
        keywords.put("BUILTIN", Color.blue);
        keywords.put("BULK", Color.blue);
        keywords.put("BY", Color.blue);
        keywords.put("CALL", Color.blue);
        keywords.put("CASCADE", Color.blue);
        keywords.put("CASE", Color.blue);
        keywords.put("CASECONTAIN", Color.blue);
        keywords.put("CASEMATCH", Color.blue);
        keywords.put("CAST", Color.blue);
        keywords.put("CATALOG", Color.blue);
        keywords.put("CHAR", Color.blue);
        keywords.put("CHARACTER", Color.blue);
        keywords.put("CHECK", Color.blue);
        keywords.put("CHECKPOINT", Color.blue);
        keywords.put("CLEAR", Color.blue);
        keywords.put("CLOB", Color.blue);
        keywords.put("CLOSE", Color.blue);
        keywords.put("CLUSTER", Color.blue);
        keywords.put("CLUSTERING", Color.blue);
        keywords.put("COLD", Color.blue);
        keywords.put("COLUMN", Color.blue);
        keywords.put("COLUMNS", Color.blue);
        keywords.put("COMMAND", Color.blue);
        keywords.put("COMMENT", Color.blue);
        keywords.put("COMMIT", Color.blue);
        keywords.put("COMPRESS", Color.blue);
        keywords.put("CONNECT", Color.blue);
        keywords.put("CONNECTION", Color.blue);
        keywords.put("CONSTRAINT", Color.blue);
        keywords.put("CONTAIN", Color.blue);
        keywords.put("CONTINUE", Color.blue);
        keywords.put("COUNT", Color.blue);
        keywords.put("CREATE", Color.blue);
        keywords.put("CURRENT", Color.blue);
        keywords.put("CURSOR", Color.blue);
        keywords.put("DATA", Color.blue);
        keywords.put("DATABASE", Color.blue);
        keywords.put("DATAFILE", Color.blue);
        keywords.put("DATE", Color.blue);
        keywords.put("DAYS", Color.blue);
        keywords.put("DB", Color.blue);
        keywords.put("DBA", Color.blue);
        keywords.put("DEBUG", Color.blue);
        keywords.put("DEC", Color.blue);
        keywords.put("DECIMAL", Color.blue);
        keywords.put("DECLARE", Color.blue);
        keywords.put("DEFAULT", Color.blue);
        keywords.put("DEFINITION", Color.blue);
        keywords.put("DELETE", Color.blue);
        keywords.put("DESC", Color.blue);
        keywords.put("DESCRIBE", Color.blue);
        keywords.put("DESCRIPTOR", Color.blue);
        keywords.put("DISABLE", Color.blue);
        keywords.put("DISCONNECT", Color.blue);
        keywords.put("DISTINCT", Color.blue);
        keywords.put("DOMAIN", Color.blue);
        keywords.put("DOUBLE", Color.blue);
        keywords.put("DROP", Color.blue);
        keywords.put("DUAL", Color.blue);
        keywords.put("EACH", Color.blue);
        keywords.put("ENABLE", Color.blue);
        keywords.put("END", Color.blue);
        keywords.put("ERROR", Color.blue);
        keywords.put("ESCAPE", Color.blue);
        keywords.put("EVERY", Color.blue);
        keywords.put("EXCLUSIVE", Color.blue);
        keywords.put("EXEC", Color.blue);
        keywords.put("EXECUTE", Color.blue);
        keywords.put("EXISTS", Color.blue);
        keywords.put("EXTENDED", Color.blue);
        keywords.put("EXPRESS", Color.blue);
        keywords.put("FETCH", Color.blue);
        keywords.put("FILE", Color.blue);
        keywords.put("FILLFACTOR", Color.blue);
        keywords.put("FLOAT", Color.blue);
        keywords.put("FLUSH", Color.blue);
        keywords.put("FOR", Color.blue);
        keywords.put("FOREIGN", Color.blue);
        keywords.put("FOUND", Color.blue);
        keywords.put("FROM", Color.blue);
        keywords.put("FUNCTION", Color.blue);
        keywords.put("GIVE", Color.blue);
        keywords.put("GO", Color.blue);
        keywords.put("GOTO", Color.blue);
        keywords.put("GRANT", Color.blue);
        keywords.put("GROUP", Color.blue);
        keywords.put("HAVING", Color.blue);
        keywords.put("IDENTIFIED", Color.blue);
        keywords.put("IGNORE", Color.blue);
        keywords.put("IMMEDIATE", Color.blue);
        keywords.put("IN", Color.blue);
        keywords.put("INCLUDE", Color.blue);
        keywords.put("INCREMENTAL", Color.blue);
        keywords.put("INDEX", Color.blue);
        keywords.put("INFORMIX", Color.blue);
        keywords.put("INHERIT", Color.blue);
        keywords.put("INPUT", Color.blue);
        keywords.put("INSERT", Color.blue);
        keywords.put("INT", Color.blue);
        keywords.put("INTEGER", Color.blue);
        keywords.put("INTERNAL", Color.blue);
        keywords.put("INTO", Color.blue);
        keywords.put("IVF", Color.blue);
        keywords.put("IS", Color.blue);
        keywords.put("JOIN", Color.blue);
        keywords.put("JOURNAL", Color.blue);
        keywords.put("KEY", Color.blue);
        keywords.put("KILL", Color.blue);
        keywords.put("LEFT", Color.blue);
        keywords.put("LENGTH", Color.blue);
        keywords.put("LIKE", Color.blue);
        keywords.put("LINK", Color.blue);
        keywords.put("LOAD", Color.blue);
        keywords.put("LOCK", Color.blue);
        keywords.put("LONG", Color.blue);
        keywords.put("MATCH", Color.blue);
        keywords.put("MAX", Color.blue);
        keywords.put("MICROSOFT", Color.blue);
        keywords.put("MIN", Color.blue);
        keywords.put("MIXED", Color.blue);
        keywords.put("MODE", Color.blue);
        keywords.put("MODIFY", Color.blue);
        keywords.put("MODULE", Color.blue);
        keywords.put("MONEY", Color.blue);
        keywords.put("MOVE", Color.blue);
        keywords.put("NAME", Color.blue);
        keywords.put("NCHAR", Color.blue);
        keywords.put("NCLOB", Color.blue);
        keywords.put("NEW", Color.blue);
        keywords.put("NO", Color.blue);
        keywords.put("NOCACHE", Color.blue);
        keywords.put("NOT", Color.blue);
        keywords.put("NOW", Color.blue);
        keywords.put("NULL", Color.blue);
        keywords.put("NUMERIC", Color.blue);
        keywords.put("NVARCHAR", Color.blue);
        keywords.put("OBJECT", Color.blue);
        keywords.put("OF", Color.blue);
        keywords.put("OFF", Color.blue);
        keywords.put("OID", Color.blue);
        keywords.put("OLD", Color.blue);
        keywords.put("ON", Color.blue);
        keywords.put("ONLY", Color.blue);
        keywords.put("OPEN", Color.blue);
        keywords.put("OPTION", Color.blue);
        keywords.put("OR", Color.blue);
        keywords.put("ORACLE", Color.blue);
        keywords.put("ORDER", Color.blue);
        keywords.put("OUT", Color.blue);
        keywords.put("OUTER", Color.blue);
        keywords.put("OUTPUT", Color.blue);
        keywords.put("PAGE", Color.blue);
        keywords.put("PAGES", Color.blue);
        keywords.put("PARSE", Color.blue);
        keywords.put("PASSWORD", Color.blue);
        keywords.put("PATH", Color.blue);
        keywords.put("PLAN", Color.blue);
        keywords.put("PRECISION", Color.blue);
        keywords.put("PREPARE", Color.blue);
        keywords.put("PRESERVE", Color.blue);
        keywords.put("PRIMARY", Color.blue);
        keywords.put("PRIVATE", Color.blue);
        keywords.put("PRIVILEGES", Color.blue);
        keywords.put("PROC", Color.blue);
        keywords.put("PROCEDURE", Color.blue);
        keywords.put("PROJECT", Color.blue);
        keywords.put("PUBLIC", Color.blue);
        keywords.put("READ", Color.blue);
        keywords.put("REAL", Color.blue);
        keywords.put("REBUILD", Color.blue);
        keywords.put("RECOVER", Color.blue);
        keywords.put("REFERENCE", Color.blue);
        keywords.put("REFERENCES", Color.blue);
        keywords.put("REFERENCING", Color.blue);
        keywords.put("REINDEX", Color.blue);
        keywords.put("REMOVE", Color.blue);
        keywords.put("REPAIR", Color.blue);
        keywords.put("REPLACE", Color.blue);
        keywords.put("REPLICATE", Color.blue);
        keywords.put("REPLICATION", Color.blue);
        keywords.put("RESET", Color.blue);
        keywords.put("RESIGNATURE", Color.blue);
        keywords.put("RESOURCE", Color.blue);
        keywords.put("RESTRICT", Color.blue);
        keywords.put("RESUME", Color.blue);
        keywords.put("RETRY", Color.blue);
        keywords.put("RETURNS", Color.blue);
        keywords.put("REVOKE", Color.blue);
        keywords.put("ROLLBACK", Color.blue);
        keywords.put("ROW", Color.blue);
        keywords.put("RUN", Color.blue);
        keywords.put("SAMPLE", Color.blue);
        keywords.put("SAVEPOINT", Color.blue);
        keywords.put("SCHEDULE", Color.blue);
        keywords.put("SECONDS", Color.blue);
        keywords.put("SECTION", Color.blue);
        keywords.put("SELECT", Color.blue);
        keywords.put("SEQ", Color.blue);
        keywords.put("SEQUENTIAL", Color.blue);
        keywords.put("SERIAL", Color.blue);
        keywords.put("BIGSERIAL", Color.blue);
        keywords.put("SERVER", Color.blue);
        keywords.put("SET", Color.blue);
        keywords.put("SHARE", Color.blue);
        keywords.put("SHRINK", Color.blue);
        keywords.put("SIGNATURE", Color.blue);
        keywords.put("SIZE", Color.blue);
        keywords.put("SMALLINT", Color.blue);
        keywords.put("SOME", Color.blue);
        keywords.put("SQLCA", Color.blue);
        keywords.put("SQLDA", Color.blue);
        keywords.put("SQLERROR", Color.blue);
        keywords.put("SQLWARNING", Color.blue);
        keywords.put("START", Color.blue);
        keywords.put("STATEMENT", Color.blue);
        keywords.put("STATIC", Color.blue);
        keywords.put("STATISTICS", Color.blue);
        keywords.put("STATUS", Color.blue);
        keywords.put("STOP", Color.blue);
        keywords.put("STORAGE", Color.blue);
        keywords.put("STRING", Color.blue);
        keywords.put("SUM", Color.blue);
        keywords.put("SUSPEND", Color.blue);
        keywords.put("SYBASE", Color.blue);
        keywords.put("SYNC", Color.blue);
        keywords.put("SYNCHRONIZE", Color.blue);
        keywords.put("SYNONYM", Color.blue);
        keywords.put("SYSDBA", Color.blue);
        keywords.put("SYSTEM", Color.blue);
        keywords.put("TABLE", Color.blue);
        keywords.put("TABLESPACE", Color.blue);
        keywords.put("TEMP", Color.blue);
        keywords.put("TEMPORARY", Color.blue);
        keywords.put("TERMINATE", Color.blue);
        keywords.put("TEXT", Color.blue);
        keywords.put("TIME", Color.blue);
        keywords.put("TIMES", Color.blue);
        keywords.put("TIMESTAMP", Color.blue);
        keywords.put("TO", Color.blue);
        keywords.put("TOTAL", Color.blue);
        keywords.put("TRANSFER", Color.blue);
        keywords.put("TRIGGER", Color.blue);
        keywords.put("TRUNCATEONLY", Color.blue);
        keywords.put("TYPE", Color.blue);
        keywords.put("UNION", Color.blue);
        keywords.put("UNIQUE", Color.blue);
        keywords.put("UNLOAD", Color.blue);
        keywords.put("UPDATE", Color.blue);
        keywords.put("USER", Color.blue);
        keywords.put("USING", Color.blue);
        keywords.put("VALUE", Color.blue);
        keywords.put("VALUES", Color.blue);
        keywords.put("VARBINARY", Color.blue);
        keywords.put("VARCHAR", Color.blue);
        keywords.put("VARYING", Color.blue);
        keywords.put("VIEW", Color.blue);
        keywords.put("WAIT", Color.blue);
        keywords.put("WARM", Color.blue);
        keywords.put("WHEN", Color.blue);
        keywords.put("WHENEVER", Color.blue);
        keywords.put("WHERE", Color.blue);
        keywords.put("WIDTH", Color.blue);
        keywords.put("WITH", Color.blue);
        keywords.put("WORK", Color.blue);
        keywords.put("ENCRYPT", Color.blue);
        keywords.put("DECRYPT", Color.blue);
        keywords.put(";", Color.red);
        keywords.put("'", STRING_LITERAL_COLOR);
        keywords.put("(", Color.red);
        keywords.put(")", Color.red);
        keywords.put("=", Color.red);
        keywords.put(">", Color.red);
        keywords.put("<", Color.red);
        keywords.put("*", Color.red);
    }

    static {
        ColorView.initColors();
    }
}

