/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import javax.swing.JTree;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DbaTree
extends JTree
implements LocaleChangeListener {
    private static final long serialVersionUID = -95424080309712158L;
    private DefaultTreeModel model = null;

    public DbaTree(DefaultTreeModel model) {
        super(model);
        this.model = model;
    }

    public void finalize() throws Throwable {
        LocaleManager.getLocaleManager().removeLocaleChangeListener(this);
        super.finalize();
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        TreePath path = this.getSelectionPath();
        this.model.reload();
        this.setSelectionPath(path);
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        int max = this.getRowCount();
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (startingRow < 0 || startingRow >= max) {
            throw new IllegalArgumentException();
        }
        prefix = prefix.toUpperCase();
        int increment = bias == Position.Bias.Forward ? 1 : -1;
        int row = startingRow;
        do {
            TreePath path;
            String text;
            if (!(text = this.convertValueToText((path = this.getPathForRow(row)).getLastPathComponent(), this.isRowSelected(row), this.isExpanded(row), true, row, false)).toUpperCase().contains(prefix)) continue;
            return path;
        } while ((row = (row + increment + max) % max) != startingRow);
        return null;
    }

    @Override
    public void setSelectionPath(TreePath path) {
        super.setSelectionPath(path);
        this.requestFocus(true);
    }
}

