/*
 * Decompiled with CFR 0.152.
 */
package dbaut.boundaryValue;

import dbaut.boundaryValue.BoundaryItem;
import java.sql.Timestamp;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BoundaryDate
extends BoundaryItem {
    public static Format format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    public static Format dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static Format timeFormat = new SimpleDateFormat("HH:mm:ss");
    private Date maxValue = null;
    private Date minValue = null;
    private Date defaultValue = null;
    private boolean canBeNull = false;

    public BoundaryDate(String strMin, String strMax, String strDefault, boolean canBeNull) throws ParseException {
        this.setType(ITEM_TYPE_DATE);
        if (strMax != null && strMax.trim().length() != 0) {
            this.maxValue = (Date)format.parseObject(strMax);
        }
        if (strMin != null && strMin.trim().length() != 0) {
            this.minValue = (Date)format.parseObject(strMin);
        }
        if (strDefault != null && strDefault.trim().length() != 0) {
            this.defaultValue = (Date)format.parseObject(strDefault);
        }
        this.setCanBeNull(canBeNull);
    }

    public Date getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Date maxValue) {
        this.maxValue = maxValue;
    }

    public Date getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Date minValue) {
        this.minValue = minValue;
    }

    public boolean isCanBeNull() {
        return this.canBeNull;
    }

    public void setCanBeNull(boolean canBeNull) {
        this.canBeNull = canBeNull;
    }

    public void setDefaultValue(Timestamp defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Date getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean checkValue(Object value) {
        boolean x_ret = false;
        try {
            Date dtValue = (Date)value;
            if (dtValue != null) {
                if (this.minValue.getTime() <= dtValue.getTime() && dtValue.getTime() <= this.maxValue.getTime()) {
                    x_ret = true;
                }
            } else if (this.canBeNull) {
                x_ret = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return x_ret;
    }

    public String getMaxDate() {
        String x_ret = null;
        if (this.maxValue != null) {
            x_ret = dateFormat.format(this.maxValue);
        }
        return x_ret;
    }

    public String getMinDate() {
        String x_ret = null;
        if (this.minValue != null) {
            x_ret = dateFormat.format(this.minValue);
        }
        return x_ret;
    }

    public String getDefaultDate() {
        String x_ret = null;
        if (this.defaultValue != null) {
            x_ret = dateFormat.format(this.defaultValue);
        }
        return x_ret;
    }

    public String getMaxTime() {
        String x_ret = null;
        if (this.maxValue != null) {
            x_ret = timeFormat.format(this.maxValue);
        }
        return x_ret;
    }

    public String getMinTime() {
        String x_ret = null;
        if (this.minValue != null) {
            x_ret = timeFormat.format(this.minValue);
        }
        return x_ret;
    }

    public String getDefaultTime() {
        String x_ret = null;
        if (this.defaultValue != null) {
            x_ret = timeFormat.format(this.defaultValue);
        }
        return x_ret;
    }

    @Override
    public Object getDefault() {
        return this.defaultValue;
    }

    @Override
    public String toString() {
        return "max Value: " + this.maxValue + " min Value: " + this.minValue;
    }
}

