/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.DbaUtDef;
import dbaut.FullBackupFile;
import dbaut.GuiUt;
import dbaut.IncBackupFile;
import dbaut.dbalib;
import java.awt.Component;
import java.util.Vector;

public class JBackupHistory {
    public static final String READ_ONLY = "0";
    public static final String WRITABLE = "1";
    public static final int BKTYP_OFF_LINE_FULL_BACKUP = 1;
    public static final int BKTYP_OFF_LINE_DIFF_BACKUP = 2;
    public static final int BKTYP_ON_LINE_FULL_BACKUP = 3;
    public static final int BKTYP_ON_LINE_DIFF_BACKUP = 4;
    public static final int BKTYP_INC_BACKUP = 5;
    public static final int BKTYP_INC_BACKUP_JOURNAL_FULL = 6;
    public static final int BKTYP_INC_BACKUP_TIME_EXPIRED = 7;
    public static final int BKTYP_INC_BACKUP_USER = 8;
    public static final int BACKUP_NONE = 0;
    public static final int BACKUP_BEGIN = 1;
    public static final int BACKUP_END = 2;
    public static final int FULL_BACKUP = 1;
    public static final int DIFF_BACKUP = 0;
    private static final int LEN_FNAME = 256;
    private long[] handle = null;
    private dbalib cfun = new dbalib();
    private Component comp = null;

    public JBackupHistory(Component comp) {
        this.comp = comp;
    }

    public String FilePath(String dbname, String backupfile, String backupflag) {
        byte[] filepath = new byte[1024];
        int rc = this.cfun.BackupHistoryFilePath(dbname.getBytes(), backupfile.getBytes(), backupflag.getBytes(), filepath);
        return new String(filepath).trim();
    }

    public int FileOpen(String dbname, String backupfile, String backupflag) {
        this.handle = new long[2];
        int rc = this.cfun.OpenBackupHistory(this.handle, dbname.getBytes(), backupfile.getBytes(), backupflag.getBytes());
        if (rc != 0) {
            System.out.println("OpenBackupHistory failed :" + rc);
            GuiUt.showErrorDlg(this.comp, "Open history file \"" + backupfile + "\" for database \"" + dbname + "\" failed!", "");
            this.handle = null;
        }
        return rc;
    }

    public int FileClose() {
        if (this.handle == null) {
            return -1;
        }
        int rc = this.cfun.CloseBackupHistory(this.handle);
        if (rc != 0) {
            System.out.println("CloseBackupHistory failed :" + rc);
        }
        this.handle = null;
        return rc;
    }

    public Vector getFullBackupList() {
        byte[] buff;
        if (this.handle == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int[] totalnum = new int[1];
        int rc = this.cfun.GetFullBackupList(this.handle, totalnum);
        if (rc != 0) {
            System.out.println("GetFullBackupList failed :" + rc);
            return null;
        }
        for (int i = 1; i <= totalnum[0] && (rc = this.cfun.GetFullBackupListInfo(this.handle, i, buff = new byte[1024])) == 0; ++i) {
            v.addElement(new String(buff));
        }
        return v;
    }

    public Vector getDiffBackupList() {
        byte[] buff;
        if (this.handle == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int[] totalnum = new int[1];
        int rc = this.cfun.GetDiffBackupList(this.handle, totalnum);
        if (rc != 0) {
            System.out.println("GetDiffBackupList failed :" + rc);
            return null;
        }
        for (int i = 1; i <= totalnum[0] && (rc = this.cfun.GetDiffBackupListInfo(this.handle, i, buff = new byte[1024])) == 0; ++i) {
            v.addElement(new String(buff).trim());
        }
        return v;
    }

    public Vector getFullBackupInfo(int index) {
        byte[] backfile;
        byte[] logfile;
        byte[] dbfile;
        int rc;
        if (this.handle == null) {
            return null;
        }
        Vector<FullBackupFile> v = new Vector<FullBackupFile>();
        FullBackupFile file = null;
        while ((rc = this.cfun.GetFullBackupData(this.handle, index, dbfile = new byte[256], logfile = new byte[256], backfile = new byte[256])) == DbaUtDef.RTN_OK) {
            String logicalFileStr = new String(logfile);
            String backFileStr = new String(backfile);
            String phyFileStr = new String(dbfile);
            file = new FullBackupFile(logicalFileStr, backFileStr, phyFileStr);
            v.addElement(file);
        }
        return v;
    }

    public Vector getDiffBackupInfo(int index) {
        byte[] backfile;
        byte[] logfile;
        byte[] dbfile;
        int rc;
        if (this.handle == null) {
            return null;
        }
        Vector<FullBackupFile> v = new Vector<FullBackupFile>();
        FullBackupFile file = null;
        while ((rc = this.cfun.GetDiffBackupData(this.handle, index, dbfile = new byte[256], logfile = new byte[256], backfile = new byte[256])) == DbaUtDef.RTN_OK) {
            String logicalFileStr = new String(logfile);
            String backFileStr = new String(backfile);
            String phyFileStr = new String(dbfile);
            file = new FullBackupFile(logicalFileStr, backFileStr, phyFileStr);
            v.addElement(file);
        }
        return v;
    }

    @Deprecated
    public Vector getIncBackupInfo(int bkid, String btime) {
        int rc;
        if (this.handle == null) {
            return null;
        }
        Vector<IncBackupFile> v = new Vector<IncBackupFile>();
        byte[] buff = new byte[256];
        byte[] timebuff = new byte[256];
        while ((rc = this.cfun.GetIncBackupData(this.handle, ++bkid, btime.getBytes(), buff, timebuff)) == 0) {
            IncBackupFile file = new IncBackupFile(bkid, new String(buff), new String(timebuff));
            v.addElement(file);
        }
        return v;
    }

    public Vector getIncBackupInfoFromHead() {
        int rc;
        if (this.handle == null) {
            return null;
        }
        Vector<IncBackupFile> v = new Vector<IncBackupFile>();
        long[] bkid = new long[1];
        byte[] fileBuff = new byte[256];
        byte[] timeBuff = new byte[256];
        byte[] incItemBuff = new byte[1024];
        while ((rc = this.cfun.GetNextIncDataFromHead(this.handle, bkid, fileBuff, timeBuff, incItemBuff)) == 0) {
            IncBackupFile file = new IncBackupFile(bkid[0], new String(fileBuff), new String(timeBuff), new String(incItemBuff));
            v.addElement(file);
        }
        return v;
    }

    public Vector getIncBackupInfo(int index, int fgFull) {
        int rc;
        if (this.handle == null) {
            return null;
        }
        Vector<IncBackupFile> v = new Vector<IncBackupFile>();
        long[] bkid = new long[1];
        byte[] fileBuff = new byte[256];
        byte[] timeBuff = new byte[256];
        byte[] incItemBuff = new byte[1024];
        while ((rc = this.cfun.GetNextIncData(this.handle, index, fgFull, bkid, fileBuff, timeBuff, incItemBuff)) == 0) {
            IncBackupFile file = new IncBackupFile(bkid[0], new String(fileBuff), new String(timeBuff), new String(incItemBuff));
            v.addElement(file);
        }
        return v;
    }

    public int appendBKItem(String incItem) {
        if (this.handle == null) {
            return -1;
        }
        int rc = this.cfun.AppendBKData(this.handle, incItem.getBytes());
        return rc;
    }

    public int removeBackupSequence(String hisFileName, long resBKId, byte[] errMsg) {
        int rc = this.cfun.RemoveBackupSequence(hisFileName.getBytes(), resBKId, errMsg);
        return rc;
    }

    public int setBackupData(int backup_id, int backup_type, String db_file, String log_file, String backup_file, int flag) {
        if (this.handle == null) {
            return -1;
        }
        int rc = this.cfun.SetBackupData(this.handle, backup_id, backup_type, db_file.getBytes(), log_file.getBytes(), backup_file.getBytes(), flag);
        if (rc != 0) {
            System.out.println("SetBackupData failed :" + rc);
        }
        return rc;
    }
}

