/*
 * Decompiled with CFR 0.152.
 */
package dbatool.View;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import wizard.view.Wizard_view;

public class ViewList
extends DbaTabbedPane
implements ComponentPrivilege {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DbaTableModel model = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table1 = null;
    private DbaButton View_Create_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "View_Create_Button_actionPerformed"));
    private DbaButton View_Drop_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "View_Drop_Button_actionPerformed"));

    public ViewList() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("ViewsTabbedPane");
        this.View_Drop_Button.setName("DropButton");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "view.list");
        jPanel1.setName("ViewsPanel");
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setName("ViewsButtonPanel");
        String[] columnNames = new String[]{this.res.getString("Schema_Name_Big"), this.res.getString("Name"), this.res.getString("Creation_Time"), this.res.getString("Status")};
        this.model = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.table1 = new JTable(this.absModel);
        this.table1.setName("ViewsTable");
        jPanel1.setLayout(new BorderLayout());
        this.View_Create_Button.setName("CreateButton");
        this.table1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ViewList.this.table1_mouseClicked(e);
            }
        });
        this.add((Component)jPanel1, this.res.getTitle("Views"));
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.View_Create_Button, null);
        jPanel2.add((Component)this.View_Drop_Button, null);
        jPanel1.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        this.getViewList();
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
    }

    @Override
    public int getComponentType() {
        return 2;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.View_Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.View_Drop_Button.setEnabled(enabled);
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.table1.getSelectedRow();
            Object value = this.table1.getValueAt(r, 0);
            String owner = (String)value;
            if (owner.compareTo("SYSTEM") == 0) {
                this.View_Drop_Button.setEnabled(false);
            } else {
                this.authority.authorise(owner);
            }
        }
    }

    private void getViewList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            boolean insystbl = DbFrame.frame.treePanel.getOption("INSYSTBL");
            String query = "select tb.TABLE_OWNER, tb.TABLE_NAME, v.STATUS, DWTOSTR(tb.CREATE_TIME) ";
            query = insystbl ? query + "from SYSTEM.SYSTABLE tb, SYSTEM.SYSVIEWDATA v " + "where tb.TABLE_TYPE in ('VIEW','SYSTEM VIEW') " + "and tb.TABLE_NAME = v.VIEW_NAME " + "and tb.TABLE_OWNER = v.VIEW_OWNER " + "ORDER BY tb.TABLE_TYPE, TABLE_OWNER, TABLE_NAME" : query + "from SYSTEM.SYSTABLE tb, SYSTEM.SYSVIEWDATA v " + "where tb.TABLE_TYPE = 'VIEW' " + "and tb.TABLE_NAME = v.VIEW_NAME " + "and tb.TABLE_OWNER = v.VIEW_OWNER " + "ORDER BY tb.TABLE_TYPE, TABLE_OWNER, TABLE_NAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.model.addValue(new DBARowInfo(this.getRowInfo(GuiUt.rightTrim(rs.getString(1)), rs.getString(2), rs.getString(4), rs.getShort(3))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(this.res.getString("The_number_of_views_is"), Integer.toString(this.model.getRowCount())));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private Object[] getRowInfo(String view_owner, String view_name, String create_time, short status) {
        Object[] data = new Object[]{GuiUt.rightTrim(view_owner), GuiUt.rightTrim(view_name), create_time, status == 0 ? this.res.getString("Invalid") : this.res.getString("Valid")};
        return data;
    }

    public void View_Create_Button_actionPerformed(ActionEvent e) {
        Wizard_view dlg = DbFrame.isWindows ? new Wizard_view(DbFrame.frame) : new Wizard_view(DbFrame.frame, "", true);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.setModal(true);
        dlg.show();
        String new_viewname = dlg.new_viewname;
        String new_viewowner = dlg.new_viewowner;
        if (new_viewname != null && new_viewname.length() > 0) {
            DbFrame.frame.treePanel.refreshViewTree();
            DbFrame.frame.treePanel.tree_valueChanged(null);
        }
        dlg = null;
    }

    public void View_Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        if (row >= this.table1.getRowCount() || row < 0) {
            return;
        }
        String view_owner = (String)this.model.getValueAt(row, 0);
        String view_name = (String)this.model.getValueAt(row, 1);
        if (DbFrame.conn_DatabaseConnection.dropView(GuiUt.rightTrim(view_owner), GuiUt.rightTrim(view_name))) {
            DbFrame.frame.treePanel.afterDropObject(2);
        }
    }

    void table1_mouseClicked(MouseEvent e) {
        int c = e.getClickCount();
        if (e.getClickCount() >= 2) {
            int row = this.table1.getSelectedRow();
            if (row < 0 || row >= this.absModel.getRowCount()) {
                return;
            }
            String view_owner = (String)this.absModel.getValueAt(row, 0);
            String view_name = (String)this.absModel.getValueAt(row, 1);
            DbFrame.frame.treePanel.openViewTree(view_owner, view_name);
        }
    }
}

