/*
 * Decompiled with CFR 0.152.
 */
package dbatool.View;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.Table.SchemaTableModel;
import dbatool.Table.UserGroupRenderer;
import dbatool.View.ViewDataPanel;
import dbatool.View.ViewPermissionRowInfo;
import dbatool.View.ViewPermissionTableModel;
import dbatool.tableCell.BooleanEditor;
import dbatool.tableCell.BooleanRenderer;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.editorPanel.SQLTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbmaker.sql.JdbcOdbcResultSet;
import dbmaker.sql.JdbcOdbcResultSetMetaData;
import dbmaker.sql.JdbcOdbcStatement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import queryAnalyzer.QueryFrame;

public class ViewInfo
extends DbaTabbedPane
implements ComponentPrivilege {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private SQLTextPane Prop_SQL = new SQLTextPane();
    private ViewPermissionTableModel permissionTableModel = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table = null;
    private DbaButton Permission_Cancel_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancel.gif"), new ReflectionAction(this, "Permission_Cancel_Button_actionPerformed"));
    private DbaButton Permission_Confirm_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Permission_Confirm_Button_actionPerformed"));
    private DbaButton Permission_Modify_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Permission_Modify_Button_actionPerformed"));
    private DbaButton Properties_Cancel_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancel.gif"), new ReflectionAction(this, "Properties_Cancel_Button_actionPerformed"));
    private DbaButton Properties_Confirm_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Properties_Confirm_Button_actionPerformed"));
    private DbaButton Properties_Modify_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Properties_Modify_Button_actionPerformed"));
    DBAResourceBundle res1 = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.TableRes", LocaleManager.getLocale());
    String view_owner = "";
    String view_name = "";
    String view_def = "";
    private String[] SchemaColumnNames = new String[]{this.res1.getString("Name"), this.res1.getString("Type"), this.res1.getString("Precision"), this.res1.getString("Scale"), this.res1.getString("Nullable"), this.res1.getString("Primary_Key"), this.res1.getString("Default_Attri1"), this.res1.getString("Default_Value"), this.res1.getString("Default_Attri2"), this.res1.getString("Constraint"), this.res1.getString("Encrypt")};
    private SchemaTableModel schemaTableModel = new SchemaTableModel(this.SchemaColumnNames);
    public ViewDataPanel viewDataPanel = null;
    private boolean isNeedGetData = false;
    private boolean Prop_Editing = false;

    public ViewInfo(String view_owner, String view_name) {
        try {
            this.view_owner = GuiUt.rightTrim(view_owner);
            this.view_name = GuiUt.rightTrim(view_name);
            this.authority = DbaAuthorityFactory.create(this);
            this.authority.authoriseOnce(this.view_owner, this.view_name);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getComponentType() {
        return 102;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.isNeedGetData = enabled;
    }

    @Override
    public void grant(boolean enabled) {
        if (this.view_owner.compareTo("SYSTEM") == 0) {
            this.Permission_Modify_Button.setEnabled(false);
        } else {
            this.Permission_Modify_Button.setEnabled(enabled);
        }
    }

    private void jbInit() throws Exception {
        this.setName("ViewTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "view.info.properties");
        DbaPanel jPanel2 = new DbaPanel(DbFrame.helpres, "view.info.permission");
        this.viewDataPanel = new ViewDataPanel("view.info.browseveiwdata", this);
        JPanel jPanel8 = new JPanel();
        jPanel8.setName("ViewSqlPanel");
        this.Prop_SQL.setName("ViewSqlEditor");
        JLabel jLabel3 = new JLabel();
        JScrollPane jScrollPane2 = new JScrollPane();
        JPanel jToolBar1 = new JPanel(new FlowLayout(0));
        JPanel jToolBar2 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane3 = new JScrollPane();
        JLabel jLabel1 = new JLabel();
        if (this.isNeedGetData) {
            this.getViewResultSchema();
        }
        this.permissionTableModel = new ViewPermissionTableModel(this.view_owner, this.view_name);
        this.absModel = new DBAToolAbstractTableModel(this.permissionTableModel);
        this.table = new JTable(this.absModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.setPreferredSize(new Dimension(300, 300));
        jPanel1.setLayout(new BorderLayout());
        jPanel8.setLayout(new BorderLayout());
        jLabel3.setText(this.res.getString("SQL_Script_a"));
        jPanel2.setLayout(new BorderLayout());
        jLabel1.setText(this.res.getString("SQL_Script_b"));
        jToolBar1.add((Component)this.Properties_Modify_Button, null);
        jToolBar1.add((Component)this.Properties_Confirm_Button, null);
        jToolBar1.add((Component)this.Properties_Cancel_Button, null);
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel1.add((Component)jToolBar1, "North");
        jPanel1.add((Component)jPanel8, "Center");
        jPanel8.add((Component)jScrollPane2, "Center");
        jPanel8.add((Component)jLabel1, "North");
        jScrollPane2.getViewport().add((Component)this.Prop_SQL, null);
        jPanel2.add((Component)jToolBar2, "North");
        jToolBar2.add((Component)this.Permission_Modify_Button, null);
        jToolBar2.add((Component)this.Permission_Confirm_Button, null);
        jToolBar2.add((Component)this.Permission_Cancel_Button, null);
        jPanel2.add((Component)jScrollPane3, "Center");
        jScrollPane3.getViewport().add((Component)this.table, null);
        this.add((Component)jPanel1, this.res.getTitle("Properties"));
        this.add((Component)jPanel2, this.res.getTitle("Permissions"));
        this.add((Component)this.viewDataPanel, this.res.getTitle("Browse_data"));
        this.setPropertiesEditable(false);
        this.setEditable(false);
        this.getViewInfo();
        this.getViewPermission();
        this.setUpUserGroupRenderer(this.table, 0);
        this.setUpBooleanRendererEditor(this.table);
        this.absModel.addMouseListenerToHeaderInTable(this.table);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ViewInfo.this.this_stateChanged(e);
            }
        });
        this.authority.authorise(this.view_owner);
        if (this.isNeedGetData) {
            this.setEnabledAt(2, true);
        } else {
            this.setEnabledAt(2, false);
        }
    }

    public ViewDataPanel getViewDataPanel() {
        return this.viewDataPanel;
    }

    @Override
    public void this_stateChanged(ChangeEvent e) {
        Component panel;
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getComponentCount()) {
            return;
        }
        if (index != 2) {
            // empty if block
        }
        if ((panel = this.getComponentAt(index)) instanceof DbaPanel) {
            String helpid2 = ((DbaPanel)panel).getHelpIDString();
            DbFrame.frame.setHelpMenuitem(helpid2);
            CSH.setHelpIDString((Component)this, (String)helpid2);
        } else if (panel instanceof QueryFrame) {
            String helpid3 = ((QueryFrame)panel).getHelpIDString();
            DbFrame.frame.setHelpMenuitem(helpid3);
            CSH.setHelpIDString((Component)this, (String)helpid3);
        }
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        switch (index) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (this.viewDataPanel.getComponentCount() != 0 || !this.isNeedGetData) break;
                this.viewDataPanel.initPanel();
            }
        }
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    private void setUpUserGroupRenderer(JTable table, int index) {
        TableColumn column = null;
        Object comp = null;
        column = table.getColumnModel().getColumn(index);
        column.setCellRenderer(new UserGroupRenderer());
    }

    private void setUpBooleanRendererEditor(JTable table) {
        table.setDefaultEditor(Boolean.class, new BooleanEditor(table, table.getModel()));
        table.setDefaultRenderer(Boolean.class, new BooleanRenderer(table.getBackground(), table.getSelectionBackground()));
    }

    private void setPropertiesEditable(boolean editable) {
        this.Properties_Modify_Button.setEnabled(!editable);
        this.Properties_Confirm_Button.setEnabled(editable);
        this.Properties_Cancel_Button.setEnabled(editable);
        this.Prop_SQL.setEditable(editable);
    }

    private void setEditable(boolean editable) {
        this.permissionTableModel.isEditable = editable;
        this.Prop_SQL.setEditable(editable);
        if (this.view_owner.compareTo("SYSTEM") == 0) {
            this.Permission_Modify_Button.setEnabled(false);
        } else {
            this.Permission_Modify_Button.setEnabled(!editable);
        }
        this.Permission_Confirm_Button.setEnabled(editable);
        this.Permission_Cancel_Button.setEnabled(editable);
        this.table.setForeground(editable ? Color.black : Color.gray);
        if (editable) {
            super.fixTabbedPanelAt(1);
        } else {
            super.releaseTabbedPanel();
        }
    }

    private void getViewInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select VIEW_DEFINITION from SYSTEM.SYSVIEWDATA where VIEW_OWNER = '" + this.view_owner + "' and VIEW_NAME = '" + this.view_name + "'";
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                this.view_def = rs.getString(1);
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            this.Prop_SQL.setText(this.view_def);
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private void getViewPermission() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ViewPermissionRowInfo aRow;
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            boolean includePublic = false;
            String query = "select USER_NAME, SEL_ALL, 'USER', DBA, RESOURCE from SYSAUTHUSER usr outer SYSAUTHTABLE au where usr.USER_NAME = au.GRANTEE and TABLE_OWNER = '" + this.view_owner + "' and TABLE_NAME = '" + this.view_name + "'" + " union all " + "select GROUP_NAME, SEL_ALL, 'GROUP', 0, 0 " + "from SYSAUTHMEMBER grp outer SYSAUTHTABLE au " + "where grp.GROUP_NAME = au.GRANTEE " + "and TABLE_OWNER = '" + this.view_owner + "' and TABLE_NAME = '" + this.view_name + "'" + " and GROUP_NAME != 'PUBLIC'" + " union all " + "select GRANTEE, SEL_ALL, 'GROUP', 0, 0 " + "from SYSAUTHTABLE au " + "where TABLE_OWNER = '" + this.view_owner + "' and TABLE_NAME = '" + this.view_name + "'" + " and GRANTEE = 'PUBLIC'";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String grantee = rs.getString(1);
                if (grantee.equals("PUBLIC")) {
                    includePublic = true;
                }
                short sel_all = rs.getShort(2);
                String type = rs.getString(3);
                short dba = rs.getShort(4);
                short resource = rs.getShort(5);
                aRow = new ViewPermissionRowInfo(grantee, dba >= 1 ? (short)1 : (resource == 1 && grantee.equals(this.view_owner) ? (short)1 : sel_all), type, dba >= 1, resource == 1);
                this.permissionTableModel.addValue(aRow);
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            if (!includePublic) {
                aRow = new ViewPermissionRowInfo("PUBLIC", 1, "GROUP");
                this.permissionTableModel.addValue(aRow);
            }
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public SchemaTableModel getViewResultSchema() {
        JdbcOdbcStatement dbmaker_stmt = null;
        JdbcOdbcResultSet dbmaker_rs = null;
        JdbcOdbcResultSetMetaData dbmaker_rsmd = null;
        if (this.schemaTableModel.getRowCount() > 0) {
            return this.schemaTableModel;
        }
        try {
            dbmaker_stmt = (JdbcOdbcStatement)DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            dbmaker_rs = (JdbcOdbcResultSet)dbmaker_stmt.executeQuery("Select * from \"" + this.view_owner + "\".\"" + this.view_name + "\" limit 0, 1");
            dbmaker_rsmd = (JdbcOdbcResultSetMetaData)dbmaker_rs.getMetaData();
            int columnCount = dbmaker_rsmd.getColumnCount();
            String columnName = null;
            String columnTypeName = null;
            String ownerName = null;
            String tableName = null;
            int length = 0;
            int scale = 0;
            int nullable = 1;
            int jdbcDisplaySize = 0;
            for (int i = 0; i < columnCount; ++i) {
                columnName = GuiUt.rightTrim(dbmaker_rsmd.getColumnName(i + 1));
                jdbcDisplaySize = dbmaker_rsmd.getColumnDisplaySize(i + 1);
                columnTypeName = dbmaker_rsmd.getColumnTypeName(i + 1);
                length = dbmaker_rsmd.getPrecision(i + 1);
                if (columnTypeName.equalsIgnoreCase("BINARY") || columnTypeName.equalsIgnoreCase("OID") || columnTypeName.equalsIgnoreCase("NCHAR") || columnTypeName.equalsIgnoreCase("NVARCHAR")) {
                    length /= 2;
                }
                scale = dbmaker_rsmd.getScale(i + 1);
                nullable = dbmaker_rsmd.isNullable(i + 1);
                ownerName = dbmaker_rsmd.getSchemaName(i + 1);
                tableName = dbmaker_rsmd.getTableName(i + 1);
                this.schemaTableModel.addValue(new DBARowInfo(this.getSchemeRowInfo(columnName, columnTypeName, length, scale, nullable, "", "", "", "", false)));
            }
            dbmaker_rs.close();
            dbmaker_stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(dbmaker_rs);
            DbaObject.close(dbmaker_stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        return this.schemaTableModel;
    }

    private Object[] getSchemeRowInfo(String name, String orig_type, int size, int scale, int nullable, String default_attri1, String default_value, String default_attri2, String constraint, boolean primaryKey) {
        String type = orig_type.toLowerCase();
        Object[] data = new Object[10];
        data[SchemaTableModel.NAME] = name;
        data[SchemaTableModel.TYPE] = type;
        data[SchemaTableModel.SIZE] = type.equals("binary") || type.equals("char") || type.equals("decimal") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar") ? Integer.toString(size) : new String("");
        data[SchemaTableModel.SCALE] = type.equals("decimal") ? Integer.toString(scale) : new String("");
        data[SchemaTableModel.NULLABLE] = nullable == 0 ? new Boolean(false) : new Boolean(true);
        data[SchemaTableModel.PRIMARYKEY] = new Boolean(primaryKey);
        data[SchemaTableModel.DEFAULT] = default_value;
        data[SchemaTableModel.DEFAULTATTRI1] = default_attri1;
        data[SchemaTableModel.DEFAULTATTRI2] = default_attri2;
        data[SchemaTableModel.CONSTRAINT] = constraint;
        return data;
    }

    public void Permission_Modify_Button_actionPerformed(ActionEvent e) {
        this.setEditable(true);
        this.permissionTableModel.removeAll();
        this.getViewPermission();
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        DbFrame.frame.setStatusDisc(this.res.getString("Start_modifying_view"));
    }

    public void Permission_Confirm_Button_actionPerformed(ActionEvent e) {
        boolean result;
        Vector vector = this.permissionTableModel.getUpdatingPermission(this.view_owner, this.view_name);
        StringBuffer query_sb = new StringBuffer();
        int count = vector.size();
        for (int i = 0; i < count; ++i) {
            query_sb.append((String)vector.elementAt(i)).append(";\n");
        }
        if (query_sb.length() > 0 && !(result = DatabaseConnection.executeMultiSQL(query_sb.toString()))) {
            return;
        }
        vector.removeAllElements();
        vector = null;
        this.Permission_Cancel_Button_actionPerformed(null);
    }

    public void Permission_Cancel_Button_actionPerformed(ActionEvent e) {
        this.setEditable(false);
        this.permissionTableModel.removeAll();
        this.getViewPermission();
        this.table.setForeground(Color.gray);
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        DbFrame.frame.setStatusDisc(this.res.getString("Cancel_modifying_view"));
    }

    public void Properties_Cancel_Button_actionPerformed(ActionEvent e) {
        this.getViewInfo();
        this.setPropertiesEditable(false);
        this.revalidate();
        this.repaint();
        this.releaseTabbedPanel();
        this.Properties_Modify_Button.setEnabled(true);
        DbFrame.frame.setStatusDisc(this.res.getString("Cancel_modifying_view"));
    }

    public void Properties_Confirm_Button_actionPerformed(ActionEvent e) {
        String new_view = this.Prop_SQL.getText();
        String new_view_Upper = new_view.toUpperCase();
        int as = new_view_Upper.indexOf(" AS ");
        String sub = new_view.substring(0, as + 4).toUpperCase();
        String regex = "\\b" + this.view_name + "\\b";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(sub);
        if (!matcher.find()) {
            this.Properties_Cancel_Button_actionPerformed(null);
            return;
        }
        String query = "";
        Statement stmt = null;
        if (!new_view.equalsIgnoreCase(this.view_def)) {
            query = new_view;
        }
        if (query.length() > 0) {
            JDialog dialog = new JDialog();
            GuiUt.setCenterLocation(DbFrame.frame, dialog);
            try {
                stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
                stmt.execute(query);
                stmt.close();
            }
            catch (SQLException e1) {
                GuiUt.showSQLException(dialog, null, e1);
                DbaObject.close(stmt);
                e1.printStackTrace();
            }
        }
        this.getViewInfo();
        this.setPropertiesEditable(false);
        this.schemaTableModel.removeAll();
        this.viewDataPanel.removeAll();
        this.releaseTabbedPanel();
        this.Properties_Modify_Button.setEnabled(true);
    }

    public void Properties_Modify_Button_actionPerformed(ActionEvent e) {
        this.fixTabbedPanelAt(this.getSelectedIndex());
        this.setPropertiesEditable(true);
        String sql_text = this.Prop_SQL.getText();
        String new_str = "";
        Pattern p = Pattern.compile("create\\s+view\\s", 2);
        Matcher match = p.matcher(sql_text);
        if (match.find()) {
            String out;
            new_str = out = match.replaceAll("CREATE OR REPLACE VIEW ");
        } else {
            p = Pattern.compile("create\\s+or\\s+replace\\s+view\\s", 2);
            match = p.matcher(sql_text);
            if (match.find()) {
                String out;
                new_str = out = match.replaceAll("CREATE OR REPLACE VIEW ");
            }
        }
        this.Prop_SQL.setText(new_str);
        DbFrame.frame.setStatusDisc(this.res.getString("Start_modifying_view"));
    }
}

