/*
 * Decompiled with CFR 0.152.
 */
package dbatool.View;

import com.borland.jbcl.layout.VerticalFlowLayout;
import dbatool.DbFrame;
import dbatool.Table.DataFilterDlg;
import dbatool.Table.DataTableModel;
import dbatool.Table.SchemaTableModel;
import dbatool.Table.SchemaType;
import dbatool.View.ViewInfo;
import dbatool.tableCell.BlobCellObject;
import dbatool.tableCell.BlobEditor;
import dbatool.tableCell.BlobEditorButton;
import dbatool.tableCell.BlobEditorButtonInterface;
import dbatool.tableCell.BlobEditorNoJAIButton;
import dbatool.tableCell.OidEditor;
import dbatool.tableCell.OidRenderer;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.DbaTable;
import dbaut.comp.ReflectionAction;
import dbaut.comp.TableColumnSelectionListener;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.DecimalField;
import dbaut.util.JdbcUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ViewDataPanel
extends DbaPanel {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DataTableModel dataModel = null;
    private DBAToolAbstractTableModel absDataModel = null;
    private DbaTable Table_Data = null;
    private JLabel infoLabel = new JLabel();
    private DbaTableModel schemaModel = null;
    private String view_owner = "";
    private String view_name = "";
    private int data_start = 0;
    private int data_end = 0;
    private int next_data_start = 0;
    private int data_max = 0;
    private int data_offset;
    private String where_text;
    private ViewInfo viewInfo;
    private int previous_row;
    private int current_row;
    private DbaButton Data_Down_Button;
    private DbaButton Data_Up_Button;
    private DbaButton Data_First_Button;
    private DbaButton Data_Last_Button;
    private DbaButton Filter_Button;
    private Statement stmt;
    private ResultSet rs;

    public ViewDataPanel(String helpid2, ViewInfo viewInfo) {
        super(DbFrame.helpres, helpid2);
        this.data_offset = DbFrame.frame.px.getNumRecord();
        this.where_text = "";
        this.viewInfo = null;
        this.previous_row = -1;
        this.current_row = -1;
        this.Data_Down_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Page_Down"), 'W', DBAImageResource.getResource(this.getClass(), "/jdbaimages/pagedown.gif"), new ReflectionAction(this, "Data_Down_Button_actionPerformed"));
        this.Data_Up_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Page_Up"), 'U', DBAImageResource.getResource(this.getClass(), "/jdbaimages/pageup.gif"), new ReflectionAction(this, "Data_Up_Button_actionPerformed"));
        this.Data_First_Button = new DbaButton(new Dimension(100, 24), this.res.getString("First"), 'F', DBAImageResource.getResource(this.getClass(), "/jdbaimages/datafirst.gif"), new ReflectionAction(this, "Data_First_Button_actionPerformed"));
        this.Data_Last_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Last"), 'L', DBAImageResource.getResource(this.getClass(), "/jdbaimages/datalast.gif"), new ReflectionAction(this, "Data_Last_Button_actionPerformed"));
        this.Filter_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Filter"), 'F', DBAImageResource.getResource(this.getClass(), "/jdbaimages/filter.gif"), new ReflectionAction(this, "Filter_Button_actionPerformed"));
        this.stmt = null;
        this.rs = null;
        this.viewInfo = viewInfo;
        this.view_owner = viewInfo.view_owner;
        this.view_name = viewInfo.view_name;
        this.res = viewInfo.res1;
    }

    public void initPanel() {
        if (this.getComponentCount() > 0) {
            return;
        }
        this.schemaModel = this.viewInfo.getViewResultSchema();
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        JPanel jPanel1 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.infoLabel.setText("");
        jPanel1.add((Component)jPanel7, null);
        jPanel7.add((Component)this.Filter_Button, null);
        jPanel7.add((Component)this.Data_Up_Button, null);
        jPanel7.add((Component)this.Data_Down_Button, null);
        jPanel7.add((Component)this.Data_First_Button, null);
        jPanel7.add((Component)this.Data_Last_Button, null);
        jPanel1.add((Component)jPanel2, null);
        jPanel2.add((Component)this.infoLabel, "Center");
        this.dataModel = new DataTableModel(this.schemaModel, this.view_owner, this.view_name);
        this.absDataModel = new DBAToolAbstractTableModel(this.dataModel);
        this.Table_Data = new DbaTable(this.absDataModel);
        this.dataModel.setTable(this.Table_Data);
        this.absDataModel.setTable(this.Table_Data, true);
        this.Table_Data.getTableHeader().setReorderingAllowed(false);
        this.Table_Data.setSelectionMode(0);
        this.Table_Data.setAutoResizeMode(0);
        this.Table_Data.addColumnSelectionListener(new TableColumnSelectionListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ViewDataPanel.this.TableColumnSelectionChanged(e);
                }
            }
        });
        this.Table_Data.addRowSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Component c = ViewDataPanel.this.Table_Data.getEditorComponent();
                if (e == null || !e.getValueIsAdjusting() || c != null && c instanceof BlobEditorButton) {
                    ViewDataPanel.this.TableRowSelectionChanged(e);
                }
            }
        });
        this.setUpCellEditor(this.Table_Data);
        this.setEditable(false);
        this.absDataModel.addMouseListenerToHeaderInTable(this.Table_Data);
        JScrollPane jScrollPane9 = new JScrollPane(this.Table_Data);
        jScrollPane9.setPreferredSize(new Dimension(200, 200));
        jPanel4.add((Component)jScrollPane9, "Center");
        TableColumnModel tcm = this.Table_Data.getColumnModel();
        TableColumn firstcolumn = tcm.getColumn(0);
        firstcolumn.setPreferredWidth(0);
        firstcolumn.setResizable(false);
        firstcolumn.setCellEditor(new OidEditor(this.Table_Data));
        firstcolumn.setCellRenderer(new OidRenderer());
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel4, "Center");
        this.add((Component)jPanel1, "North");
        this.setName("ViewDataPanel");
        this.Table_Data.setName("ViewDataPanelTable");
        this.getTableData();
    }

    public void closeResultSet() {
        DbaObject.close(this.rs);
        DbaObject.close(this.stmt);
    }

    private void setEditable(boolean editable) {
        if (editable) {
            this.Filter_Button.setEnabled(false);
            this.Data_Down_Button.setEnabled(false);
            this.Data_Up_Button.setEnabled(false);
        } else {
            this.Filter_Button.setEnabled(true);
        }
    }

    public void Data_First_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.next_data_start = 0;
        this.getTableData();
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void Data_Last_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        int i = this.data_max / this.data_offset;
        this.next_data_start = i * this.data_offset;
        this.getTableData();
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void Data_Down_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.next_data_start = this.data_end;
        this.getTableData();
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void Data_Up_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.next_data_start = this.data_start - this.data_offset;
        this.next_data_start = this.next_data_start < 0 ? 0 : this.next_data_start;
        this.getTableData();
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    private void setUpBlobEditor(JTable table, int index) {
        Class<?> jaicls = null;
        try {
            jaicls = Class.forName("javax.media.jai.widget.ScrollingImagePanel");
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe.getMessage());
        }
        JButton field = jaicls == null ? new BlobEditorNoJAIButton() : new BlobEditorButton();
        BlobEditor editor = new BlobEditor((BlobEditorButtonInterface)((Object)field), table, this.dataModel);
        TableColumn column = table.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
    }

    private void setUpCellEditor(JTable table) {
        int col_count = table.getColumnCount();
        String type = null;
        String precision = null;
        String scale = null;
        for (int i = 1; i < col_count; ++i) {
            type = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.TYPE);
            if (type.equals("integer") || type.equals("serial")) {
                this.Table_Data.setUpIntegerEditorStr(i);
                continue;
            }
            if (type.equals("bigint")) {
                this.Table_Data.setUpBigIntEditor(i);
                continue;
            }
            if (type.equals("bigserial")) {
                this.Table_Data.setUpBigSerialEditor(i);
                continue;
            }
            if (type.equals("smallint")) {
                this.Table_Data.setUpShortEditor(i);
                continue;
            }
            if (type.equals("double")) {
                this.Table_Data.setUpDoubleEditor(i);
                continue;
            }
            if (type.equals("decimal")) {
                precision = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.SIZE);
                scale = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.SCALE);
                this.Table_Data.setUpDecimalEditorStr(i, new DecimalField(Integer.parseInt(precision), Integer.parseInt(scale)));
                continue;
            }
            if (type.equals("real")) {
                this.Table_Data.setUpFloatEditor(i);
                continue;
            }
            if (type.equals("binary") || type.equals("oid")) {
                this.Table_Data.setUpBinaryEditor(i);
                continue;
            }
            if (type.equals("char") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar")) {
                this.Table_Data.setUpCharEditor(i);
                continue;
            }
            if (!SchemaType.isBlobType(type)) continue;
            this.setUpBlobEditor(table, i);
        }
    }

    private void getTableData() {
        ResultSet rs1 = null;
        try {
            int count = this.absDataModel.getColumnCount();
            this.stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement(1004, 1007);
            String query0 = "SELECT COUNT(*) FROM \"" + this.view_owner + "\".\"" + this.view_name + "\" ";
            String query = "SELECT * FROM \"" + this.view_owner + "\".\"" + this.view_name + "\" ";
            if (this.where_text.length() > 0) {
                String temp = this.where_text.toUpperCase();
                if ((temp = temp.trim()).indexOf("WHERE") == 0) {
                    query0 = query0 + this.where_text;
                    query = query + this.where_text;
                } else if (temp.indexOf("ORDER") == 0) {
                    query = query + this.where_text;
                } else {
                    query0 = query0 + "WHERE " + this.where_text;
                    query = query + "WHERE " + this.where_text;
                }
            }
            rs1 = this.stmt.executeQuery(query0);
            while (rs1.next()) {
                this.data_max = rs1.getInt(1);
            }
            DbaObject.close(rs1);
            query = query + " LIMIT " + this.next_data_start + "," + this.data_offset;
            this.rs = this.stmt.executeQuery(query);
            this.dataModel.removeAll();
            ArrayList<Object> one_row = null;
            BlobCellObject obj = null;
            Object temp = null;
            String type = null;
            String oid = "VIEW";
            int k = 0;
            Clob c = null;
            Blob b = null;
            int rowNum = 0;
            while (this.rs.next()) {
                ++rowNum;
                if (k >= this.data_offset) break;
                one_row = new ArrayList<Object>(count);
                one_row.add(oid);
                for (int i = 1; i < count; ++i) {
                    type = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.TYPE);
                    if (SchemaType.isBlobType(type)) {
                        long length;
                        if (SchemaType.isDomainType(type)) {
                            type = this.dataModel.types.elementAt(i - 1).toString();
                        }
                        if (type.equalsIgnoreCase("long varchar") || type.equalsIgnoreCase("clob")) {
                            c = this.rs.getClob(i);
                            length = this.rs.wasNull() ? -1L : (c != null ? c.length() : -1L);
                            JdbcUtil.free(c);
                        } else if (type.equalsIgnoreCase("nclob")) {
                            b = this.rs.getBlob(i);
                            length = this.rs.wasNull() ? -1L : (b != null ? b.length() : -1L);
                            JdbcUtil.free(b);
                        } else {
                            b = this.rs.getBlob(i);
                            length = this.rs.wasNull() ? -1L : (b != null ? b.length() : -1L);
                            JdbcUtil.free(b);
                        }
                        obj = new BlobCellObject(this.rs, rowNum, i, this.view_owner, this.view_name, this.absDataModel.getColumnName(i), type, length, this.rs.wasNull());
                        one_row.add(obj);
                        continue;
                    }
                    if (type.equals("binary")) {
                        temp = this.rs.getString(i);
                        one_row.add(this.rs.wasNull() ? null : temp.toString());
                        continue;
                    }
                    if (type.equals("char") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar") || type.equals("integer") || type.equals("smallint") || type.equals("bigint")) {
                        temp = this.rs.getObject(i);
                        one_row.add(this.rs.wasNull() ? null : temp.toString());
                        continue;
                    }
                    temp = this.rs.getString(i);
                    one_row.add(this.rs.wasNull() ? null : temp);
                }
                this.dataModel.addValue(one_row);
                ++k;
            }
            if (k >= this.data_offset) {
                this.Data_Down_Button.setEnabled(true);
            } else {
                this.Data_Down_Button.setEnabled(false);
            }
            if (this.next_data_start > 0) {
                this.Data_Up_Button.setEnabled(true);
            } else {
                this.Data_Up_Button.setEnabled(false);
            }
            this.data_start = this.next_data_start;
            this.data_end = this.next_data_start + k;
            if (this.data_max > this.data_end) {
                this.Data_Last_Button.setEnabled(true);
            } else {
                this.Data_Last_Button.setEnabled(false);
            }
            if (this.data_start - this.data_offset >= 0) {
                this.Data_First_Button.setEnabled(true);
            } else {
                this.Data_First_Button.setEnabled(false);
            }
            String s = GuiUt.mapStringForProperty(this.res.getString("records_selected"), Integer.toString(this.dataModel.getRowCount()));
            if (this.dataModel.getRowCount() > 0) {
                s = s + " (" + (this.data_start + 1) + " - " + this.data_end + ")";
            }
            this.infoLabel.setText(s);
            DbFrame.frame.setStatusDisc(s);
            this.absDataModel.fireTableChanged(new TableModelEvent(this.absDataModel));
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            DbaObject.close(this.rs);
            DbaObject.close(this.stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DbaObject.close(this.rs);
            DbaObject.close(this.stmt);
            GuiUt.showErrorDlg(DbFrame.frame, ex.getClass().toString() + ":" + ex.getMessage(), null);
        }
        if (this.dataModel.getRowCount() > 0) {
            this.Table_Data.setselectedCell(0, 0);
        }
    }

    public void Filter_Button_actionPerformed(ActionEvent e) {
        DataFilterDlg dlg = DbFrame.isWindows ? new DataFilterDlg(DbFrame.frame) : new DataFilterDlg(DbFrame.frame, "", true);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.setTitle(this.res.getString("Data_Filter"));
        dlg.setText(this.where_text);
        dlg.setVisible(true);
        if (dlg.getResult() != 0) {
            dlg.dispose();
            return;
        }
        this.where_text = dlg.getText().trim();
        if (dlg.getResult() == 0) {
            this.next_data_start = 0;
        }
        dlg.dispose();
        System.gc();
        if (this.where_text.length() > 0) {
            this.Filter_Button.setToolTipText(this.where_text);
        } else {
            this.Filter_Button.setToolTipText(null);
        }
        this.getTableData();
    }

    private void TableRowSelectionChanged(ListSelectionEvent e) {
        int row = this.Table_Data.getSelectedRow();
        if (this.current_row == row && e != null) {
            return;
        }
        this.current_row = row;
        int col = this.Table_Data.getSelectedColumn();
        if (row < 0 || col < 0) {
            return;
        }
        if (row >= this.dataModel.getRowCount() || col >= this.dataModel.getColumnCount()) {
            return;
        }
        if (this.previous_row == row) {
            return;
        }
        if (e != null && (this.previous_row < 0 || this.previous_row == row) || this.dataModel.withNewData(this.previous_row)) {
            // empty if block
        }
        if (row == this.dataModel.getRowCount() - 1 && this.dataModel.withNewData(row)) {
            this.dataModel.addEmptyRow();
            this.absDataModel.fireTableChanged(new TableModelEvent(this.absDataModel));
        }
        this.previous_row = row;
        this.Table_Data.editCellAt(row, col);
    }

    private void TableColumnSelectionChanged(ListSelectionEvent e) {
        int col = this.Table_Data.getSelectedColumn();
        int row = this.Table_Data.getSelectedRow();
        if (col < 0 || col >= this.Table_Data.getColumnCount()) {
            return;
        }
        if (row < 0 || row >= this.Table_Data.getRowCount()) {
            return;
        }
        this.Table_Data.editCellAt(row, col);
    }
}

