/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TreeNode;

import dbatool.DbFrame;
import dbatool.Popupmenu.List_Popupmenu;
import dbatool.TreeNode.DBATreeNode;
import dbatool.TreeNode.TableTreeNode;
import dbatool.Trigger.TriggerInfo;
import dbaut.GuiUt;
import dbaut.locale.LocaleChangeEvent;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public class TriggerTreeNode
extends DBATreeNode {
    private String name;
    private String table_owner;
    private String table_name;
    private static ImageIcon icon = null;
    private String toString = null;

    public TriggerTreeNode(String name, TableTreeNode parent_node) {
        this(parent_node.getTableOwner(), parent_node.getTableName(), name);
        this.toString = name;
    }

    public TriggerTreeNode(String table_owner, String table_name, String name) {
        this.table_name = GuiUt.rightTrim(table_name);
        this.table_owner = GuiUt.rightTrim(table_owner);
        this.name = GuiUt.rightTrim(name);
        this.toString = this.table_owner + "." + this.table_name + "." + this.name;
    }

    @Override
    public String getHelpID() {
        return "trigger.info";
    }

    public String getTableOwner() {
        return this.table_owner;
    }

    public String getTableName() {
        return this.table_name;
    }

    public String getTriggerName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/single_trigger.gif");
        }
        return icon;
    }

    @Override
    public void displayObject() {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(res.getString("Information_about"), res.getString("Trigger") + " " + this.name));
        DbFrame.frame.setContentPanel(new TriggerInfo(this.name, this.table_owner, this.table_name));
    }

    @Override
    public void displayMenu(MouseEvent e) {
        List_Popupmenu popup = new List_Popupmenu(this);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
    }

    @Override
    public boolean isFound(String s1, String s2, String s3) {
        return this.table_owner.equalsIgnoreCase(s1) && this.table_name.equalsIgnoreCase(s2) && this.name.equalsIgnoreCase(s3);
    }

    @Override
    public void refresh() {
        this.displayObject();
    }
}

